/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknTx;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Label;
import ai.grakn.concept.LabelId;
import ai.grakn.graql.analytics.SumQuery;
import ai.grakn.graql.internal.analytics.DegreeStatisticsVertexProgram;
import ai.grakn.graql.internal.analytics.SumMapReduce;
import ai.grakn.graql.internal.query.analytics.AbstractStatisticsQuery;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

class SumQueryImpl
extends AbstractStatisticsQuery<Optional<Number>>
implements SumQuery {
    SumQueryImpl(Optional<GraknTx> graph) {
        this.tx = graph;
    }

    public Optional<Number> execute() {
        LOGGER.info("SumMapReduce is called");
        long startTime = System.currentTimeMillis();
        this.initSubGraph();
        AttributeType.DataType dataType = this.getDataTypeOfSelectedResourceTypes();
        if (!this.selectedResourceTypesHaveInstance(this.statisticsResourceLabels)) {
            return Optional.empty();
        }
        Set<LabelId> allSubLabelIds = this.convertLabelsToIds(this.getCombinedSubTypes());
        Set<LabelId> statisticsResourceLabelIds = this.convertLabelsToIds(this.statisticsResourceLabels);
        ComputerResult result = this.getGraphComputer().compute((VertexProgram)new DegreeStatisticsVertexProgram(statisticsResourceLabelIds), (MapReduce)new SumMapReduce(statisticsResourceLabelIds, dataType, "degreeVertexProgram.degree"), allSubLabelIds);
        Map sum = (Map)result.memory().get(SumMapReduce.class.getName());
        Number finalResult = (Number)sum.get(MapReduce.NullObject.instance());
        LOGGER.info("Sum = " + finalResult);
        LOGGER.info("SumMapReduce is done in " + (System.currentTimeMillis() - startTime) + " ms");
        return Optional.of(finalResult);
    }

    public SumQuery of(String ... resourceTypeLabels) {
        return (SumQuery)this.setStatisticsResourceType(resourceTypeLabels);
    }

    public SumQuery of(Collection<Label> resourceLabels) {
        return (SumQuery)this.setStatisticsResourceType(resourceLabels);
    }

    public SumQuery in(String ... subTypeLabels) {
        return (SumQuery)super.in(subTypeLabels);
    }

    public SumQuery in(Collection<Label> subLabels) {
        return (SumQuery)super.in(subLabels);
    }

    public SumQuery withTx(GraknTx tx) {
        return (SumQuery)super.withTx(tx);
    }

    @Override
    String getName() {
        return "sum";
    }
}

