/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.match;

import ai.grakn.GraknTx;
import ai.grakn.concept.Concept;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.Aggregate;
import ai.grakn.graql.AggregateQuery;
import ai.grakn.graql.DeleteQuery;
import ai.grakn.graql.GetQuery;
import ai.grakn.graql.Graql;
import ai.grakn.graql.InsertQuery;
import ai.grakn.graql.Match;
import ai.grakn.graql.Order;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.MatchAdmin;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.query.Queries;
import ai.grakn.graql.internal.query.match.MatchLimit;
import ai.grakn.graql.internal.query.match.MatchOffset;
import ai.grakn.graql.internal.query.match.MatchOrder;
import ai.grakn.graql.internal.query.match.MatchTx;
import ai.grakn.graql.internal.query.match.Ordering;
import ai.grakn.graql.internal.util.AdminConverter;
import ai.grakn.util.CommonUtil;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

abstract class AbstractMatch
implements MatchAdmin {
    AbstractMatch() {
    }

    public final MatchAdmin admin() {
        return this;
    }

    public abstract Stream<Answer> stream(Optional<GraknTx> var1);

    public final Stream<Answer> stream() {
        return this.stream(Optional.empty());
    }

    public final Match withTx(GraknTx tx) {
        return new MatchTx(tx, this);
    }

    public final Match limit(long limit) {
        return new MatchLimit(this, limit);
    }

    public final Match offset(long offset) {
        return new MatchOffset(this, offset);
    }

    public final <S> AggregateQuery<S> aggregate(Aggregate<? super Answer, S> aggregate) {
        return Queries.aggregate(this.admin(), aggregate);
    }

    public final Stream<Concept> get(String var) {
        return this.get(Graql.var(var));
    }

    public final Stream<Concept> get(Var var) {
        return this.stream().map(result -> {
            if (!result.containsKey(var)) {
                throw GraqlQueryException.varNotInQuery((Var)var);
            }
            return result.get(var);
        });
    }

    public GetQuery get() {
        return this.get(this.getPattern().commonVars());
    }

    public GetQuery get(String var, String ... vars) {
        Stream<String> varStream = Stream.concat(Stream.of(var), Stream.of(vars));
        return this.get((Set)varStream.map(Graql::var).collect(CommonUtil.toImmutableSet()));
    }

    public GetQuery get(Var var, Var ... vars) {
        Stream<Var> varStream = Stream.concat(Stream.of(var), Stream.of(vars));
        return this.get((Set)varStream.collect(CommonUtil.toImmutableSet()));
    }

    public GetQuery get(Set<Var> vars) {
        return Queries.get((ImmutableSet<Var>)ImmutableSet.copyOf(vars), this);
    }

    public final InsertQuery insert(VarPattern ... vars) {
        return this.insert(Arrays.asList(vars));
    }

    public final InsertQuery insert(Collection<? extends VarPattern> vars) {
        ImmutableMultiset varAdmins = ImmutableMultiset.copyOf(AdminConverter.getVarAdmins(vars));
        return Queries.insert((ImmutableCollection<VarPatternAdmin>)varAdmins, this.admin());
    }

    public final DeleteQuery delete(String var, String ... vars) {
        List varList = Stream.concat(Stream.of(var), Arrays.stream(vars)).map(Graql::var).collect(Collectors.toList());
        return this.delete(varList);
    }

    public final DeleteQuery delete(Var ... vars) {
        return this.delete(Arrays.asList(vars));
    }

    public final DeleteQuery delete(Collection<? extends Var> vars) {
        return Queries.delete(vars, (Match)this);
    }

    public final Match orderBy(String varName) {
        return this.orderBy(varName, Order.asc);
    }

    public final Match orderBy(Var varName) {
        return this.orderBy(varName, Order.asc);
    }

    public final Match orderBy(String varName, Order order) {
        return this.orderBy(Graql.var(varName), order);
    }

    public final Match orderBy(Var varName, Order order) {
        return new MatchOrder(this, Ordering.of(varName, order));
    }
}

