/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.match;

import ai.grakn.GraknTx;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.Conjunction;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.query.match.AbstractMatch;
import ai.grakn.graql.internal.query.match.MatchModifier;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueries;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueryImpl;
import ai.grakn.graql.internal.reasoner.rule.RuleUtils;
import ai.grakn.util.CommonUtil;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Stream;

class MatchInfer
extends MatchModifier {
    private final boolean materialise;

    MatchInfer(AbstractMatch inner, boolean materialise) {
        super(inner);
        this.materialise = materialise;
    }

    @Override
    public Stream<Answer> stream(Optional<GraknTx> optionalGraph) {
        Stream<Answer> answerStream;
        GraknTx graph = (GraknTx)CommonUtil.optionalOr((Optional[])new Optional[]{optionalGraph, this.inner.tx()}).orElseThrow(GraqlQueryException::noTx);
        if (!RuleUtils.hasRules(graph)) {
            return this.inner.stream(optionalGraph);
        }
        Iterator conjIt = this.getPattern().getDisjunctiveNormalForm().getPatterns().iterator();
        Conjunction conj = (Conjunction)conjIt.next();
        ReasonerQueryImpl conjQuery = ReasonerQueries.create((Conjunction<VarPatternAdmin>)conj, graph);
        Stream<Object> stream = answerStream = conjQuery.isRuleResolvable() ? conjQuery.resolve(this.materialise) : graph.graql().match(new Pattern[]{conj}).stream();
        while (conjIt.hasNext()) {
            conj = (Conjunction)conjIt.next();
            conjQuery = ReasonerQueries.create((Conjunction<VarPatternAdmin>)conj, graph);
            Stream localStream = conjQuery.isRuleResolvable() ? conjQuery.resolve(this.materialise) : graph.graql().match(new Pattern[]{conj}).stream();
            answerStream = Stream.concat(answerStream, localStream);
        }
        return answerStream.map(result -> result.project(this.getSelectedNames()));
    }

    @Override
    protected String modifierString() {
        return "";
    }
}

