/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.predicate;

import ai.grakn.concept.AttributeType;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.ValuePredicate;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.query.predicate.EqPredicate;
import ai.grakn.util.Schema;
import ai.grakn.util.StringUtil;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;

abstract class ComparatorPredicate
implements ValuePredicate {
    private final Optional<Object> originalValue;
    private final Optional<Object> value;
    private final Optional<VarPatternAdmin> var;
    private static final String[] VALUE_PROPERTIES = (String[])AttributeType.DataType.SUPPORTED_TYPES.values().stream().map(AttributeType.DataType::getVertexProperty).distinct().map(Enum::name).toArray(String[]::new);

    ComparatorPredicate(Object value) {
        if (value instanceof VarPattern) {
            this.originalValue = Optional.empty();
            this.value = Optional.empty();
            this.var = Optional.of(((VarPattern)value).admin());
        } else {
            if (value instanceof Integer) {
                value = ((Integer)value).longValue();
            }
            this.originalValue = Optional.of(value);
            AttributeType.DataType dataType = (AttributeType.DataType)AttributeType.DataType.SUPPORTED_TYPES.get((Object)value.getClass().getName());
            if (dataType == null) {
                throw GraqlQueryException.invalidValueClass((Object)value);
            }
            value = dataType.getPersistenceValue(value);
            this.value = Optional.of(value);
            this.var = Optional.empty();
        }
    }

    ComparatorPredicate(VarPattern var) {
        this.originalValue = Optional.empty();
        this.value = Optional.empty();
        this.var = Optional.of(var.admin());
    }

    protected abstract String getSymbol();

    abstract <V> P<V> gremlinPredicate(V var1);

    public String toString() {
        String argument = this.value.map(StringUtil::valueToString).orElseGet(() -> this.var.get().getPrintableName());
        return this.getSymbol() + " " + argument;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComparatorPredicate that = (ComparatorPredicate)o;
        return this.value != null ? this.value.equals(that.value) : that.value == null;
    }

    public boolean isCompatibleWith(ValuePredicate predicate) {
        if (!(predicate instanceof EqPredicate)) {
            return false;
        }
        EqPredicate p = (EqPredicate)predicate;
        Object v = this.value.orElse(null);
        Object pval = p.equalsValue().orElse(null);
        return v == null || pval == null || this.gremlinPredicate(v).test(pval);
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public Optional<P<Object>> getPredicate() {
        return this.value.map(this::gremlinPredicate);
    }

    public Optional<VarPatternAdmin> getInnerVar() {
        return this.var;
    }

    public final <S, E> GraphTraversal<S, E> applyPredicate(GraphTraversal<S, E> traversal) {
        this.var.ifPresent(theVar -> {
            String thisVar = UUID.randomUUID().toString();
            Var otherVar = theVar.var();
            String otherValue = UUID.randomUUID().toString();
            Traversal[] traversals = (Traversal[])Stream.of(VALUE_PROPERTIES).map(prop -> __.values((String[])new String[]{prop}).as(otherValue, new String[0]).select(thisVar).values(new String[]{prop}).where(this.gremlinPredicate(otherValue))).toArray(Traversal[]::new);
            traversal.as(thisVar, new String[0]).select(otherVar.name()).or(traversals).select(thisVar);
        });
        this.value.ifPresent(theValue -> {
            AttributeType.DataType dataType = (AttributeType.DataType)AttributeType.DataType.SUPPORTED_TYPES.get((Object)this.originalValue.get().getClass().getTypeName());
            Schema.VertexProperty property = dataType.getVertexProperty();
            traversal.has(property.name(), this.gremlinPredicate(theValue));
        });
        return traversal;
    }
}

