/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner;

import ai.grakn.GraknTx;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.VarProperty;
import ai.grakn.graql.internal.gremlin.GraqlTraversal;
import ai.grakn.graql.internal.gremlin.GreedyTraversalPlan;
import ai.grakn.graql.internal.gremlin.fragment.Fragment;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.atom.AtomicBase;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.atom.predicate.NeqPredicate;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueries;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueryImpl;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ResolutionPlan {
    public static final int PARTIAL_SUBSTITUTION = 30;
    public static final int IS_RESOURCE_ATOM = 0;
    public static final int RESOURCE_REIFYING_RELATION = 20;
    public static final int IS_TYPE_ATOM = 0;
    public static final int IS_RELATION_ATOM = 2;
    public static final int NON_SPECIFIC_TYPE_ATOM = -1000;
    public static final int RULE_RESOLVABLE_ATOM = -10;
    public static final int RECURSIVE_ATOM = -5;
    public static final int GUARD = 1;
    public static final int BOUND_VARIABLE = -2;
    public static final int INEQUALITY_PREDICATE = -1000;
    public static final int SPECIFIC_VALUE_PREDICATE = 20;
    public static final int NON_SPECIFIC_VALUE_PREDICATE = 5;
    public static final int VARIABLE_VALUE_PREDICATE = -100;
    public static final int RESOURCE_SUPERNODE_SIZE = 5;
    public static final int COMPARISON_VARIABLE_VALUE_PREDICATE = -1000;
    private final ImmutableList<Atom> plan;
    private final GraknTx tx;

    public ResolutionPlan(ReasonerQueryImpl query) {
        this.tx = query.tx();
        this.plan = this.planFromTraversal(query);
        if (!this.isValid()) {
            throw GraqlQueryException.nonGroundNeqPredicate((ReasonerQuery)query);
        }
    }

    public String toString() {
        return this.plan.stream().map(AtomicBase::toString).collect(Collectors.joining("\n"));
    }

    private ImmutableList<Atom> planFromTraversal(ReasonerQueryImpl query) {
        HashMultimap propertyMap = HashMultimap.create();
        query.getAtoms(Atom.class).filter(Atomic::isSelectable).forEach(arg_0 -> ResolutionPlan.lambda$planFromTraversal$1((Multimap)propertyMap, arg_0));
        Set properties = propertyMap.keySet();
        GraqlTraversal graqlTraversal = GreedyTraversalPlan.createTraversal(query.getPattern(), this.tx);
        ImmutableList fragments = (ImmutableList)graqlTraversal.fragments().iterator().next();
        return ImmutableList.builder().addAll(fragments.stream().map(Fragment::varProperty).filter(Objects::nonNull).filter(properties::contains).distinct().flatMap(arg_0 -> ResolutionPlan.lambda$planFromTraversal$2((Multimap)propertyMap, arg_0)).distinct().iterator()).build();
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"})
    private ImmutableList<Atom> plan(ReasonerQueryImpl query) {
        return ImmutableList.builder().addAll(query.selectAtoms().stream().sorted(Comparator.comparing(at -> -at.baseResolutionPriority())).iterator()).build();
    }

    private boolean isValid() {
        HashSet nonGroundPredicates = new HashSet();
        HashSet<Var> mappedVars = new HashSet<Var>();
        for (Atom atom : this.plan) {
            mappedVars.addAll(atom.getVarNames());
            atom.getPredicates(NeqPredicate.class).forEach(neq -> {
                if (!mappedVars.containsAll(neq.getVarNames()) && !atom.getVarNames().containsAll(neq.getVarNames())) {
                    nonGroundPredicates.add(neq);
                } else if (nonGroundPredicates.contains(neq)) {
                    nonGroundPredicates.remove(neq);
                }
            });
        }
        return nonGroundPredicates.isEmpty();
    }

    public LinkedList<ReasonerQueryImpl> queryPlan() {
        LinkedList<ReasonerQueryImpl> queries = new LinkedList<ReasonerQueryImpl>();
        LinkedList<Atom> atoms = new LinkedList<Atom>((Collection<Atom>)this.plan);
        ArrayList<Atom> nonResolvableAtoms = new ArrayList<Atom>();
        while (!atoms.isEmpty()) {
            Atom top = atoms.remove();
            if (top.isRuleResolvable()) {
                if (!nonResolvableAtoms.isEmpty()) {
                    queries.add(ReasonerQueries.create(nonResolvableAtoms, this.tx));
                    nonResolvableAtoms.clear();
                }
                queries.add(ReasonerQueries.atomic(top));
                continue;
            }
            nonResolvableAtoms.add(top);
            if (!atoms.isEmpty()) continue;
            queries.add(ReasonerQueries.create(nonResolvableAtoms, this.tx));
        }
        return queries;
    }

    public LinkedList<ReasonerQueryImpl> localQueryPlan() {
        LinkedList<ReasonerQueryImpl> queries = new LinkedList<ReasonerQueryImpl>();
        LinkedList<Atom> atoms = new LinkedList<Atom>((Collection<Atom>)this.plan);
        Atom top = atoms.getFirst();
        ArrayList<Atom> nonResolvableAtoms = new ArrayList<Atom>();
        Set subbedVars = top.getParentQuery().getAtoms(IdPredicate.class).map(AtomicBase::getVarName).collect(Collectors.toSet());
        while (!atoms.isEmpty()) {
            subbedVars.addAll(top.getVarNames());
            atoms.remove(top);
            if (top.isRuleResolvable()) {
                if (!nonResolvableAtoms.isEmpty()) {
                    queries.add(ReasonerQueries.create(nonResolvableAtoms, this.tx));
                    nonResolvableAtoms.clear();
                }
                queries.add(ReasonerQueries.atomic(top));
            } else {
                nonResolvableAtoms.add(top);
                if (atoms.isEmpty()) {
                    queries.add(ReasonerQueries.create(nonResolvableAtoms, this.tx));
                }
            }
            if ((top = (Atom)top.getNeighbours(Atom.class).filter(atoms::contains).flatMap(at -> Stream.concat(Stream.of(at), at.getNeighbours(Atom.class).filter(atoms::contains))).sorted(Comparator.comparing(at -> -at.computePriority(subbedVars))).findFirst().orElse(null)) != null) continue;
            top = atoms.stream().sorted(Comparator.comparing(at -> -at.computePriority(subbedVars))).findFirst().orElse(null);
        }
        return queries;
    }

    private static /* synthetic */ Stream lambda$planFromTraversal$2(Multimap propertyMap, VarProperty p) {
        return propertyMap.get((Object)p).stream();
    }

    private static /* synthetic */ void lambda$planFromTraversal$1(Multimap propertyMap, Atom at) {
        at.getVarProperties().forEach(p -> propertyMap.put(p, (Object)at));
    }
}

