/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom;

import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Rule;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.MultiUnifier;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.admin.VarProperty;
import ai.grakn.graql.internal.reasoner.MultiUnifierImpl;
import ai.grakn.graql.internal.reasoner.atom.AtomicBase;
import ai.grakn.graql.internal.reasoner.atom.binary.RelationshipAtom;
import ai.grakn.graql.internal.reasoner.atom.binary.TypeAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.atom.predicate.NeqPredicate;
import ai.grakn.graql.internal.reasoner.atom.predicate.Predicate;
import ai.grakn.graql.internal.reasoner.rule.InferenceRule;
import ai.grakn.graql.internal.reasoner.rule.RuleUtils;
import ai.grakn.graql.internal.reasoner.utils.ReasonerUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public abstract class Atom
extends AtomicBase {
    private int basePriority = Integer.MAX_VALUE;
    private Set<InferenceRule> applicableRules = null;

    protected Atom(VarPatternAdmin pattern, ReasonerQuery par) {
        super(pattern, par);
    }

    protected Atom(Atom a) {
        super(a);
        this.applicableRules = a.applicableRules;
    }

    public RelationshipAtom toRelationshipAtom() {
        throw GraqlQueryException.illegalAtomConversion((Atomic)this);
    }

    public boolean isAtom() {
        return true;
    }

    public boolean isRuleResolvable() {
        return this.getApplicableRules().findFirst().isPresent();
    }

    public boolean isRecursive() {
        if (this.isResource() || this.getSchemaConcept() == null) {
            return false;
        }
        SchemaConcept schemaConcept = this.getSchemaConcept();
        return this.getApplicableRules().filter(rule -> rule.getBody().selectAtoms().stream().filter(at -> Objects.nonNull(at.getSchemaConcept())).filter(at -> ReasonerUtils.typesCompatible(schemaConcept, at.getSchemaConcept())).findFirst().isPresent()).filter(this::isRuleApplicable).findFirst().isPresent();
    }

    public Set<VarProperty> getVarProperties() {
        return this.getPattern().asVarPattern().getProperties().collect(Collectors.toSet());
    }

    protected Stream<IdPredicate> getPartialSubstitutions() {
        return Stream.empty();
    }

    public Set<Var> getRoleExpansionVariables() {
        return new HashSet<Var>();
    }

    private int computePriority() {
        return this.computePriority(this.getPartialSubstitutions().map(AtomicBase::getVarName).collect(Collectors.toSet()));
    }

    public int computePriority(Set<Var> subbedVars) {
        int priority = 0;
        priority += Sets.intersection(this.getVarNames(), subbedVars).size() * 30;
        priority += this.isRuleResolvable() ? -10 : 0;
        priority += this.isRecursive() ? -5 : 0;
        priority = (int)((long)priority + this.getTypeConstraints().count() * 1L);
        Set otherVars = this.getParentQuery().getAtoms().stream().filter(a -> a != this).flatMap(at -> at.getVarNames().stream()).collect(Collectors.toSet());
        priority += Sets.intersection(this.getVarNames(), otherVars).size() * -2;
        priority = (int)((long)priority + this.getPredicates(NeqPredicate.class).map(Predicate::getPredicate).filter(v -> !subbedVars.contains(v)).count() * -1000L);
        return priority;
    }

    public int baseResolutionPriority() {
        if (this.basePriority == Integer.MAX_VALUE) {
            this.basePriority = this.computePriority();
        }
        return this.basePriority;
    }

    private boolean isRuleApplicable(InferenceRule child) {
        return this.isRuleApplicableViaAtom(child.getRuleConclusionAtom());
    }

    protected abstract boolean isRuleApplicableViaAtom(Atom var1);

    private Stream<Rule> getPotentialRules() {
        return RuleUtils.getRulesWithType(this.getSchemaConcept(), this.tx());
    }

    public Stream<InferenceRule> getApplicableRules() {
        if (this.applicableRules == null) {
            this.applicableRules = new HashSet<InferenceRule>();
            return this.getPotentialRules().map(rule -> new InferenceRule((Rule)rule, this.tx())).filter(this::isRuleApplicable).map(r -> r.rewriteToUserDefined(this)).peek(this.applicableRules::add);
        }
        return this.applicableRules.stream();
    }

    public boolean requiresMaterialisation() {
        return false;
    }

    public boolean requiresRoleExpansion() {
        return false;
    }

    public abstract SchemaConcept getSchemaConcept();

    public abstract ConceptId getTypeId();

    public abstract Var getPredicateVariable();

    public Stream<Predicate> getPredicates() {
        return this.getPredicates(Predicate.class);
    }

    public <T extends Predicate> Stream<T> getPredicates(Class<T> type) {
        return this.getParentQuery().getAtoms(type).filter(atom -> !Sets.intersection(this.getVarNames(), atom.getVarNames()).isEmpty());
    }

    @Nullable
    public IdPredicate getIdPredicate(Var var) {
        return this.getPredicate(var, IdPredicate.class);
    }

    @Nullable
    public <T extends Predicate> T getPredicate(Var var, Class<T> type) {
        return (T)((Predicate)this.getPredicates(type).filter(p -> p.getVarName().equals((Object)var)).findFirst().orElse(null));
    }

    public abstract Stream<Predicate> getInnerPredicates();

    public <T extends Predicate> Stream<T> getInnerPredicates(Class<T> type) {
        return this.getInnerPredicates().filter(type::isInstance).map(type::cast);
    }

    public Stream<TypeAtom> getTypeConstraints() {
        return this.getParentQuery().getAtoms(TypeAtom.class).filter(atom -> atom != this).filter(atom -> this.containsVar(atom.getVarName()));
    }

    public <T extends Atomic> Stream<T> getNeighbours(Class<T> type) {
        return this.getParentQuery().getAtoms(type).filter(at -> at != this).filter(at -> !Sets.intersection(this.getVarNames(), (Set)at.getVarNames()).isEmpty());
    }

    public Stream<Atomic> getNonSelectableConstraints() {
        return Stream.concat(this.getPredicates(), this.getTypeConstraints().filter(at -> !at.isSelectable()));
    }

    public Set<TypeAtom> getSpecificTypeConstraints() {
        return new HashSet<TypeAtom>();
    }

    @Override
    public Atom inferTypes() {
        return this;
    }

    public List<Atom> atomOptions(Answer sub) {
        return Lists.newArrayList((Object[])new Atom[]{this.inferTypes()});
    }

    public Atom addType(SchemaConcept type) {
        return this;
    }

    public Atom rewriteToUserDefined(Atom parentAtom) {
        return this;
    }

    public abstract Unifier getUnifier(Atom var1);

    public MultiUnifier getMultiUnifier(Atom parentAtom, boolean exact) {
        return new MultiUnifierImpl(this.getUnifier(parentAtom));
    }
}

