/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom;

import ai.grakn.GraknTx;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.PatternAdmin;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.VarPatternAdmin;
import com.google.common.collect.Sets;
import java.util.Set;

public abstract class AtomicBase
implements Atomic {
    private final Var varName;
    private final PatternAdmin atomPattern;
    private ReasonerQuery parent = null;

    protected AtomicBase(VarPatternAdmin pattern, ReasonerQuery par) {
        this.atomPattern = pattern;
        this.varName = pattern.var();
        this.parent = par;
    }

    protected AtomicBase(AtomicBase a) {
        this.atomPattern = a.atomPattern;
        this.varName = this.atomPattern.asVarPattern().var();
        this.parent = a.getParentQuery();
    }

    public abstract Atomic copy();

    public String toString() {
        return this.atomPattern.toString();
    }

    public boolean containsVar(Var name) {
        return this.getVarNames().contains(name);
    }

    public boolean isUserDefined() {
        return this.varName.isUserDefinedName();
    }

    public Var getVarName() {
        return this.varName;
    }

    public Set<Var> getVarNames() {
        return Sets.newHashSet((Object[])new Var[]{this.varName});
    }

    public PatternAdmin getPattern() {
        return this.atomPattern;
    }

    public PatternAdmin getCombinedPattern() {
        return this.getPattern();
    }

    public ReasonerQuery getParentQuery() {
        return this.parent;
    }

    public void setParentQuery(ReasonerQuery q) {
        this.parent = q;
    }

    public Atomic inferTypes() {
        return this;
    }

    protected GraknTx tx() {
        return this.getParentQuery().tx();
    }
}

