/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom.binary;

import ai.grakn.concept.ConceptId;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Type;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.PatternAdmin;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.pattern.Patterns;
import ai.grakn.graql.internal.reasoner.UnifierImpl;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.atom.AtomicFactory;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.atom.predicate.Predicate;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public abstract class Binary
extends Atom {
    private final IdPredicate typePredicate;
    private final Var predicateVariable;
    private Type type = null;

    Binary(VarPatternAdmin pattern, Var predicateVar, @Nullable IdPredicate p, ReasonerQuery par) {
        super(pattern, par);
        this.predicateVariable = predicateVar;
        this.typePredicate = p;
    }

    Binary(Binary a) {
        super(a);
        this.predicateVariable = a.predicateVariable;
        this.typePredicate = a.getTypePredicate() != null ? (IdPredicate)AtomicFactory.create(a.getTypePredicate(), this.getParentQuery()) : null;
        this.type = a.type;
    }

    @Override
    public Var getPredicateVariable() {
        return this.predicateVariable;
    }

    @Nullable
    public IdPredicate getTypePredicate() {
        return this.typePredicate;
    }

    @Override
    @Nullable
    public SchemaConcept getSchemaConcept() {
        if (this.type == null && this.getTypePredicate() != null) {
            this.type = this.getParentQuery().tx().getConcept(this.getTypeId()).asType();
        }
        return this.type;
    }

    @Override
    public ConceptId getTypeId() {
        return this.typePredicate != null ? (ConceptId)this.typePredicate.getPredicate() : null;
    }

    public int equivalenceHashCode() {
        int hashCode = 1;
        hashCode = hashCode * 37 + (this.getTypeId() != null ? this.getTypeId().hashCode() : 0);
        return hashCode;
    }

    public boolean isEquivalent(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Binary a2 = (Binary)obj;
        return this.isUserDefined() == a2.isUserDefined() && Objects.equals(this.getTypeId(), a2.getTypeId()) && this.hasEquivalentPredicatesWith(a2);
    }

    boolean hasEquivalentPredicatesWith(Binary atom) {
        IdPredicate thisVarPredicate = this.getIdPredicate(this.getVarName());
        IdPredicate varPredicate = atom.getIdPredicate(atom.getVarName());
        IdPredicate thisTypePredicate = this.getTypePredicate();
        IdPredicate typePredicate = atom.getTypePredicate();
        return (thisVarPredicate == null && varPredicate == null || thisVarPredicate != null && thisVarPredicate.isEquivalent(varPredicate)) && (thisTypePredicate == null && typePredicate == null || thisTypePredicate != null && thisTypePredicate.isEquivalent(typePredicate));
    }

    @Override
    public PatternAdmin getCombinedPattern() {
        HashSet vars = Sets.newHashSet((Object[])new VarPatternAdmin[]{super.getPattern().asVarPattern()});
        if (this.getTypePredicate() != null) {
            vars.add(this.getTypePredicate().getPattern().asVarPattern());
        }
        return Patterns.conjunction(vars);
    }

    @Override
    public void setParentQuery(ReasonerQuery q) {
        super.setParentQuery(q);
        if (this.typePredicate != null) {
            this.typePredicate.setParentQuery(q);
        }
    }

    @Override
    public Set<Var> getVarNames() {
        HashSet<Var> vars = new HashSet<Var>();
        if (this.getVarName().isUserDefinedName()) {
            vars.add(this.getVarName());
        }
        if (!this.predicateVariable.getValue().isEmpty()) {
            vars.add(this.predicateVariable);
        }
        return vars;
    }

    @Override
    public Stream<Predicate> getInnerPredicates() {
        return Stream.of(this.typePredicate);
    }

    @Override
    public Unifier getUnifier(Atom parentAtom) {
        Var parentVarName;
        Var childVarName;
        if (!(parentAtom instanceof Binary)) {
            throw GraqlQueryException.unificationAtomIncompatibility();
        }
        UnifierImpl unifier = new UnifierImpl();
        Var childPredicateVarName = this.getPredicateVariable();
        Var parentPredicateVarName = parentAtom.getPredicateVariable();
        if (parentAtom.getVarName().isUserDefinedName() && !(childVarName = this.getVarName()).equals((Object)(parentVarName = parentAtom.getVarName()))) {
            unifier.addMapping(childVarName, parentVarName);
        }
        if (!(childPredicateVarName.getValue().isEmpty() || parentPredicateVarName.getValue().isEmpty() || childPredicateVarName.equals((Object)parentPredicateVarName))) {
            unifier.addMapping(childPredicateVarName, parentPredicateVarName);
        }
        return unifier;
    }
}

