/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom.binary;

import ai.grakn.GraknTx;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Label;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Type;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.MultiUnifier;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.RelationPlayer;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.pattern.property.IsaProperty;
import ai.grakn.graql.internal.pattern.property.RelationshipProperty;
import ai.grakn.graql.internal.query.QueryAnswer;
import ai.grakn.graql.internal.reasoner.MultiUnifierImpl;
import ai.grakn.graql.internal.reasoner.UnifierImpl;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.atom.AtomicBase;
import ai.grakn.graql.internal.reasoner.atom.binary.TypeAtom;
import ai.grakn.graql.internal.reasoner.atom.binary.type.IsaAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.atom.predicate.Predicate;
import ai.grakn.graql.internal.reasoner.atom.predicate.ValuePredicate;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueryImpl;
import ai.grakn.graql.internal.reasoner.utils.Pair;
import ai.grakn.graql.internal.reasoner.utils.ReasonerUtils;
import ai.grakn.graql.internal.reasoner.utils.conversion.RoleConverter;
import ai.grakn.graql.internal.reasoner.utils.conversion.TypeConverter;
import ai.grakn.util.CommonUtil;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class RelationshipAtom
extends IsaAtom {
    private int hashCode = 0;
    private ImmutableMultimap<Role, Var> roleVarMap = null;
    private ImmutableMultimap<Role, Type> roleTypeMap = null;
    private ImmutableMultimap<Role, String> roleConceptIdMap = null;
    private ImmutableList<RelationshipType> possibleRelations = null;
    private final ImmutableList<RelationPlayer> relationPlayers;
    private final ImmutableSet<Label> roleLabels;

    public RelationshipAtom(VarPatternAdmin pattern, Var predicateVar, @Nullable IdPredicate predicate, ReasonerQuery par) {
        super(pattern, predicateVar, predicate, par);
        ArrayList rps = new ArrayList();
        this.getPattern().asVarPattern().getProperty(RelationshipProperty.class).ifPresent(prop -> prop.relationPlayers().forEach(rps::add));
        this.relationPlayers = ImmutableList.copyOf(rps);
        this.roleLabels = ImmutableSet.builder().addAll(this.relationPlayers.stream().map(RelationPlayer::getRole).flatMap(CommonUtil::optionalToStream).map(VarPatternAdmin::getTypeLabel).flatMap(CommonUtil::optionalToStream).iterator()).build();
    }

    private RelationshipAtom(VarPatternAdmin pattern, Var predicateVar, @Nullable IdPredicate predicate, ImmutableList<RelationshipType> possibleRelations, ReasonerQuery par) {
        this(pattern, predicateVar, predicate, par);
        this.possibleRelations = possibleRelations;
    }

    private RelationshipAtom(RelationshipAtom a) {
        super(a);
        this.relationPlayers = a.relationPlayers;
        this.roleLabels = a.roleLabels;
        this.roleVarMap = a.roleVarMap;
        this.possibleRelations = a.possibleRelations;
    }

    @Override
    public RelationshipAtom toRelationshipAtom() {
        return this;
    }

    @Override
    public String toString() {
        String typeString = this.getSchemaConcept() != null ? this.getSchemaConcept().getLabel().getValue() : "{" + this.inferPossibleRelationTypes(new QueryAnswer()).stream().map(rt -> rt.getLabel().getValue()).collect(Collectors.joining(", ")) + "}";
        String relationString = (this.isUserDefined() ? this.getVarName() + " " : "") + typeString + this.getRelationPlayers().toString();
        return relationString + this.getPredicates(Predicate.class).map(AtomicBase::toString).collect(Collectors.joining(""));
    }

    private Set<Label> getRoleLabels() {
        return this.roleLabels;
    }

    private ImmutableList<RelationPlayer> getRelationPlayers() {
        return this.relationPlayers;
    }

    public Set<Var> getRolePlayers() {
        return this.getRelationPlayers().stream().map(c -> c.getRolePlayer().var()).collect(Collectors.toSet());
    }

    private Set<Var> getRoleVariables() {
        return this.getRelationPlayers().stream().map(RelationPlayer::getRole).flatMap(CommonUtil::optionalToStream).map(VarPatternAdmin::var).filter(Var::isUserDefinedName).collect(Collectors.toSet());
    }

    @Override
    public Atomic copy() {
        return new RelationshipAtom(this);
    }

    private VarPatternAdmin relationPattern(Var varName, List<RelationPlayer> relationPlayers) {
        Var var = varName;
        for (RelationPlayer rp : relationPlayers) {
            VarPattern rolePattern = rp.getRole().orElse(null);
            var = rolePattern == null ? var.rel((VarPattern)rp.getRolePlayer()) : var.rel(rolePattern, (VarPattern)rp.getRolePlayer());
        }
        return var.admin();
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 1;
            this.hashCode = this.hashCode * 37 + (this.getTypeId() != null ? this.getTypeId().hashCode() : 0);
            this.hashCode = this.hashCode * 37 + this.getVarNames().hashCode();
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        RelationshipAtom a2 = (RelationshipAtom)obj;
        return Objects.equals(this.getTypeId(), a2.getTypeId()) && this.getVarNames().equals(a2.getVarNames()) && this.getRelationPlayers().equals(a2.getRelationPlayers());
    }

    @Override
    public boolean isEquivalent(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        RelationshipAtom a2 = (RelationshipAtom)obj;
        return this.isUserDefined() == a2.isUserDefined() && Objects.equals(this.getTypeId(), a2.getTypeId()) && this.getRolePlayers().size() == a2.getRolePlayers().size() && this.getRelationPlayers().size() == a2.getRelationPlayers().size() && this.getRoleLabels().equals(a2.getRoleLabels()) && this.getRoleConceptIdMap().equals(a2.getRoleConceptIdMap()) && this.getRoleTypeMap().equals(a2.getRoleTypeMap());
    }

    @Override
    public int equivalenceHashCode() {
        int equivalenceHashCode = 1;
        equivalenceHashCode = equivalenceHashCode * 37 + (this.getTypeId() != null ? this.getTypeId().hashCode() : 0);
        equivalenceHashCode = equivalenceHashCode * 37 + this.getRoleConceptIdMap().hashCode();
        equivalenceHashCode = equivalenceHashCode * 37 + this.getRoleTypeMap().hashCode();
        equivalenceHashCode = equivalenceHashCode * 37 + this.getRoleLabels().hashCode();
        return equivalenceHashCode;
    }

    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public boolean isType() {
        return this.getSchemaConcept() != null;
    }

    @Override
    public boolean requiresMaterialisation() {
        return this.isUserDefined();
    }

    @Override
    public boolean requiresRoleExpansion() {
        return !this.getRoleVariables().isEmpty();
    }

    @Override
    public boolean isAllowedToFormRuleHead() {
        return this.getSchemaConcept() != null && this.getSchemaConcept().asType().isImplicit() == false && !this.hasMetaRoles() && !this.hasImplicitRoles();
    }

    private boolean hasMetaRoles() {
        return this.roleLabels.stream().filter(Schema.MetaSchema::isMetaLabel).findFirst().isPresent();
    }

    private boolean hasImplicitRoles() {
        return this.getRoleVarMap().keySet().stream().filter(SchemaConcept::isImplicit).findFirst().isPresent();
    }

    public Set<String> validateOntologically() {
        HashSet<String> errors = new HashSet<String>();
        SchemaConcept type = this.getSchemaConcept();
        if (type != null && !type.isRelationshipType()) {
            errors.add(ErrorMessage.VALIDATION_RULE_INVALID_RELATION_TYPE.getMessage(new Object[]{type.getLabel()}));
            return errors;
        }
        ImmutableMap varTypeMap = this.getParentQuery().getVarTypeMap();
        for (Map.Entry e : this.getRoleVarMap().asMap().entrySet()) {
            Role role = (Role)e.getKey();
            if (Schema.MetaSchema.isMetaLabel((Label)role.getLabel())) continue;
            if (type != null && type.asRelationshipType().relates().noneMatch(r -> r.equals(role))) {
                errors.add(ErrorMessage.VALIDATION_RULE_ROLE_CANNOT_BE_PLAYED.getMessage(new Object[]{role.getLabel(), type.getLabel()}));
            }
            for (Var player : (Collection)e.getValue()) {
                Type playerType = (Type)varTypeMap.get(player);
                if (playerType == null || !playerType.plays().noneMatch(plays -> plays.equals(role))) continue;
                errors.add(ErrorMessage.VALIDATION_RULE_TYPE_CANNOT_PLAY_ROLE.getMessage(new Object[]{playerType.getLabel(), role.getLabel(), type == null ? "" : type.getLabel()}));
            }
        }
        return errors;
    }

    @Override
    public int computePriority(Set<Var> subbedVars) {
        int priority = super.computePriority(subbedVars);
        return priority += 2;
    }

    @Override
    public Stream<IdPredicate> getPartialSubstitutions() {
        Set<Var> rolePlayers = this.getRolePlayers();
        return this.getPredicates(IdPredicate.class).filter(pred -> rolePlayers.contains(pred.getVarName()));
    }

    public Stream<IdPredicate> getRolePredicates() {
        return this.getRelationPlayers().stream().map(RelationPlayer::getRole).flatMap(CommonUtil::optionalToStream).filter(var -> var.var().isUserDefinedName()).filter(vp -> vp.getTypeLabel().isPresent()).map(vp -> {
            Label label = vp.getTypeLabel().orElse(null);
            return new IdPredicate(vp.var(), (Concept)this.tx().getRole(label.getValue()), this.getParentQuery());
        });
    }

    private Multimap<Role, String> getRoleConceptIdMap() {
        if (this.roleConceptIdMap == null) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            Map<Var, IdPredicate> varSubMap = this.getPartialSubstitutions().collect(Collectors.toMap(Atomic::getVarName, pred -> pred));
            Multimap<Role, Var> roleMap = this.getRoleVarMap();
            roleMap.entries().stream().filter(e -> varSubMap.containsKey(e.getValue())).sorted(Comparator.comparing(e -> ((IdPredicate)varSubMap.get(e.getValue())).getPredicateValue())).forEach(e -> builder.put(e.getKey(), (Object)((IdPredicate)varSubMap.get(e.getValue())).getPredicateValue()));
            this.roleConceptIdMap = builder.build();
        }
        return this.roleConceptIdMap;
    }

    private Multimap<Role, Type> getRoleTypeMap() {
        if (this.roleTypeMap == null) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            Multimap<Role, Var> roleMap = this.getRoleVarMap();
            ImmutableMap varTypeMap = this.getParentQuery().getVarTypeMap();
            roleMap.entries().stream().filter(arg_0 -> RelationshipAtom.lambda$getRoleTypeMap$13((Map)varTypeMap, arg_0)).sorted(Comparator.comparing(arg_0 -> RelationshipAtom.lambda$getRoleTypeMap$14((Map)varTypeMap, arg_0))).forEach(arg_0 -> RelationshipAtom.lambda$getRoleTypeMap$15(builder, (Map)varTypeMap, arg_0));
            this.roleTypeMap = builder.build();
        }
        return this.roleTypeMap;
    }

    @Override
    public boolean isRuleApplicableViaAtom(Atom ruleAtom) {
        if (ruleAtom.isResource()) {
            return this.isRuleApplicableViaAtom(ruleAtom.toRelationshipAtom());
        }
        if (!(ruleAtom instanceof RelationshipAtom)) {
            return false;
        }
        RelationshipAtom headAtom = (RelationshipAtom)ruleAtom;
        RelationshipAtom atomWithType = this.addType(headAtom.getSchemaConcept()).inferRoles(new QueryAnswer());
        return headAtom.getRelationPlayers().size() >= atomWithType.getRelationPlayers().size() && !headAtom.getRelationPlayerMappings(atomWithType).isEmpty();
    }

    private Stream<Role> getExplicitRoles() {
        ReasonerQueryImpl parent = (ReasonerQueryImpl)this.getParentQuery();
        GraknTx graph = parent.tx();
        return this.getRelationPlayers().stream().map(RelationPlayer::getRole).flatMap(CommonUtil::optionalToStream).map(VarPatternAdmin::getTypeLabel).flatMap(CommonUtil::optionalToStream).map(arg_0 -> ((GraknTx)graph).getSchemaConcept(arg_0));
    }

    @Override
    public RelationshipAtom addType(SchemaConcept type) {
        Pair<VarPatternAdmin, IdPredicate> typedPair = this.getTypedPair(type);
        return new RelationshipAtom(typedPair.getKey(), typedPair.getValue().getVarName(), typedPair.getValue(), this.getParentQuery());
    }

    private Set<Type> inferPossibleEntityTypes(Answer sub) {
        return this.inferPossibleRelationConfigurations(sub).asMap().entrySet().stream().flatMap(e -> {
            Set rs = ((RelationshipType)e.getKey()).relates().collect(Collectors.toSet());
            rs.removeAll((Collection)e.getValue());
            return rs.stream().flatMap(Role::playedByTypes);
        }).collect(Collectors.toSet());
    }

    private Multimap<RelationshipType, Role> inferPossibleRelationConfigurations(Answer sub) {
        Set roles = this.getExplicitRoles().filter(r -> !Schema.MetaSchema.isMetaLabel((Label)r.getLabel())).collect(Collectors.toSet());
        ImmutableMap varTypeMap = this.getParentQuery().getVarTypeMap(sub);
        Set types = this.getRolePlayers().stream().filter(((Map)varTypeMap)::containsKey).map(((Map)varTypeMap)::get).collect(Collectors.toSet());
        if (roles.isEmpty() && types.isEmpty()) {
            RelationshipType metaRelationType = this.tx().admin().getMetaRelationType();
            HashMultimap compatibleTypes = HashMultimap.create();
            metaRelationType.subs().filter(rt -> !rt.equals(metaRelationType)).forEach(arg_0 -> RelationshipAtom.lambda$inferPossibleRelationConfigurations$19((Multimap)compatibleTypes, arg_0));
            return compatibleTypes;
        }
        Multimap<RelationshipType, Role> compatibleTypesFromRoles = ReasonerUtils.compatibleRelationTypesWithRoles(roles, new RoleConverter());
        Multimap<RelationshipType, Role> compatibleTypesFromTypes = ReasonerUtils.compatibleRelationTypesWithRoles(types, new TypeConverter());
        Multimap<RelationshipType, Role> compatibleTypes = roles.isEmpty() ? compatibleTypesFromTypes : (compatibleTypesFromRoles.isEmpty() || types.isEmpty() ? compatibleTypesFromRoles : ReasonerUtils.multimapIntersection(compatibleTypesFromTypes, compatibleTypesFromRoles));
        return compatibleTypes;
    }

    public ImmutableList<RelationshipType> inferPossibleRelationTypes(Answer sub) {
        if (this.getSchemaConcept() != null) {
            return ImmutableList.of((Object)this.getSchemaConcept().asRelationshipType());
        }
        if (this.possibleRelations == null) {
            Multimap<RelationshipType, Role> compatibleConfigurations = this.inferPossibleRelationConfigurations(sub);
            Sets.SetView untypedRoleplayers = Sets.difference(this.getRolePlayers(), (Set)this.getParentQuery().getVarTypeMap().keySet());
            Set untypedNeighbours = this.getNeighbours(RelationshipAtom.class).filter(arg_0 -> RelationshipAtom.lambda$inferPossibleRelationTypes$20((Set)untypedRoleplayers, arg_0)).collect(Collectors.toSet());
            ImmutableList.Builder builder = ImmutableList.builder();
            compatibleConfigurations.asMap().entrySet().stream().sorted(Comparator.comparing(e -> -((Collection)e.getValue()).size())).sorted(Comparator.comparing(e -> ((RelationshipType)e.getKey()).relates().count() != (long)this.getRelationPlayers().size())).sorted(Comparator.comparing(e -> ((RelationshipType)e.getKey()).isImplicit())).map(e -> {
                if (untypedNeighbours.isEmpty()) {
                    return new Pair(e.getKey(), 0L);
                }
                Iterator neighbourIterator = untypedNeighbours.iterator();
                Sets.SetView typesFromNeighbour = ((RelationshipAtom)neighbourIterator.next()).inferPossibleEntityTypes(sub);
                while (neighbourIterator.hasNext()) {
                    typesFromNeighbour = Sets.intersection(typesFromNeighbour, ((RelationshipAtom)neighbourIterator.next()).inferPossibleEntityTypes(sub));
                }
                Set rs = ((RelationshipType)e.getKey()).relates().collect(Collectors.toSet());
                rs.removeAll((Collection)e.getValue());
                return new Pair(e.getKey(), rs.stream().flatMap(Role::playedByTypes).filter(((Set)typesFromNeighbour)::contains).count());
            }).sorted(Comparator.comparing(p -> -((Long)p.getValue()).longValue())).map(Pair::getKey).filter(t -> Sets.intersection(ReasonerUtils.supers((SchemaConcept)t), (Set)compatibleConfigurations.keySet()).isEmpty()).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            this.possibleRelations = builder.build();
        }
        return this.possibleRelations;
    }

    private RelationshipAtom inferRelationshipType(Answer sub) {
        if (this.getTypePredicate() != null) {
            return this;
        }
        ImmutableList<RelationshipType> relationshipTypes = this.inferPossibleRelationTypes(sub);
        if (relationshipTypes.size() == 1) {
            return this.addType((SchemaConcept)relationshipTypes.iterator().next());
        }
        return this;
    }

    @Override
    public RelationshipAtom inferTypes() {
        return this.inferRelationshipType(new QueryAnswer()).inferRoles(new QueryAnswer());
    }

    @Override
    public List<Atom> atomOptions(Answer sub) {
        return this.inferPossibleRelationTypes(sub).stream().map(this::addType).map(at -> at.inferRoles(sub)).sorted(Comparator.comparing(at -> -at.getRoleLabels().size())).sorted(Comparator.comparing(Atom::isRuleResolvable)).collect(Collectors.toList());
    }

    @Override
    public Set<Var> getVarNames() {
        Set<Var> vars = super.getVarNames();
        vars.addAll(this.getRolePlayers());
        vars.addAll(this.getRoleVariables());
        return vars;
    }

    @Override
    public Set<Var> getRoleExpansionVariables() {
        return this.getRelationPlayers().stream().map(RelationPlayer::getRole).flatMap(CommonUtil::optionalToStream).filter(p -> p.var().isUserDefinedName()).filter(p -> !p.getTypeLabel().isPresent()).map(VarPatternAdmin::var).collect(Collectors.toSet());
    }

    private Set<Var> getSpecificRolePlayers() {
        return this.getRoleVarMap().entries().stream().filter(e -> !Schema.MetaSchema.isMetaLabel((Label)((Role)e.getKey()).getLabel())).map(Map.Entry::getValue).collect(Collectors.toSet());
    }

    @Override
    public Set<TypeAtom> getSpecificTypeConstraints() {
        Set<Var> mappedVars = this.getSpecificRolePlayers();
        return this.getTypeConstraints().filter(t -> mappedVars.contains(t.getVarName())).filter(t -> Objects.nonNull(t.getSchemaConcept())).collect(Collectors.toSet());
    }

    @Override
    public Stream<Predicate> getInnerPredicates() {
        return Stream.concat(super.getInnerPredicates(), this.getRelationPlayers().stream().map(RelationPlayer::getRole).flatMap(CommonUtil::optionalToStream).filter(vp -> vp.var().isUserDefinedName()).map(vp -> new Pair<Var, Object>(vp.var(), vp.getTypeLabel().orElse(null))).filter(p -> Objects.nonNull(p.getValue())).map(p -> new IdPredicate((Var)p.getKey(), (Label)p.getValue(), this.getParentQuery())));
    }

    private RelationshipAtom inferRoles(Answer sub) {
        boolean roleRecomputationViable;
        List explicitRoles = this.getExplicitRoles().collect(Collectors.toList());
        ImmutableMap varTypeMap = this.getParentQuery().getVarTypeMap(sub);
        boolean allRolesMeta = explicitRoles.stream().allMatch(role -> Schema.MetaSchema.isMetaLabel((Label)role.getLabel()));
        boolean bl = roleRecomputationViable = allRolesMeta && (!sub.isEmpty() || !Sets.intersection(varTypeMap.keySet(), this.getRolePlayers()).isEmpty());
        if (explicitRoles.size() == this.getRelationPlayers().size() && !roleRecomputationViable) {
            return this;
        }
        GraknTx graph = this.getParentQuery().tx();
        Role metaRole = graph.admin().getMetaRole();
        ArrayList allocatedRelationPlayers = new ArrayList();
        RelationshipType relType = this.getSchemaConcept() != null ? this.getSchemaConcept().asRelationshipType() : null;
        ArrayList<RelationPlayer> inferredRelationPlayer = new ArrayList<RelationPlayer>();
        this.getRelationPlayers().forEach(rp -> {
            Label roleLabel;
            Var varName = rp.getRolePlayer().var();
            VarPatternAdmin rolePattern = rp.getRole().orElse(null);
            if (!(rolePattern == null || (roleLabel = (Label)rolePattern.getTypeLabel().orElse(null)) != null && Schema.MetaSchema.isMetaLabel((Label)roleLabel))) {
                inferredRelationPlayer.add(RelationPlayer.of((VarPatternAdmin)rolePattern, (VarPatternAdmin)varName.admin()));
                allocatedRelationPlayers.add(rp);
            }
        });
        Set possibleRoles = relType != null ? relType.relates().collect(Collectors.toSet()) : this.inferPossibleRelationTypes(sub).stream().flatMap(RelationshipType::relates).collect(Collectors.toSet());
        HashMap mappings = new HashMap();
        this.getRelationPlayers().stream().filter(rp -> !allocatedRelationPlayers.contains(rp)).forEach(arg_0 -> RelationshipAtom.lambda$inferRoles$41((Map)varTypeMap, mappings, possibleRoles, arg_0));
        mappings.entrySet().stream().filter(entry -> ((Set)entry.getValue()).size() == 1).forEach(entry -> {
            RelationPlayer rp = (RelationPlayer)entry.getKey();
            Var varName = rp.getRolePlayer().var();
            Role role = (Role)Iterables.getOnlyElement((Iterable)((Iterable)entry.getValue()));
            VarPatternAdmin rolePattern = Graql.var().label(role.getLabel()).admin();
            inferredRelationPlayer.add(RelationPlayer.of((VarPatternAdmin)rolePattern, (VarPatternAdmin)varName.admin()));
            allocatedRelationPlayers.add(rp);
        });
        this.getRelationPlayers().stream().filter(rp -> !allocatedRelationPlayers.contains(rp)).forEach(rp -> {
            Var varName = rp.getRolePlayer().var();
            VarPatternAdmin rolePattern = rp.getRole().orElse(null);
            rolePattern = rolePattern != null ? rolePattern.var().label(metaRole.getLabel()).admin() : Graql.var().label(metaRole.getLabel()).admin();
            inferredRelationPlayer.add(RelationPlayer.of((VarPatternAdmin)rolePattern, (VarPatternAdmin)varName.admin()));
        });
        VarPatternAdmin newPattern = this.relationPattern(this.getVarName(), inferredRelationPlayer).asVarPattern().isa((VarPattern)this.getPredicateVariable()).admin();
        return new RelationshipAtom(newPattern, this.getPredicateVariable(), this.getTypePredicate(), this.possibleRelations, this.getParentQuery());
    }

    public Multimap<Role, Var> getRoleVarMap() {
        if (this.roleVarMap == null) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            GraknTx graph = this.getParentQuery().tx();
            this.getRelationPlayers().forEach(c -> {
                Var varName = c.getRolePlayer().var();
                VarPatternAdmin role = c.getRole().orElse(null);
                if (role != null) {
                    IdPredicate rolePredicate;
                    Role roleType;
                    Label typeLabel = role.getTypeLabel().orElse(null);
                    Role role2 = roleType = typeLabel != null ? graph.getRole(typeLabel.getValue()) : null;
                    if (roleType == null && role.var().isUserDefinedName() && (rolePredicate = this.getIdPredicate(role.var())) != null) {
                        roleType = (Role)graph.getConcept((ConceptId)rolePredicate.getPredicate());
                    }
                    if (roleType != null) {
                        builder.put((Object)roleType, (Object)varName);
                    }
                }
            });
            this.roleVarMap = builder.build();
        }
        return this.roleVarMap;
    }

    private Multimap<Role, RelationPlayer> getRoleRelationPlayerMap() {
        ArrayListMultimap roleRelationPlayerMap = ArrayListMultimap.create();
        Multimap<Role, Var> roleVarMap = this.getRoleVarMap();
        ImmutableList<RelationPlayer> relationPlayers = this.getRelationPlayers();
        roleVarMap.asMap().entrySet().forEach(arg_0 -> RelationshipAtom.lambda$getRoleRelationPlayerMap$49(relationPlayers, (Multimap)roleRelationPlayerMap, arg_0));
        return roleRelationPlayerMap;
    }

    private Set<List<Pair<RelationPlayer, RelationPlayer>>> getRelationPlayerMappings(RelationshipAtom parentAtom) {
        return this.getRelationPlayerMappings(parentAtom, false);
    }

    private Set<List<Pair<RelationPlayer, RelationPlayer>>> getRelationPlayerMappings(RelationshipAtom parentAtom, boolean exact) {
        Multimap<Role, RelationPlayer> childRoleRPMap = this.getRoleRelationPlayerMap();
        ImmutableMap childVarTypeMap = this.getParentQuery().getVarTypeMap();
        ImmutableMap parentVarTypeMap = parentAtom.getParentQuery().getVarTypeMap();
        ArrayList compatibleMappingsPerParentRP = new ArrayList();
        ReasonerQueryImpl childQuery = (ReasonerQueryImpl)this.getParentQuery();
        Set childRoles = childRoleRPMap.keySet();
        parentAtom.getRelationPlayers().stream().filter(prp -> prp.getRole().isPresent()).forEach(arg_0 -> this.lambda$getRelationPlayerMappings$57((Map)parentVarTypeMap, childRoles, childRoleRPMap, (Map)childVarTypeMap, exact, childQuery, parentAtom, compatibleMappingsPerParentRP, arg_0));
        return Sets.cartesianProduct(compatibleMappingsPerParentRP).stream().filter(list -> !list.isEmpty()).filter(list -> {
            List listChildRps = list.stream().map(Pair::getKey).collect(Collectors.toList());
            return ReasonerUtils.subtract(listChildRps, this.getRelationPlayers()).isEmpty();
        }).filter(list -> {
            List listParentRps = list.stream().map(Pair::getValue).collect(Collectors.toList());
            return listParentRps.containsAll((Collection<?>)parentAtom.getRelationPlayers());
        }).collect(Collectors.toSet());
    }

    @Override
    public Unifier getUnifier(Atom pAtom) {
        return this.getMultiUnifier(pAtom, true).getUnifier();
    }

    @Override
    public MultiUnifier getMultiUnifier(Atom pAtom, boolean exact) {
        if (this.equals(pAtom)) {
            return new MultiUnifierImpl();
        }
        Unifier baseUnifier = super.getUnifier(pAtom);
        HashSet<Unifier> unifiers = new HashSet<Unifier>();
        if (pAtom.isRelation()) {
            assert (pAtom instanceof RelationshipAtom);
            RelationshipAtom parentAtom = (RelationshipAtom)pAtom;
            boolean unifyRoleVariables = parentAtom.getRelationPlayers().stream().map(RelationPlayer::getRole).flatMap(CommonUtil::optionalToStream).filter(rp -> rp.var().isUserDefinedName()).findFirst().isPresent();
            this.getRelationPlayerMappings(parentAtom, exact).forEach(mappings -> {
                UnifierImpl unifier = new UnifierImpl(baseUnifier);
                mappings.forEach(rpm -> {
                    unifier.addMapping(((RelationPlayer)rpm.getKey()).getRolePlayer().var(), ((RelationPlayer)rpm.getValue()).getRolePlayer().var());
                    VarPattern childRolePattern = ((RelationPlayer)rpm.getKey()).getRole().orElse(null);
                    VarPattern parentRolePattern = ((RelationPlayer)rpm.getValue()).getRole().orElse(null);
                    if (parentRolePattern != null && childRolePattern != null && unifyRoleVariables) {
                        unifier.addMapping(childRolePattern.admin().var(), parentRolePattern.admin().var());
                    }
                });
                unifiers.add(unifier);
            });
        } else {
            unifiers.add(baseUnifier);
        }
        return new MultiUnifierImpl(unifiers);
    }

    private RelationshipAtom rewriteWithVariableRoles(Atom parentAtom) {
        if (!parentAtom.requiresRoleExpansion()) {
            return this;
        }
        VarPattern relVar = this.getPattern().asVarPattern().getProperty(IsaProperty.class).map(prop -> this.getVarName().isa((VarPattern)prop.type())).orElse((VarPattern)this.getVarName());
        for (RelationPlayer rp : this.getRelationPlayers()) {
            VarPatternAdmin rolePattern = rp.getRole().orElse(null);
            if (rolePattern != null) {
                Var roleVar = rolePattern.var();
                Label roleLabel = rolePattern.getTypeLabel().orElse(null);
                relVar = relVar.rel(roleVar.asUserDefined().label(roleLabel), (VarPattern)rp.getRolePlayer());
                continue;
            }
            relVar = relVar.rel((VarPattern)rp.getRolePlayer());
        }
        return new RelationshipAtom(relVar.admin(), this.getPredicateVariable(), this.getTypePredicate(), this.getParentQuery());
    }

    private RelationshipAtom rewriteWithRelationVariable(Atom parentAtom) {
        if (!parentAtom.getVarName().isUserDefinedName()) {
            return this;
        }
        Var newVar = Graql.var().asUserDefined();
        VarPattern relVar = this.getPattern().asVarPattern().getProperty(IsaProperty.class).map(arg_0 -> RelationshipAtom.lambda$rewriteWithRelationVariable$65((VarPattern)newVar, arg_0)).orElse((VarPattern)newVar);
        for (RelationPlayer c : this.getRelationPlayers()) {
            VarPatternAdmin roleType = c.getRole().orElse(null);
            if (roleType != null) {
                relVar = relVar.rel((VarPattern)roleType, (VarPattern)c.getRolePlayer());
                continue;
            }
            relVar = relVar.rel((VarPattern)c.getRolePlayer());
        }
        return new RelationshipAtom(relVar.admin(), this.getPredicateVariable(), this.getTypePredicate(), this.getParentQuery());
    }

    @Override
    public Atom rewriteToUserDefined(Atom parentAtom) {
        return this.rewriteWithRelationVariable(parentAtom).rewriteWithVariableRoles(parentAtom);
    }

    private static /* synthetic */ VarPattern lambda$rewriteWithRelationVariable$65(VarPattern newVar, IsaProperty prop) {
        return newVar.isa((VarPattern)prop.type());
    }

    private /* synthetic */ void lambda$getRelationPlayerMappings$57(Map parentVarTypeMap, Set childRoles, Multimap childRoleRPMap, Map childVarTypeMap, boolean exact, ReasonerQueryImpl childQuery, RelationshipAtom parentAtom, List compatibleMappingsPerParentRP, RelationPlayer prp) {
        VarPatternAdmin parentRolePattern = prp.getRole().orElse(null);
        if (parentRolePattern == null) {
            throw GraqlQueryException.rolePatternAbsent((Atomic)this);
        }
        Label parentRoleLabel = parentRolePattern.getTypeLabel().orElse(null);
        if (parentRoleLabel != null) {
            Var parentRolePlayer = prp.getRolePlayer().var();
            Type parentType = (Type)parentVarTypeMap.get(parentRolePlayer);
            Set<Role> compatibleChildRoles = ReasonerUtils.compatibleRoles((Role)this.tx().getSchemaConcept(parentRoleLabel), parentType, childRoles);
            ArrayList compatibleRelationPlayers = new ArrayList();
            compatibleChildRoles.stream().filter(arg_0 -> ((Multimap)childRoleRPMap).containsKey(arg_0)).forEach(role -> childRoleRPMap.get(role).stream().filter(crp -> {
                Var childVar = crp.getRolePlayer().var();
                Type childType = (Type)childVarTypeMap.get(childVar);
                if (exact) {
                    return childQuery.isTypeRoleCompatible(childVar, parentType) && !ReasonerUtils.areDisjointTypes((SchemaConcept)parentType, (SchemaConcept)childType);
                }
                return childQuery.isTypeRoleCompatible(childVar, parentType) && (childType == null || !ReasonerUtils.areDisjointTypes((SchemaConcept)parentType, (SchemaConcept)childType));
            }).filter(crp -> ReasonerUtils.predicatesCompatible(parentAtom.getIdPredicate(prp.getRolePlayer().var()), this.getIdPredicate(crp.getRolePlayer().var()), exact)).filter(crp -> ReasonerUtils.predicatesCompatible(parentAtom.getPredicate(prp.getRolePlayer().var(), ValuePredicate.class), this.getPredicate(crp.getRolePlayer().var(), ValuePredicate.class), exact)).forEach(compatibleRelationPlayers::add));
            if (!compatibleRelationPlayers.isEmpty()) {
                compatibleMappingsPerParentRP.add(compatibleRelationPlayers.stream().map(crp -> new Pair<RelationPlayer, RelationPlayer>((RelationPlayer)crp, prp)).collect(Collectors.toSet()));
            }
        } else {
            compatibleMappingsPerParentRP.add(this.getRelationPlayers().stream().map(crp -> new Pair<RelationPlayer, RelationPlayer>((RelationPlayer)crp, prp)).collect(Collectors.toSet()));
        }
    }

    private static /* synthetic */ void lambda$getRoleRelationPlayerMap$49(List relationPlayers, Multimap roleRelationPlayerMap, Map.Entry e) {
        Role role = (Role)e.getKey();
        Label roleLabel = role.getLabel();
        relationPlayers.stream().filter(rp -> rp.getRole().isPresent()).forEach(rp -> {
            Label rl;
            VarPatternAdmin roleTypeVar = rp.getRole().orElse(null);
            Label label = rl = roleTypeVar != null ? (Label)roleTypeVar.getTypeLabel().orElse(null) : null;
            if (roleLabel != null && roleLabel.equals(rl)) {
                roleRelationPlayerMap.put((Object)role, rp);
            }
        });
    }

    private static /* synthetic */ void lambda$inferRoles$41(Map varTypeMap, Map mappings, Set possibleRoles, RelationPlayer rp) {
        Var varName = rp.getRolePlayer().var();
        Type type = (Type)varTypeMap.get(varName);
        mappings.put(rp, ReasonerUtils.top(type != null ? ReasonerUtils.compatibleRoles(type, possibleRoles) : possibleRoles));
    }

    private static /* synthetic */ boolean lambda$inferPossibleRelationTypes$20(Set untypedRoleplayers, RelationshipAtom at) {
        return !Sets.intersection(at.getVarNames(), (Set)untypedRoleplayers).isEmpty();
    }

    private static /* synthetic */ void lambda$inferPossibleRelationConfigurations$19(Multimap compatibleTypes, RelationshipType rt) {
        compatibleTypes.putAll((Object)rt, (Iterable)rt.relates().collect(Collectors.toSet()));
    }

    private static /* synthetic */ void lambda$getRoleTypeMap$15(ImmutableMultimap.Builder builder, Map varTypeMap, Map.Entry e) {
        builder.put(e.getKey(), varTypeMap.get(e.getValue()));
    }

    private static /* synthetic */ Label lambda$getRoleTypeMap$14(Map varTypeMap, Map.Entry e) {
        return ((Type)varTypeMap.get(e.getValue())).getLabel();
    }

    private static /* synthetic */ boolean lambda$getRoleTypeMap$13(Map varTypeMap, Map.Entry e) {
        return varTypeMap.containsKey(e.getValue());
    }
}

