/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom.binary;

import ai.grakn.GraknTx;
import ai.grakn.concept.Label;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Type;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.ValuePredicate;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.PatternAdmin;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.pattern.Patterns;
import ai.grakn.graql.internal.reasoner.UnifierImpl;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.atom.AtomicBase;
import ai.grakn.graql.internal.reasoner.atom.AtomicFactory;
import ai.grakn.graql.internal.reasoner.atom.binary.Binary;
import ai.grakn.graql.internal.reasoner.atom.binary.RelationshipAtom;
import ai.grakn.graql.internal.reasoner.atom.binary.TypeAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.atom.predicate.Predicate;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueryImpl;
import ai.grakn.graql.internal.reasoner.utils.ReasonerUtils;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class ResourceAtom
extends Binary {
    private final Var relationVariable;
    private final ImmutableSet<ai.grakn.graql.internal.reasoner.atom.predicate.ValuePredicate> multiPredicate;

    public ResourceAtom(VarPatternAdmin pattern, Var attributeVar, Var relationVariable, @Nullable IdPredicate idPred, Set<ai.grakn.graql.internal.reasoner.atom.predicate.ValuePredicate> ps, ReasonerQuery par) {
        super(pattern, attributeVar, idPred, par);
        this.relationVariable = relationVariable;
        this.multiPredicate = ImmutableSet.copyOf(ps);
    }

    private ResourceAtom(ResourceAtom a) {
        super(a);
        this.relationVariable = a.getRelationVariable();
        this.multiPredicate = ImmutableSet.builder().addAll(a.getMultiPredicate().stream().map(pred -> (ai.grakn.graql.internal.reasoner.atom.predicate.ValuePredicate)AtomicFactory.create(pred, this.getParentQuery())).iterator()).build();
    }

    @Override
    public RelationshipAtom toRelationshipAtom() {
        SchemaConcept type = this.getSchemaConcept();
        if (type == null) {
            throw GraqlQueryException.illegalAtomConversion((Atomic)this);
        }
        GraknTx tx = this.getParentQuery().tx();
        Label typeLabel = Schema.ImplicitType.HAS.getLabel(type.getLabel());
        return new RelationshipAtom(Graql.var().rel(Schema.ImplicitType.HAS_OWNER.getLabel(type.getLabel()).getValue(), (VarPattern)this.getVarName()).rel(Schema.ImplicitType.HAS_VALUE.getLabel(type.getLabel()).getValue(), (VarPattern)this.getPredicateVariable()).isa(typeLabel.getValue()).admin(), this.getPredicateVariable(), new IdPredicate(this.getPredicateVariable().id(tx.getSchemaConcept(typeLabel).getId()).admin(), this.getParentQuery()), this.getParentQuery());
    }

    @Override
    public String toString() {
        String multiPredicateString = this.getMultiPredicate().isEmpty() ? this.getPredicateVariable().toString() : this.getMultiPredicate().stream().map(Predicate::getPredicate).collect(Collectors.toSet()).toString();
        return this.getVarName() + " has " + this.getSchemaConcept().getLabel() + " " + multiPredicateString + this.getPredicates(Predicate.class).map(AtomicBase::toString).collect(Collectors.joining("")) + (this.relationVariable.isUserDefinedName() ? "(" + this.relationVariable + ")" : "");
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 37 + (this.getTypeId() != null ? this.getTypeId().hashCode() : 0);
        hashCode = hashCode * 37 + this.getVarName().hashCode();
        hashCode = hashCode * 37 + this.getMultiPredicate().hashCode();
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ResourceAtom a2 = (ResourceAtom)obj;
        return Objects.equals(this.getTypeId(), a2.getTypeId()) && this.getVarName().equals((Object)a2.getVarName()) && this.getMultiPredicate().equals(a2.getMultiPredicate());
    }

    @Override
    public int equivalenceHashCode() {
        int hashCode = 1;
        hashCode = hashCode * 37 + (this.getTypeId() != null ? this.getTypeId().hashCode() : 0);
        hashCode = hashCode * 37 + this.multiPredicateEquivalenceHashCode();
        return hashCode;
    }

    private int multiPredicateEquivalenceHashCode() {
        int hashCode = 0;
        TreeSet hashes = new TreeSet();
        this.getMultiPredicate().forEach(atom -> hashes.add(atom.equivalenceHashCode()));
        for (Integer hash : hashes) {
            hashCode = hashCode * 37 + hash;
        }
        return hashCode;
    }

    @Override
    boolean hasEquivalentPredicatesWith(Binary at) {
        if (!(at instanceof ResourceAtom) || !super.hasEquivalentPredicatesWith(at)) {
            return false;
        }
        ResourceAtom atom = (ResourceAtom)at;
        if (this.getMultiPredicate().size() != atom.getMultiPredicate().size()) {
            return false;
        }
        for (ai.grakn.graql.internal.reasoner.atom.predicate.ValuePredicate vp : this.getMultiPredicate()) {
            Iterator<ai.grakn.graql.internal.reasoner.atom.predicate.ValuePredicate> objIt = atom.getMultiPredicate().iterator();
            boolean predicateHasEquivalent = false;
            while (objIt.hasNext() && !predicateHasEquivalent) {
                predicateHasEquivalent = vp.isEquivalent(objIt.next());
            }
            if (predicateHasEquivalent) continue;
            return false;
        }
        IdPredicate thisPredicate = this.getIdPredicate(this.getPredicateVariable());
        IdPredicate predicate = atom.getIdPredicate(atom.getPredicateVariable());
        return thisPredicate == null && predicate == null || thisPredicate != null && thisPredicate.isEquivalent(predicate);
    }

    @Override
    public void setParentQuery(ReasonerQuery q) {
        super.setParentQuery(q);
        this.multiPredicate.forEach(pred -> pred.setParentQuery(q));
    }

    public Set<ai.grakn.graql.internal.reasoner.atom.predicate.ValuePredicate> getMultiPredicate() {
        return this.multiPredicate;
    }

    public Var getRelationVariable() {
        return this.relationVariable;
    }

    @Override
    public PatternAdmin getCombinedPattern() {
        Set vars = this.getMultiPredicate().stream().map(Atomic::getPattern).map(PatternAdmin::asVarPattern).collect(Collectors.toSet());
        vars.add(super.getPattern().asVarPattern());
        return Patterns.conjunction(vars);
    }

    @Override
    public boolean isRuleApplicableViaAtom(Atom ruleAtom) {
        if (!(ruleAtom instanceof ResourceAtom)) {
            return false;
        }
        ResourceAtom childAtom = (ResourceAtom)ruleAtom;
        ReasonerQueryImpl childQuery = (ReasonerQueryImpl)childAtom.getParentQuery();
        Type parentType = (Type)this.getParentQuery().getVarTypeMap().get((Object)this.getVarName());
        Type childType = (Type)childQuery.getVarTypeMap().get((Object)childAtom.getVarName());
        if (parentType != null && childType != null && ReasonerUtils.areDisjointTypes((SchemaConcept)parentType, (SchemaConcept)childType) || !childQuery.isTypeRoleCompatible(ruleAtom.getVarName(), parentType)) {
            return false;
        }
        if (childAtom.getMultiPredicate().isEmpty() || this.getMultiPredicate().isEmpty()) {
            return true;
        }
        for (ai.grakn.graql.internal.reasoner.atom.predicate.ValuePredicate childPredicate : childAtom.getMultiPredicate()) {
            Iterator<ai.grakn.graql.internal.reasoner.atom.predicate.ValuePredicate> parentIt = this.getMultiPredicate().iterator();
            boolean predicateCompatible = false;
            while (parentIt.hasNext() && !predicateCompatible) {
                ai.grakn.graql.internal.reasoner.atom.predicate.ValuePredicate parentPredicate = parentIt.next();
                predicateCompatible = parentPredicate.isCompatibleWith(childPredicate);
            }
            if (predicateCompatible) continue;
            return false;
        }
        return true;
    }

    @Override
    public Atomic copy() {
        return new ResourceAtom(this);
    }

    public boolean isResource() {
        return true;
    }

    public boolean isSelectable() {
        return true;
    }

    @Override
    public boolean isUserDefined() {
        return this.relationVariable.isUserDefinedName();
    }

    @Override
    public boolean requiresMaterialisation() {
        return true;
    }

    public boolean isAllowedToFormRuleHead() {
        if (this.getSchemaConcept() == null || this.getMultiPredicate().size() > 1) {
            return false;
        }
        if (this.getMultiPredicate().isEmpty()) {
            return true;
        }
        ai.grakn.graql.internal.reasoner.atom.predicate.ValuePredicate predicate = this.getMultiPredicate().iterator().next();
        return ((ValuePredicate)predicate.getPredicate()).isSpecific();
    }

    @Override
    public Set<Var> getVarNames() {
        Set<Var> varNames = super.getVarNames();
        this.multiPredicate.stream().flatMap(p -> p.getVarNames().stream()).forEach(varNames::add);
        if (this.relationVariable.isUserDefinedName()) {
            varNames.add(this.relationVariable);
        }
        return varNames;
    }

    public Set<String> validateOntologically() {
        SchemaConcept type = this.getSchemaConcept();
        if (type == null) {
            return new HashSet<String>();
        }
        HashSet<String> errors = new HashSet<String>();
        if (!type.isAttributeType()) {
            errors.add(ErrorMessage.VALIDATION_RULE_INVALID_RESOURCE_TYPE.getMessage(new Object[]{type.getLabel()}));
            return errors;
        }
        Type ownerType = (Type)this.getParentQuery().getVarTypeMap().get((Object)this.getVarName());
        if (ownerType != null && ownerType.attributes().noneMatch(rt -> rt.equals(type.asAttributeType()))) {
            errors.add(ErrorMessage.VALIDATION_RULE_RESOURCE_OWNER_CANNOT_HAVE_RESOURCE.getMessage(new Object[]{type.getLabel(), ownerType.getLabel()}));
        }
        return errors;
    }

    private boolean isSuperNode() {
        return this.tx().graql().match(new Pattern[]{this.getCombinedPattern()}).admin().stream().skip(5L).findFirst().isPresent();
    }

    @Override
    public int computePriority(Set<Var> subbedVars) {
        int priority = super.computePriority(subbedVars);
        Set vps = this.getPredicates(ai.grakn.graql.internal.reasoner.atom.predicate.ValuePredicate.class).map(Predicate::getPredicate).collect(Collectors.toSet());
        priority += 0;
        if (vps.isEmpty()) {
            priority = subbedVars.contains(this.getVarName()) || subbedVars.contains(this.getPredicateVariable()) && !this.isSuperNode() ? (priority += 20) : (priority -= 100);
        } else {
            int vpsPriority = 0;
            for (ValuePredicate vp : vps) {
                if (vp.isSpecific() && !this.isSuperNode()) {
                    vpsPriority += 20;
                    continue;
                }
                if (vp.getInnerVar().isPresent()) {
                    VarPatternAdmin inner = vp.getInnerVar().orElse(null);
                    if (subbedVars.contains(this.getVarName()) || subbedVars.contains(inner.var()) && !this.isSuperNode()) {
                        vpsPriority += 20;
                        continue;
                    }
                    if (vp.equalsValue().isPresent()) {
                        vpsPriority -= 100;
                        continue;
                    }
                    vpsPriority -= 1000;
                    continue;
                }
                vpsPriority += 5;
            }
            priority += (vpsPriority /= vps.size());
        }
        boolean reifiesRelation = this.getNeighbours(Atom.class).filter(Atomic::isRelation).filter(at -> at.getVarName().equals((Object)this.getVarName())).findFirst().isPresent();
        return priority += reifiesRelation ? 20 : 0;
    }

    @Override
    public Atom rewriteToUserDefined(Atom parentAtom) {
        Var attributeVariable = this.getPredicateVariable();
        Var relationVariable = this.getRelationVariable().asUserDefined();
        VarPattern newVar = this.getVarName().has(this.getSchemaConcept().getLabel(), (VarPattern)attributeVariable, (VarPattern)relationVariable);
        return new ResourceAtom(newVar.admin(), attributeVariable, relationVariable, this.getTypePredicate(), this.getMultiPredicate(), this.getParentQuery());
    }

    @Override
    public Unifier getUnifier(Atom parentAtom) {
        if (!(parentAtom instanceof ResourceAtom)) {
            return new UnifierImpl((ImmutableMap<Var, Var>)ImmutableMap.of((Object)this.getPredicateVariable(), (Object)parentAtom.getVarName()));
        }
        Unifier unifier = super.getUnifier(parentAtom);
        ResourceAtom parent = (ResourceAtom)parentAtom;
        Var childRelationVarName = this.getRelationVariable();
        Var parentRelationVarName = parent.getRelationVariable();
        if (parentRelationVarName.isUserDefinedName() && !childRelationVarName.equals((Object)parentRelationVarName)) {
            unifier.addMapping(childRelationVarName, parentRelationVarName);
        }
        return unifier;
    }

    @Override
    public Stream<Predicate> getInnerPredicates() {
        return Stream.concat(super.getInnerPredicates(), this.getMultiPredicate().stream());
    }

    @Override
    public Set<TypeAtom> getSpecificTypeConstraints() {
        return this.getTypeConstraints().filter(t -> t.getVarName().equals((Object)this.getVarName())).filter(t -> Objects.nonNull(t.getSchemaConcept())).collect(Collectors.toSet());
    }
}

