/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom.predicate;

import ai.grakn.GraknTx;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Label;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.pattern.property.IdProperty;
import ai.grakn.graql.internal.reasoner.atom.predicate.Predicate;

public class IdPredicate
extends Predicate<ConceptId> {
    public IdPredicate(VarPatternAdmin pattern, ReasonerQuery par) {
        super(pattern, par);
    }

    public IdPredicate(Var varName, Label label, ReasonerQuery par) {
        super(IdPredicate.createIdVar(varName, label, par.tx()), par);
    }

    public IdPredicate(Var varName, ConceptId id, ReasonerQuery par) {
        super(IdPredicate.createIdVar(varName, id), par);
    }

    public IdPredicate(Var varName, Concept con, ReasonerQuery par) {
        super(IdPredicate.createIdVar(varName, con.getId()), par);
    }

    private IdPredicate(IdPredicate a) {
        super(a);
    }

    @Override
    public String toString() {
        return "[" + this.getVarName() + "/" + this.getPredicateValue() + "]";
    }

    @Override
    public Atomic copy() {
        return new IdPredicate(this);
    }

    @Override
    public String getPredicateValue() {
        return ((ConceptId)this.getPredicate()).getValue();
    }

    @Override
    protected ConceptId extractPredicate(VarPatternAdmin var) {
        return var.admin().getProperty(IdProperty.class).map(IdProperty::id).orElse(null);
    }

    private static VarPatternAdmin createIdVar(Var varName, ConceptId typeId) {
        return varName.id(typeId).admin();
    }

    private static VarPatternAdmin createIdVar(Var varName, Label label, GraknTx graph) {
        SchemaConcept schemaConcept = graph.getSchemaConcept(label);
        if (schemaConcept == null) {
            throw GraqlQueryException.labelNotFound((Label)label);
        }
        return varName.id(schemaConcept.getId()).admin();
    }
}

