/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.cache;

import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.AnswerExplanation;
import ai.grakn.graql.admin.MultiUnifier;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.internal.reasoner.MultiUnifierImpl;
import ai.grakn.graql.internal.reasoner.cache.Cache;
import ai.grakn.graql.internal.reasoner.explanation.LookupExplanation;
import ai.grakn.graql.internal.reasoner.iterator.LazyAnswerIterator;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueryImpl;
import ai.grakn.graql.internal.reasoner.utils.Pair;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LazyQueryCache<Q extends ReasonerQueryImpl>
extends Cache<Q, LazyAnswerIterator> {
    @Override
    public LazyAnswerIterator record(Q query, LazyAnswerIterator answers) {
        Pair match = this.get(query);
        if (match != null) {
            ReasonerQueryImpl equivalentQuery = (ReasonerQueryImpl)match.getKey();
            Stream unifiedStream = answers.unify(((ReasonerQueryImpl)query).getMultiUnifier(equivalentQuery)).stream();
            this.put((ReasonerQueryImpl)match.getKey(), ((LazyAnswerIterator)match.getValue()).merge(unifiedStream));
            return this.getAnswerIterator((ReasonerQueryImpl)query);
        }
        this.put(query, answers);
        return answers;
    }

    @Override
    public Stream<Answer> record(Q query, Stream<Answer> answers) {
        return this.recordRetrieveLazy((ReasonerQueryImpl)query, (Stream)answers).stream();
    }

    public LazyAnswerIterator recordRetrieveLazy(Q query, Stream<Answer> answers) {
        Pair match = this.get(query);
        if (match != null) {
            ReasonerQueryImpl equivalentQuery = (ReasonerQueryImpl)match.getKey();
            MultiUnifier multiUnifier = ((ReasonerQueryImpl)query).getMultiUnifier(equivalentQuery);
            Stream unifiedStream = answers.flatMap(a -> a.unify(multiUnifier));
            this.put((ReasonerQueryImpl)match.getKey(), ((LazyAnswerIterator)match.getValue()).merge(unifiedStream));
            return this.getAnswerIterator((ReasonerQueryImpl)query);
        }
        LazyAnswerIterator liter = new LazyAnswerIterator(answers);
        this.put(query, liter);
        return liter;
    }

    @Override
    public LazyAnswerIterator getAnswers(Q query) {
        return this.getAnswersWithUnifier(query).getKey();
    }

    @Override
    public Pair<LazyAnswerIterator, MultiUnifier> getAnswersWithUnifier(Q query) {
        Pair match = this.get(query);
        if (match != null) {
            ReasonerQueryImpl equivalentQuery = (ReasonerQueryImpl)match.getKey();
            MultiUnifier multiUnifier = equivalentQuery.getMultiUnifier((ReasonerQuery)query);
            LazyAnswerIterator unified = ((LazyAnswerIterator)match.getValue()).unify(multiUnifier);
            return new Pair<LazyAnswerIterator, MultiUnifier>(unified, multiUnifier);
        }
        Stream<Answer> answerStream = this.record(query, ((ReasonerQueryImpl)query).getQuery().stream().map(a -> a.explain((AnswerExplanation)new LookupExplanation((ReasonerQuery)query))));
        return new Pair<LazyAnswerIterator, MultiUnifier>(new LazyAnswerIterator(answerStream), new MultiUnifierImpl());
    }

    @Override
    public Stream<Answer> getAnswerStream(Q query) {
        return this.getAnswerStreamWithUnifier(query).getKey();
    }

    @Override
    public Pair<Stream<Answer>, MultiUnifier> getAnswerStreamWithUnifier(Q query) {
        Pair match = this.get(query);
        if (match != null) {
            ReasonerQueryImpl equivalentQuery = (ReasonerQueryImpl)match.getKey();
            MultiUnifier multiUnifier = equivalentQuery.getMultiUnifier((ReasonerQuery)query);
            Stream unified = ((LazyAnswerIterator)match.getValue()).stream().flatMap(a -> a.unify(multiUnifier));
            return new Pair<Stream<Answer>, MultiUnifier>(unified, multiUnifier);
        }
        Stream<Answer> answerStream = this.record(query, ((ReasonerQueryImpl)query).getQuery().stream().map(a -> a.explain((AnswerExplanation)new LookupExplanation((ReasonerQuery)query))));
        return new Pair<Stream<Answer>, MultiUnifier>(answerStream, new MultiUnifierImpl());
    }

    public LazyAnswerIterator getAnswerIterator(Q query) {
        return this.getAnswers((ReasonerQueryImpl)query);
    }

    @Override
    public long answerSize(Set<Q> queries) {
        return this.entries().stream().filter(p -> queries.contains(p.getKey())).map(v -> ((LazyAnswerIterator)v.getValue()).size()).mapToLong(Long::longValue).sum();
    }

    @Override
    public void remove(Cache<Q, LazyAnswerIterator> c2, Set<Q> queries) {
        c2.getQueries().stream().filter(queries::contains).filter(this::contains).forEach(q -> {
            Pair match = this.get(q);
            Set s = ((LazyAnswerIterator)match.getValue()).stream().collect(Collectors.toSet());
            s.removeAll(c2.getAnswerStream(q).collect(Collectors.toSet()));
            this.put(match.getKey(), new LazyAnswerIterator(s.stream()));
        });
    }

    public void reload() {
        HashMap newCache = new HashMap();
        this.entries().forEach(entry -> newCache.put(entry.getKey(), new Pair(entry.getKey(), new LazyAnswerIterator(((LazyAnswerIterator)entry.getValue()).stream().collect(Collectors.toSet()).stream()))));
        this.clear();
        this.putAll(newCache);
    }

    public void consume() {
        this.entries().forEach(entry -> ((LazyAnswerIterator)entry.getValue()).stream().collect(Collectors.toSet()));
    }
}

