/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.cache;

import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.AnswerExplanation;
import ai.grakn.graql.admin.MultiUnifier;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.internal.query.QueryAnswer;
import ai.grakn.graql.internal.reasoner.MultiUnifierImpl;
import ai.grakn.graql.internal.reasoner.cache.Cache;
import ai.grakn.graql.internal.reasoner.explanation.LookupExplanation;
import ai.grakn.graql.internal.reasoner.iterator.LazyIterator;
import ai.grakn.graql.internal.reasoner.query.QueryAnswers;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueries;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueryImpl;
import ai.grakn.graql.internal.reasoner.utils.Pair;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class QueryCache<Q extends ReasonerQueryImpl>
extends Cache<Q, QueryAnswers> {
    @Override
    public QueryAnswers record(Q query, QueryAnswers answers) {
        Pair match = this.get(query);
        if (match != null) {
            ReasonerQueryImpl equivalentQuery = (ReasonerQueryImpl)match.getKey();
            QueryAnswers unifiedAnswers = QueryAnswers.getUnifiedAnswers(equivalentQuery, query, answers);
            ((QueryAnswers)this.get(query).getValue()).addAll(unifiedAnswers);
            return this.getAnswers((ReasonerQueryImpl)query);
        }
        this.put(query, answers);
        return answers;
    }

    @Override
    public Stream<Answer> record(Q query, Stream<Answer> answerStream) {
        QueryAnswers newAnswers = new QueryAnswers(answerStream.collect(Collectors.toSet()));
        Pair match = this.get(query);
        if (match != null) {
            ReasonerQueryImpl equivalentQuery = (ReasonerQueryImpl)match.getKey();
            QueryAnswers answers = (QueryAnswers)match.getValue();
            QueryAnswers unifiedAnswers = newAnswers.unify(((ReasonerQueryImpl)query).getMultiUnifier(equivalentQuery));
            answers.addAll(unifiedAnswers);
            return answers.stream();
        }
        this.put(query, newAnswers);
        return newAnswers.stream();
    }

    @Override
    public LazyIterator<Answer> recordRetrieveLazy(Q query, Stream<Answer> answers) {
        return new LazyIterator<Answer>(this.record(query, answers));
    }

    public Answer recordAnswer(Q query, Answer answer) {
        if (answer.isEmpty()) {
            return answer;
        }
        Pair match = this.get(query);
        if (match != null) {
            ReasonerQueryImpl equivalentQuery = (ReasonerQueryImpl)match.getKey();
            QueryAnswers answers = (QueryAnswers)match.getValue();
            MultiUnifier multiUnifier = ((ReasonerQueryImpl)query).getMultiUnifier(equivalentQuery);
            answer.unify(multiUnifier).forEach(answers::add);
        } else {
            this.put(query, new QueryAnswers(answer));
        }
        return answer;
    }

    public Answer recordAnswerWithUnifier(Q query, Answer answer, MultiUnifier unifier) {
        if (answer.isEmpty()) {
            return answer;
        }
        Pair match = this.get(query);
        if (match != null) {
            QueryAnswers answers = (QueryAnswers)match.getValue();
            answer.unify(unifier).forEach(answers::add);
        } else {
            this.put(query, new QueryAnswers(answer));
        }
        return answer;
    }

    @Override
    public QueryAnswers getAnswers(Q query) {
        return this.getAnswersWithUnifier(query).getKey();
    }

    @Override
    public Pair<QueryAnswers, MultiUnifier> getAnswersWithUnifier(Q query) {
        Pair match = this.get(query);
        if (match != null) {
            ReasonerQueryImpl equivalentQuery = (ReasonerQueryImpl)match.getKey();
            QueryAnswers answers = (QueryAnswers)match.getValue();
            MultiUnifier multiUnifier = equivalentQuery.getMultiUnifier((ReasonerQuery)query);
            return new Pair<QueryAnswers, MultiUnifier>(answers.unify(multiUnifier), multiUnifier);
        }
        return new Pair<QueryAnswers, MultiUnifier>(new QueryAnswers(), new MultiUnifierImpl());
    }

    @Override
    public Stream<Answer> getAnswerStream(Q query) {
        return ((QueryAnswers)this.getAnswers((ReasonerQueryImpl)query)).stream();
    }

    @Override
    public Pair<Stream<Answer>, MultiUnifier> getAnswerStreamWithUnifier(Q query) {
        Pair match = this.get(query);
        if (match != null) {
            ReasonerQueryImpl equivalentQuery = (ReasonerQueryImpl)match.getKey();
            QueryAnswers answers = (QueryAnswers)match.getValue();
            MultiUnifier multiUnifier = equivalentQuery.getMultiUnifier((ReasonerQuery)query);
            return new Pair<Stream<Answer>, MultiUnifier>(answers.unify(multiUnifier).stream(), multiUnifier);
        }
        return new Pair<Stream<Answer>, MultiUnifier>(((ReasonerQueryImpl)query).getQuery().stream().map(a -> a.explain((AnswerExplanation)new LookupExplanation((ReasonerQuery)query))), new MultiUnifierImpl());
    }

    @Override
    public LazyIterator<Answer> getAnswerIterator(Q query) {
        return new LazyIterator<Answer>(((QueryAnswers)this.getAnswers((ReasonerQueryImpl)query)).stream());
    }

    public Answer getAnswer(Q query, Answer ans) {
        List answers;
        if (ans.isEmpty()) {
            return ans;
        }
        Pair match = this.get(query);
        if (match != null) {
            ReasonerQueryImpl equivalentQuery = (ReasonerQueryImpl)match.getKey();
            MultiUnifier multiUnifier = equivalentQuery.getMultiUnifier((ReasonerQuery)query);
            QueryAnswers answers2 = ((QueryAnswers)match.getValue()).unify(multiUnifier);
            Answer answer = answers2.stream().filter(a -> a.containsAll(ans)).findFirst().orElse(null);
            if (answer != null) {
                return answer;
            }
        }
        return (answers = (List)ReasonerQueries.create(query, ans).getQuery().execute()).isEmpty() ? new QueryAnswer() : (Answer)answers.iterator().next();
    }

    @Override
    public void remove(Cache<Q, QueryAnswers> c2, Set<Q> queries) {
        c2.getQueries().stream().filter(queries::contains).filter(this::contains).forEach(q -> ((QueryAnswers)this.get(q).getValue()).removeAll((QueryAnswers)c2.getAnswers(q)));
    }

    @Override
    public long answerSize(Set<Q> queries) {
        return this.entries().stream().filter(p -> queries.contains(p.getKey())).map(v -> ((QueryAnswers)v.getValue()).size()).mapToInt(Integer::intValue).sum();
    }
}

