/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.iterator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class LazyIterator<T>
implements Iterable<T> {
    private final Iterator<T> iterator;
    private final List<T> accumulator = new ArrayList<T>();

    public LazyIterator() {
        this.iterator = Collections.emptyIterator();
    }

    public LazyIterator(Stream<T> stream) {
        this.iterator = stream.distinct().iterator();
    }

    public LazyIterator(Iterator<T> iterator) {
        this.iterator = iterator;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < LazyIterator.this.accumulator.size() || LazyIterator.this.iterator.hasNext();
            }

            @Override
            public T next() {
                Object elem;
                if (this.index >= LazyIterator.this.accumulator.size()) {
                    elem = LazyIterator.this.iterator.next();
                    LazyIterator.this.accumulator.add(elem);
                }
                elem = LazyIterator.this.accumulator.get(this.index);
                ++this.index;
                return elem;
            }
        };
    }

    public LazyIterator<T> merge(Stream<T> stream) {
        return new LazyIterator<T>(Stream.concat(this.stream(), stream));
    }

    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false).distinct();
    }

    public long size() {
        return this.accumulator.size();
    }
}

