/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.query;

import ai.grakn.GraknTx;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Label;
import ai.grakn.concept.Role;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Type;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.GetQuery;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.Conjunction;
import ai.grakn.graql.admin.MultiUnifier;
import ai.grakn.graql.admin.PatternAdmin;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.pattern.Patterns;
import ai.grakn.graql.internal.query.QueryAnswer;
import ai.grakn.graql.internal.reasoner.ResolutionIterator;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.atom.AtomicBase;
import ai.grakn.graql.internal.reasoner.atom.AtomicFactory;
import ai.grakn.graql.internal.reasoner.atom.binary.Binary;
import ai.grakn.graql.internal.reasoner.atom.binary.RelationshipAtom;
import ai.grakn.graql.internal.reasoner.atom.binary.type.IsaAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.atom.predicate.NeqPredicate;
import ai.grakn.graql.internal.reasoner.cache.Cache;
import ai.grakn.graql.internal.reasoner.cache.LazyQueryCache;
import ai.grakn.graql.internal.reasoner.cache.QueryCache;
import ai.grakn.graql.internal.reasoner.query.QueryAnswerStream;
import ai.grakn.graql.internal.reasoner.query.ReasonerAtomicQuery;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueries;
import ai.grakn.graql.internal.reasoner.rule.InferenceRule;
import ai.grakn.graql.internal.reasoner.rule.RuleUtils;
import ai.grakn.graql.internal.reasoner.state.ConjunctiveState;
import ai.grakn.graql.internal.reasoner.state.QueryState;
import ai.grakn.graql.internal.reasoner.utils.Pair;
import ai.grakn.util.Schema;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class ReasonerQueryImpl
implements ReasonerQuery {
    private final GraknTx tx;
    private final ImmutableSet<Atomic> atomSet;
    private Answer substitution = null;
    private ImmutableMap<Var, Type> varTypeMap = null;

    ReasonerQueryImpl(Conjunction<VarPatternAdmin> pattern, GraknTx tx) {
        this.tx = tx;
        this.atomSet = ImmutableSet.builder().addAll(AtomicFactory.createAtoms(pattern, this).iterator()).build();
    }

    ReasonerQueryImpl(List<Atom> atoms, GraknTx tx) {
        this.tx = tx;
        this.atomSet = ImmutableSet.builder().addAll(atoms.stream().flatMap(at -> Stream.concat(Stream.of(at), at.getNonSelectableConstraints())).map(at -> AtomicFactory.create(at, this)).iterator()).build();
    }

    ReasonerQueryImpl(Set<Atomic> atoms, GraknTx tx) {
        this.tx = tx;
        this.atomSet = ImmutableSet.builder().addAll(atoms.stream().map(at -> AtomicFactory.create(at, this)).iterator()).build();
    }

    ReasonerQueryImpl(Atom atom) {
        this(Collections.singletonList(atom), atom.getParentQuery().tx());
    }

    ReasonerQueryImpl(ReasonerQueryImpl q) {
        this.tx = q.tx;
        this.atomSet = ImmutableSet.builder().addAll(q.getAtoms().stream().map(at -> AtomicFactory.create(at, this)).iterator()).build();
    }

    public ReasonerQueryImpl inferTypes() {
        return new ReasonerQueryImpl(this.getAtoms().stream().map(Atomic::inferTypes).collect(Collectors.toSet()), this.tx());
    }

    public ReasonerQueryImpl positive() {
        return new ReasonerQueryImpl(this.getAtoms().stream().filter(at -> !(at instanceof NeqPredicate)).collect(Collectors.toSet()), this.tx());
    }

    public String toString() {
        return "{\n\t" + this.getAtoms(Atom.class).map(Object::toString).collect(Collectors.joining(";\n\t")) + "\n}\n";
    }

    public ReasonerQuery copy() {
        return new ReasonerQueryImpl(this);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ReasonerQueryImpl a2 = (ReasonerQueryImpl)obj;
        return this.isEquivalent(a2);
    }

    public int hashCode() {
        int hashCode = 1;
        TreeSet hashes = new TreeSet();
        this.getAtoms().forEach(atom -> hashes.add(atom.equivalenceHashCode()));
        for (Integer hash : hashes) {
            hashCode = hashCode * 37 + hash;
        }
        return hashCode;
    }

    public boolean isEquivalent(ReasonerQueryImpl q) {
        if (this.getAtoms().size() != q.getAtoms().size()) {
            return false;
        }
        Set atoms = this.getAtoms(Atom.class).collect(Collectors.toSet());
        for (Atom atom : atoms) {
            if (q.containsEquivalentAtom(atom)) continue;
            return false;
        }
        return true;
    }

    private boolean containsEquivalentAtom(Atom atom) {
        return !this.getEquivalentAtoms(atom).isEmpty();
    }

    private Set<Atom> getEquivalentAtoms(Atom atom) {
        return this.getAtoms(Atom.class).filter(at -> at.isEquivalent(atom)).collect(Collectors.toSet());
    }

    public GraknTx tx() {
        return this.tx;
    }

    public Conjunction<PatternAdmin> getPattern() {
        HashSet patterns = new HashSet();
        this.atomSet.stream().map(Atomic::getCombinedPattern).flatMap(p -> p.varPatterns().stream()).forEach(patterns::add);
        return Patterns.conjunction(patterns);
    }

    public Set<String> validateOntologically() {
        return this.getAtoms().stream().flatMap(at -> at.validateOntologically().stream()).collect(Collectors.toSet());
    }

    public boolean isRuleResolvable() {
        for (Atom atom : this.selectAtoms()) {
            if (!atom.isRuleResolvable()) continue;
            return true;
        }
        return false;
    }

    private boolean isTransitive() {
        return this.getAtoms(Atom.class).filter(this::containsEquivalentAtom).count() == 2L;
    }

    boolean isAtomic() {
        return this.atomSet.stream().filter(Atomic::isSelectable).count() == 1L;
    }

    public boolean isTypeRoleCompatible(Var typedVar, Type parentType) {
        if (parentType == null || Schema.MetaSchema.isMetaLabel((Label)parentType.getLabel())) {
            return true;
        }
        Set parentTypes = parentType.subs().collect(Collectors.toSet());
        return !this.getAtoms(RelationshipAtom.class).filter(ra -> ra.getVarNames().contains(typedVar)).filter(ra -> ra.getRoleVarMap().entries().stream().filter(e -> ((Var)e.getValue()).equals((Object)typedVar)).filter(e -> !Schema.MetaSchema.isMetaLabel((Label)((Role)e.getKey()).getLabel())).filter(e -> !((Role)e.getKey()).playedByTypes().filter(parentTypes::contains).findFirst().isPresent()).findFirst().isPresent()).findFirst().isPresent();
    }

    public Set<Atomic> getAtoms() {
        return this.atomSet;
    }

    public <T extends Atomic> Stream<T> getAtoms(Class<T> type) {
        return this.atomSet.stream().filter(type::isInstance).map(type::cast);
    }

    public Set<Var> getVarNames() {
        HashSet<Var> vars = new HashSet<Var>();
        this.atomSet.forEach(atom -> vars.addAll(atom.getVarNames()));
        return vars;
    }

    public MultiUnifier getMultiUnifier(ReasonerQuery parent) {
        throw GraqlQueryException.getUnifierOfNonAtomicQuery();
    }

    public GetQuery getQuery() {
        return this.tx.graql().infer(false).match(new Pattern[]{this.getPattern()}).get();
    }

    private Stream<IsaAtom> inferEntityTypes(Answer sub) {
        Set typedVars = this.getAtoms(IsaAtom.class).map(AtomicBase::getVarName).collect(Collectors.toSet());
        return Stream.concat(this.getAtoms(IdPredicate.class), sub.toPredicates((ReasonerQuery)this).stream().map(IdPredicate.class::cast)).filter(p -> !typedVars.contains(p.getVarName())).map(p -> new Pair<IdPredicate, Concept>((IdPredicate)p, this.tx().getConcept((ConceptId)p.getPredicate()))).filter(p -> Objects.nonNull(p.getValue())).filter(p -> ((Concept)p.getValue()).isEntity()).map(p -> new IsaAtom(((IdPredicate)p.getKey()).getVarName(), Graql.var(), (SchemaConcept)((Concept)p.getValue()).asEntity().type(), (ReasonerQuery)this));
    }

    private Stream<IsaAtom> inferEntityTypes() {
        return this.inferEntityTypes(new QueryAnswer());
    }

    private Map<Var, Type> getVarTypeMap(Stream<IsaAtom> isas) {
        HashMap<Var, Type> map = new HashMap<Var, Type>();
        isas.map(at -> new Pair<Var, SchemaConcept>(at.getVarName(), at.getSchemaConcept())).filter(p -> Objects.nonNull(p.getValue())).filter(p -> ((SchemaConcept)p.getValue()).isType()).forEach(p -> {
            Var var = (Var)p.getKey();
            Type newType = ((SchemaConcept)p.getValue()).asType();
            Type type = (Type)map.get(var);
            if (type == null) {
                map.put(var, newType);
            } else {
                boolean isSubType = type.subs().filter(t -> t.equals(newType)).findFirst().isPresent();
                if (isSubType) {
                    map.put(var, newType);
                }
            }
        });
        return map;
    }

    public ImmutableMap<Var, Type> getVarTypeMap() {
        if (this.varTypeMap == null) {
            this.varTypeMap = ImmutableMap.copyOf(this.getVarTypeMap(Stream.concat(this.getAtoms(IsaAtom.class), this.inferEntityTypes())));
        }
        return this.varTypeMap;
    }

    public ImmutableMap<Var, Type> getVarTypeMap(Answer sub) {
        return ImmutableMap.copyOf(this.getVarTypeMap(Stream.concat(this.getAtoms(IsaAtom.class), this.inferEntityTypes())));
    }

    @Nullable
    public IdPredicate getIdPredicate(Var var) {
        return this.getAtoms(IdPredicate.class).filter(sub -> sub.getVarName().equals((Object)var)).findFirst().orElse(null);
    }

    public Set<Atom> selectAtoms() {
        Set<Atom> atomsToSelect = this.getAtoms(Atom.class).filter(Atomic::isSelectable).collect(Collectors.toSet());
        if (atomsToSelect.size() <= 2) {
            return atomsToSelect;
        }
        LinkedHashSet<Atom> orderedSelection = new LinkedHashSet<Atom>();
        Atom atom = atomsToSelect.stream().filter(at -> at.getNeighbours(Atom.class).findFirst().isPresent()).findFirst().orElse(null);
        while (!atomsToSelect.isEmpty() && atom != null) {
            orderedSelection.add(atom);
            atomsToSelect.remove(atom);
            atom = atom.getNeighbours(Atom.class).filter(atomsToSelect::contains).findFirst().orElse(null);
        }
        if (!atomsToSelect.isEmpty()) {
            atomsToSelect.forEach(orderedSelection::add);
        }
        if (orderedSelection.isEmpty()) {
            throw GraqlQueryException.noAtomsSelected((ReasonerQuery)this);
        }
        return orderedSelection;
    }

    public Answer getSubstitution() {
        if (this.substitution == null) {
            Set predicates = this.getAtoms(IsaAtom.class).map(Binary::getTypePredicate).filter(Objects::nonNull).collect(Collectors.toSet());
            this.getAtoms(IdPredicate.class).forEach(predicates::add);
            Function<IdPredicate, Concept> f = p -> this.tx().getConcept((ConceptId)p.getPredicate());
            this.substitution = new QueryAnswer(predicates.stream().collect(Collectors.toMap(AtomicBase::getVarName, f)));
        }
        return this.substitution;
    }

    public Answer getRoleSubstitution() {
        QueryAnswer answer = new QueryAnswer();
        this.getAtoms(RelationshipAtom.class).flatMap(RelationshipAtom::getRolePredicates).forEach(p -> answer.put(p.getVarName(), this.tx().getConcept((ConceptId)p.getPredicate())));
        return answer;
    }

    public boolean isGround() {
        return this.getSubstitution().vars().containsAll(this.getVarNames());
    }

    private Stream<Answer> fullJoin(Set<ReasonerAtomicQuery> subGoals, Cache<ReasonerAtomicQuery, ?> cache, Cache<ReasonerAtomicQuery, ?> dCache) {
        List queries = this.selectAtoms().stream().map(ReasonerAtomicQuery::new).collect(Collectors.toList());
        Iterator qit = queries.iterator();
        ReasonerAtomicQuery childAtomicQuery = (ReasonerAtomicQuery)qit.next();
        Stream<Answer> join = childAtomicQuery.answerStream(subGoals, cache, dCache, false);
        Set<Var> joinedVars = childAtomicQuery.getVarNames();
        while (qit.hasNext()) {
            childAtomicQuery = (ReasonerAtomicQuery)qit.next();
            Sets.SetView joinVars = Sets.intersection(joinedVars, childAtomicQuery.getVarNames());
            Stream<Answer> localSubs = childAtomicQuery.answerStream(subGoals, cache, dCache, false);
            join = QueryAnswerStream.join(join, localSubs, (ImmutableSet<Var>)ImmutableSet.copyOf((Collection)joinVars));
            joinedVars.addAll(childAtomicQuery.getVarNames());
        }
        return join;
    }

    private Stream<Answer> differentialJoin(Set<ReasonerAtomicQuery> subGoals, Cache<ReasonerAtomicQuery, ?> cache, Cache<ReasonerAtomicQuery, ?> dCache) {
        Stream<Answer> join = Stream.empty();
        ArrayList queries = this.selectAtoms().stream().map(ReasonerAtomicQuery::new).collect(Collectors.toList());
        Set uniqueQueries = queries.stream().collect(Collectors.toSet());
        ArrayList queriesToJoin = this.isTransitive() ? Lists.newArrayList(uniqueQueries) : queries;
        for (ReasonerAtomicQuery qi : queriesToJoin) {
            Stream<Answer> subs = qi.answerStream(subGoals, cache, dCache, true);
            Set<Var> joinedVars = qi.getVarNames();
            for (ReasonerAtomicQuery qj : queries) {
                if (qj == qi) continue;
                Sets.SetView joinVars = Sets.intersection(joinedVars, qj.getVarNames());
                subs = QueryAnswerStream.joinWithInverse(subs, cache.getAnswerStream(qj), cache.getInverseAnswerMap(qj, (Set<Var>)joinVars), (ImmutableSet<Var>)ImmutableSet.copyOf((Collection)joinVars));
                joinedVars.addAll(qj.getVarNames());
            }
            join = Stream.concat(join, subs);
        }
        return join;
    }

    Stream<Answer> computeJoin(Set<ReasonerAtomicQuery> subGoals, Cache<ReasonerAtomicQuery, ?> cache, Cache<ReasonerAtomicQuery, ?> dCache, boolean differentialJoin) {
        Set neqPredicates = this.getAtoms(NeqPredicate.class).collect(Collectors.toSet());
        ReasonerQueryImpl positive = neqPredicates.isEmpty() ? this : this.positive();
        Stream<Answer> join = differentialJoin ? positive.differentialJoin(subGoals, cache, dCache) : positive.fullJoin(subGoals, cache, dCache);
        return join.filter(a -> QueryAnswerStream.nonEqualsFilter(a, neqPredicates));
    }

    public Stream<Answer> resolve(boolean materialise) {
        if (materialise) {
            return this.resolveAndMaterialise(new LazyQueryCache<ReasonerAtomicQuery>(), new LazyQueryCache<ReasonerAtomicQuery>());
        }
        return new ResolutionIterator(this).hasStream();
    }

    Stream<Answer> resolveAndMaterialise(LazyQueryCache<ReasonerAtomicQuery> cache, LazyQueryCache<ReasonerAtomicQuery> dCache) {
        Set neqPredicates = this.getAtoms(NeqPredicate.class).collect(Collectors.toSet());
        ReasonerQueryImpl positive = neqPredicates.isEmpty() ? this : this.positive();
        Iterator<Atom> atIt = positive.selectAtoms().iterator();
        ReasonerAtomicQuery atomicQuery = new ReasonerAtomicQuery(atIt.next());
        Stream<Answer> answerStream = atomicQuery.resolveAndMaterialise(cache, dCache);
        Set<Var> joinedVars = atomicQuery.getVarNames();
        while (atIt.hasNext()) {
            atomicQuery = new ReasonerAtomicQuery(atIt.next());
            Stream<Answer> subAnswerStream = atomicQuery.resolveAndMaterialise(cache, dCache);
            Sets.SetView joinVars = Sets.intersection(joinedVars, atomicQuery.getVarNames());
            answerStream = QueryAnswerStream.join(answerStream, subAnswerStream, (ImmutableSet<Var>)ImmutableSet.copyOf((Collection)joinVars));
            joinedVars.addAll(atomicQuery.getVarNames());
        }
        Set<Var> vars = this.getVarNames();
        return answerStream.filter(a -> QueryAnswerStream.nonEqualsFilter(a, neqPredicates)).map(a -> a.project(vars));
    }

    public QueryState subGoal(Answer sub, Unifier u, QueryState parent, Set<ReasonerAtomicQuery> subGoals, QueryCache<ReasonerAtomicQuery> cache) {
        return new ConjunctiveState(this, sub, u, parent, subGoals, cache);
    }

    public LinkedList<QueryState> subGoals(Answer sub, Unifier u, QueryState parent, Set<ReasonerAtomicQuery> subGoals, QueryCache<ReasonerAtomicQuery> cache) {
        return this.getQueryStream(sub).map(q -> q.subGoal(sub, u, parent, subGoals, cache)).collect(Collectors.toCollection(LinkedList::new));
    }

    Stream<ReasonerQueryImpl> getQueryStream(Answer sub) {
        List atomOptions = this.getAtoms(Atom.class).map(at -> at.atomOptions(sub)).collect(Collectors.toList());
        if (atomOptions.stream().mapToInt(List::size).sum() == atomOptions.size()) {
            return Stream.of(this);
        }
        return Lists.cartesianProduct(atomOptions).stream().map(atomList -> ReasonerQueries.create(atomList, this.tx())).sorted(Comparator.comparing(q -> q.getAtoms(RelationshipAtom.class).filter(at -> Objects.nonNull(at.getSchemaConcept())).filter(at -> at.getSchemaConcept().isImplicit()).findFirst().isPresent()));
    }

    public boolean requiresReiteration() {
        Set<InferenceRule> dependentRules = RuleUtils.getDependentRules(this);
        return RuleUtils.subGraphHasLoops(dependentRules, this.tx()) || RuleUtils.subGraphHasRulesWithHeadSatisfyingBody(dependentRules);
    }
}

