/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.rule;

import ai.grakn.GraknTx;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Rule;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.Conjunction;
import ai.grakn.graql.admin.MultiUnifier;
import ai.grakn.graql.admin.PatternAdmin;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.pattern.Patterns;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.atom.AtomicFactory;
import ai.grakn.graql.internal.reasoner.atom.binary.ResourceAtom;
import ai.grakn.graql.internal.reasoner.atom.binary.TypeAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.ValuePredicate;
import ai.grakn.graql.internal.reasoner.query.ReasonerAtomicQuery;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueries;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueryImpl;
import ai.grakn.graql.internal.reasoner.rule.RuleUtils;
import ai.grakn.graql.internal.reasoner.utils.ReasonerUtils;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class InferenceRule {
    private final GraknTx tx;
    private final ConceptId ruleId;
    private final ReasonerQueryImpl body;
    private final ReasonerAtomicQuery head;
    private int priority = Integer.MAX_VALUE;
    private Boolean requiresMaterialisation = null;

    public InferenceRule(Rule rule, GraknTx tx) {
        this.tx = tx;
        this.ruleId = rule.getId();
        this.body = ReasonerQueries.create(this.conjunction(rule.getWhen().admin()), tx);
        this.head = ReasonerQueries.atomic(this.conjunction(rule.getThen().admin()), tx);
    }

    private InferenceRule(ReasonerAtomicQuery head, ReasonerQueryImpl body, ConceptId ruleId, GraknTx tx) {
        this.tx = tx;
        this.ruleId = ruleId;
        this.head = head;
        this.body = body;
    }

    public InferenceRule(InferenceRule r) {
        this.tx = r.tx;
        this.ruleId = r.getRuleId();
        this.body = ReasonerQueries.create(r.getBody());
        this.head = ReasonerQueries.atomic(r.getHead());
    }

    public String toString() {
        return "\n" + this.body.toString() + "->\n" + this.head.toString() + "[" + this.resolutionPriority() + "]\n";
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InferenceRule rule = (InferenceRule)obj;
        return this.getBody().equals(rule.getBody()) && this.getHead().equals(rule.getHead());
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 37 + this.getBody().hashCode();
        hashCode = hashCode * 37 + this.getHead().hashCode();
        return hashCode;
    }

    public int resolutionPriority() {
        if (this.priority == Integer.MAX_VALUE) {
            this.priority = -RuleUtils.getDependentRules(this.getBody()).size();
        }
        return this.priority;
    }

    private Conjunction<VarPatternAdmin> conjunction(PatternAdmin pattern) {
        Set vars = pattern.getDisjunctiveNormalForm().getPatterns().stream().flatMap(p -> p.getPatterns().stream()).collect(Collectors.toSet());
        return Patterns.conjunction(vars);
    }

    public ConceptId getRuleId() {
        return this.ruleId;
    }

    public boolean hasDisconnectedHead() {
        return Sets.intersection(this.body.getVarNames(), this.head.getVarNames()).isEmpty();
    }

    boolean headSatisfiesBody() {
        HashSet<Atomic> atoms = new HashSet<Atomic>(this.getHead().getAtoms());
        Set<Var> headVars = this.getHead().getVarNames();
        this.getBody().getAtoms(TypeAtom.class).filter(t -> !t.isRelation()).filter(t -> !Sets.intersection(t.getVarNames(), (Set)headVars).isEmpty()).forEach(atoms::add);
        return this.getBody().isEquivalent(ReasonerQueries.create(atoms, this.tx));
    }

    public boolean requiresMaterialisation(Atom parentAtom) {
        if (this.requiresMaterialisation == null) {
            this.requiresMaterialisation = parentAtom.requiresMaterialisation() || this.getHead().getAtom().requiresMaterialisation() || this.hasDisconnectedHead();
        }
        return this.requiresMaterialisation;
    }

    public ReasonerQueryImpl getBody() {
        return this.body;
    }

    public ReasonerAtomicQuery getHead() {
        return this.head;
    }

    public InferenceRule withSubstitution(Answer sub) {
        return new InferenceRule(ReasonerQueries.atomic(this.getHead(), sub), ReasonerQueries.create(this.getBody(), sub), this.ruleId, this.tx);
    }

    private ReasonerQueryImpl getCombinedQuery() {
        HashSet<Atomic> allAtoms = new HashSet<Atomic>();
        allAtoms.add(this.head.getAtom());
        this.body.getAtoms().forEach(allAtoms::add);
        return ReasonerQueries.create(allAtoms, this.tx);
    }

    public Atom getRuleConclusionAtom() {
        return this.getCombinedQuery().getAtoms(Atom.class).filter(at -> at.equals(this.head.getAtom())).findFirst().orElse(null);
    }

    public InferenceRule propagateConstraints(Atom parentAtom, Unifier unifier) {
        if (!parentAtom.isRelation() && !parentAtom.isResource()) {
            return this;
        }
        Atom headAtom = this.head.getAtom();
        HashSet<Atomic> bodyAtoms = new HashSet<Atomic>(this.body.getAtoms());
        parentAtom.getPredicates(ValuePredicate.class).flatMap(vp -> vp.unify(unifier).stream()).forEach(bodyAtoms::add);
        if (headAtom.isResource() && ((ResourceAtom)headAtom).getMultiPredicate().isEmpty()) {
            ResourceAtom resourceHead = (ResourceAtom)headAtom;
            Set<ValuePredicate> innerVps = parentAtom.getInnerPredicates(ValuePredicate.class).flatMap(vp -> vp.unify(unifier).stream()).peek(bodyAtoms::add).collect(Collectors.toSet());
            headAtom = new ResourceAtom(headAtom.getPattern().asVarPattern(), headAtom.getPredicateVariable(), resourceHead.getRelationVariable(), resourceHead.getTypePredicate(), innerVps, headAtom.getParentQuery());
        }
        Set unifiedTypes = parentAtom.getTypeConstraints().flatMap(type -> type.unify(unifier).stream()).collect(Collectors.toSet());
        Set ruleTypes = this.body.getAtoms(TypeAtom.class).filter(t -> !t.isRelation()).collect(Collectors.toSet());
        Sets.SetView allTypes = Sets.union(unifiedTypes, ruleTypes);
        allTypes.stream().filter(arg_0 -> InferenceRule.lambda$propagateConstraints$9((Set)allTypes, arg_0)).forEach(t -> bodyAtoms.add(AtomicFactory.create(t, this.body)));
        return new InferenceRule(ReasonerQueries.atomic(headAtom), ReasonerQueries.create(bodyAtoms, this.tx), this.ruleId, this.tx);
    }

    private InferenceRule rewrite(Atom parentAtom) {
        ReasonerAtomicQuery rewrittenHead = ReasonerQueries.atomic(this.head.getAtom().rewriteToUserDefined(parentAtom));
        ArrayList<Atom> bodyRewrites = new ArrayList<Atom>();
        this.body.getAtoms(Atom.class).map(at -> {
            if (at.isRelation() && !at.isUserDefined() && Objects.equals(at.getSchemaConcept(), this.head.getAtom().getSchemaConcept())) {
                return at.rewriteToUserDefined(parentAtom);
            }
            return at;
        }).forEach(bodyRewrites::add);
        ReasonerQueryImpl rewrittenBody = ReasonerQueries.create(bodyRewrites, this.tx);
        return new InferenceRule(rewrittenHead, rewrittenBody, this.ruleId, this.tx);
    }

    private boolean requiresRewrite(Atom parentAtom) {
        return parentAtom.isUserDefined() || parentAtom.requiresRoleExpansion();
    }

    public InferenceRule rewriteToUserDefined(Atom parentAtom) {
        return this.requiresRewrite(parentAtom) ? this.rewrite(parentAtom) : this;
    }

    public MultiUnifier getMultiUnifier(Atom parentAtom) {
        Atom childAtom = this.getRuleConclusionAtom();
        if (parentAtom.getSchemaConcept() != null) {
            return childAtom.getMultiUnifier(parentAtom, false);
        }
        Atom extendedParent = parentAtom.addType(childAtom.getSchemaConcept()).inferTypes();
        return childAtom.getMultiUnifier(extendedParent, false);
    }

    private static /* synthetic */ boolean lambda$propagateConstraints$9(Set allTypes, TypeAtom ta) {
        SchemaConcept schemaConcept = ta.getSchemaConcept();
        SchemaConcept subType = allTypes.stream().map(Atom::getSchemaConcept).filter(Objects::nonNull).filter(t -> ReasonerUtils.supers(t).contains(schemaConcept)).findFirst().orElse(null);
        return schemaConcept == null || subType == null;
    }
}

