/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.rule;

import ai.grakn.GraknTx;
import ai.grakn.concept.Rule;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Type;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueryImpl;
import ai.grakn.graql.internal.reasoner.rule.InferenceRule;
import ai.grakn.util.Schema;
import com.google.common.base.Equivalence;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Stream;

public class RuleUtils {
    public static Stream<Rule> getRules(GraknTx graph) {
        return graph.admin().getMetaRule().subs().filter(sub -> !sub.equals(graph.admin().getMetaRule()));
    }

    public static boolean hasRules(GraknTx graph) {
        VarPattern rule = Graql.label(Schema.MetaSchema.RULE.getLabel());
        return graph.graql().infer(false).match(new Pattern[]{Graql.var("x").sub(rule).neq(rule)}).iterator().hasNext();
    }

    public static Stream<Rule> getRulesWithType(SchemaConcept type, GraknTx graph) {
        return type != null ? type.subs().flatMap(SchemaConcept::getRulesOfConclusion) : RuleUtils.getRules(graph);
    }

    public static boolean subGraphHasLoops(Set<InferenceRule> rules, GraknTx graph) {
        return rules.stream().map(r -> (Rule)graph.getConcept(r.getRuleId())).flatMap(Rule::getConclusionTypes).distinct().filter(type -> type.getRulesOfHypothesis().findFirst().isPresent()).findFirst().isPresent();
    }

    public static boolean subGraphHasLoopsWithNegativeFlux(Set<InferenceRule> rules, GraknTx graph) {
        return rules.stream().map(r -> (Rule)graph.getConcept(r.getRuleId())).flatMap(Rule::getConclusionTypes).distinct().filter(type -> {
            long outflux = type.getRulesOfHypothesis().count();
            long influx = type.getRulesOfConclusion().count();
            return outflux > 0L && influx > outflux;
        }).findFirst().isPresent();
    }

    public static boolean subGraphHasRulesWithHeadSatisfyingBody(Set<InferenceRule> rules) {
        return rules.stream().filter(InferenceRule::headSatisfiesBody).findFirst().isPresent();
    }

    public static Set<Rule> getDependentRules(Set<Type> topTypes) {
        HashSet<Rule> rules = new HashSet<Rule>();
        HashSet<Type> visitedTypes = new HashSet<Type>();
        Stack types = new Stack();
        topTypes.forEach(types::push);
        while (!types.isEmpty()) {
            Type type = (Type)types.pop();
            if (visitedTypes.contains(type)) continue;
            type.getRulesOfConclusion().peek(rules::add).flatMap(Rule::getHypothesisTypes).filter(visitedTypes::contains).forEach(types::add);
            visitedTypes.add(type);
        }
        return rules;
    }

    public static Set<InferenceRule> getDependentRules(ReasonerQueryImpl query) {
        Equivalence<Atom> equivalence = new Equivalence<Atom>(){

            protected boolean doEquivalent(Atom a1, Atom a2) {
                return a1.isEquivalent(a2);
            }

            protected int doHash(Atom a) {
                return a.equivalenceHashCode();
            }
        };
        HashSet<InferenceRule> rules = new HashSet<InferenceRule>();
        HashSet<Equivalence.Wrapper> visitedAtoms = new HashSet<Equivalence.Wrapper>();
        Stack atoms = new Stack();
        query.selectAtoms().stream().map(arg_0 -> ((Equivalence)equivalence).wrap(arg_0)).forEach(atoms::push);
        while (!atoms.isEmpty()) {
            Equivalence.Wrapper wrappedAtom = (Equivalence.Wrapper)atoms.pop();
            Atom atom = (Atom)wrappedAtom.get();
            if (visitedAtoms.contains(wrappedAtom) || atom == null) continue;
            atom.getApplicableRules().peek(rules::add).flatMap(rule -> rule.getBody().selectAtoms().stream()).map(arg_0 -> ((Equivalence)equivalence).wrap(arg_0)).filter(at -> !visitedAtoms.contains(at)).filter(at -> !atoms.contains(at)).forEach(atoms::add);
            visitedAtoms.add(wrappedAtom);
        }
        return rules;
    }
}

