/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.state;

import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.AnswerExplanation;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.internal.query.QueryAnswer;
import ai.grakn.graql.internal.reasoner.cache.QueryCache;
import ai.grakn.graql.internal.reasoner.explanation.RuleExplanation;
import ai.grakn.graql.internal.reasoner.query.ReasonerAtomicQuery;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueries;
import ai.grakn.graql.internal.reasoner.rule.InferenceRule;
import ai.grakn.graql.internal.reasoner.state.AtomicState;
import ai.grakn.graql.internal.reasoner.state.QueryState;
import ai.grakn.graql.internal.reasoner.state.ResolutionState;
import java.util.Set;

class AnswerState
extends ResolutionState {
    private final Unifier unifier;

    AnswerState(Answer sub, Unifier u, QueryState parent) {
        super(sub, parent);
        this.unifier = u;
    }

    @Override
    public boolean isAnswerState() {
        return true;
    }

    @Override
    public ResolutionState generateSubGoal() {
        return this.getParentState().propagateAnswer(this);
    }

    Unifier getUnifier() {
        return this.unifier;
    }

    Answer getAnswer() {
        if (!this.getParentState().isAtomicState()) {
            return this.getSubstitution();
        }
        AtomicState parent = (AtomicState)this.getParentState();
        ReasonerAtomicQuery query = parent.getQuery();
        InferenceRule rule = parent.getCurrentRule();
        QueryCache<ReasonerAtomicQuery> cache = parent.getCache();
        Answer answer = rule == null ? this.getSubstitution() : (rule.requiresMaterialisation(query.getAtom()) ? this.getMaterialisedAnswer(query, rule, cache) : this.getRuleAnswer(query, rule));
        return cache.recordAnswerWithUnifier(query, answer, parent.getCacheUnifier());
    }

    private Answer getRuleAnswer(ReasonerAtomicQuery query, InferenceRule rule) {
        Answer answer = this.getSubstitution().merge(rule.getHead().getRoleSubstitution()).unify(this.unifier);
        if (answer.isEmpty()) {
            return answer;
        }
        return answer.merge(query.getSubstitution()).project(query.getVarNames()).explain((AnswerExplanation)new RuleExplanation((ReasonerQuery)query, rule));
    }

    private Answer getMaterialisedAnswer(ReasonerAtomicQuery query, InferenceRule rule, QueryCache<ReasonerAtomicQuery> cache) {
        QueryAnswer queryAnswer;
        Answer ans = this.getSubstitution();
        ReasonerAtomicQuery subbedQuery = ReasonerQueries.atomic(query, ans);
        ReasonerAtomicQuery ruleHead = ReasonerQueries.atomic(rule.getHead(), ans);
        Set queryVars = query.getVarNames().size() < ruleHead.getVarNames().size() ? this.unifier.keySet() : ruleHead.getVarNames();
        boolean queryEquivalentToHead = subbedQuery.isEquivalent(ruleHead);
        Answer headAnswer = cache.getAnswer(ruleHead, ans).project(queryVars).unify(this.unifier);
        QueryAnswer queryAnswer2 = queryAnswer = headAnswer.isEmpty() && queryEquivalentToHead ? cache.getAnswer(query, ans) : new QueryAnswer();
        if (headAnswer.isEmpty() && queryAnswer.isEmpty()) {
            Answer materialisedSub = ruleHead.materialise(ans).findFirst().orElse(null);
            if (!queryEquivalentToHead) {
                cache.recordAnswer(ruleHead, materialisedSub);
            }
            ans = materialisedSub.project(queryVars).unify(this.unifier);
        } else {
            QueryAnswer queryAnswer3 = ans = headAnswer.isEmpty() ? queryAnswer : headAnswer;
        }
        if (ans.isEmpty()) {
            return ans;
        }
        return ans.merge(query.getSubstitution()).explain((AnswerExplanation)new RuleExplanation((ReasonerQuery)query, rule));
    }
}

