/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.state;

import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.MultiUnifier;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.internal.reasoner.cache.QueryCache;
import ai.grakn.graql.internal.reasoner.query.ReasonerAtomicQuery;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueries;
import ai.grakn.graql.internal.reasoner.rule.InferenceRule;
import ai.grakn.graql.internal.reasoner.state.AnswerState;
import ai.grakn.graql.internal.reasoner.state.QueryState;
import ai.grakn.graql.internal.reasoner.state.ResolutionState;
import ai.grakn.graql.internal.reasoner.state.RoleExpansionState;
import ai.grakn.graql.internal.reasoner.utils.Pair;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Stream;

public class AtomicState
extends QueryState {
    private final ReasonerAtomicQuery query;
    private final Iterator<Answer> dbIterator;
    private final Iterator<Pair<InferenceRule, Unifier>> ruleIterator;
    private InferenceRule currentRule = null;
    private final MultiUnifier cacheUnifier;

    public AtomicState(ReasonerAtomicQuery q, Answer sub, Unifier u, QueryState parent, Set<ReasonerAtomicQuery> subGoals, QueryCache<ReasonerAtomicQuery> cache) {
        super(sub, u, parent, subGoals, cache);
        this.query = ReasonerQueries.atomic(q, sub);
        Pair<Stream<Answer>, MultiUnifier> streamUnifierPair = cache.getAnswerStreamWithUnifier(this.query);
        this.dbIterator = streamUnifierPair.getKey().map(a -> a.explain(a.getExplanation().setQuery((ReasonerQuery)this.query))).iterator();
        this.cacheUnifier = streamUnifierPair.getValue().inverse();
        this.ruleIterator = subGoals.contains(this.query) || this.query.isGround() && this.dbIterator.hasNext() ? Collections.emptyIterator() : this.query.getRuleIterator();
        if (this.ruleIterator.hasNext()) {
            subGoals.add(this.query);
        }
    }

    @Override
    boolean isAtomicState() {
        return true;
    }

    @Override
    ResolutionState propagateAnswer(AnswerState state) {
        Answer answer = state.getAnswer();
        if (answer.isEmpty()) {
            return null;
        }
        if (this.currentRule != null && this.query.getAtom().requiresRoleExpansion()) {
            return new RoleExpansionState(answer, this.getUnifier(), this.query.getAtom().getRoleExpansionVariables(), this.getParentState());
        }
        return new AnswerState(answer, this.getUnifier(), this.getParentState());
    }

    @Override
    public ResolutionState generateSubGoal() {
        if (this.dbIterator.hasNext()) {
            return new AnswerState(this.dbIterator.next(), this.getUnifier(), this);
        }
        if (this.ruleIterator.hasNext()) {
            return this.generateSubGoalFromRule(this.ruleIterator.next());
        }
        return null;
    }

    @Override
    ReasonerAtomicQuery getQuery() {
        return this.query;
    }

    @Override
    MultiUnifier getCacheUnifier() {
        return this.cacheUnifier;
    }

    InferenceRule getCurrentRule() {
        return this.currentRule;
    }

    private ResolutionState generateSubGoalFromRule(Pair<InferenceRule, Unifier> rulePair) {
        Unifier ruleUnifier = rulePair.getValue();
        Unifier ruleUnifierInverse = ruleUnifier.inverse();
        Answer partialSubPrime = this.query.getSubstitution().unify(ruleUnifierInverse);
        this.currentRule = rulePair.getKey().propagateConstraints(this.query.getAtom(), ruleUnifierInverse);
        return this.currentRule.getBody().subGoal(partialSubPrime, ruleUnifier, this, this.getSubGoals(), this.getCache());
    }
}

