/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.state;

import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.AnswerExplanation;
import ai.grakn.graql.admin.MultiUnifier;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.internal.query.QueryAnswer;
import ai.grakn.graql.internal.reasoner.MultiUnifierImpl;
import ai.grakn.graql.internal.reasoner.ResolutionPlan;
import ai.grakn.graql.internal.reasoner.cache.QueryCache;
import ai.grakn.graql.internal.reasoner.explanation.JoinExplanation;
import ai.grakn.graql.internal.reasoner.query.ReasonerAtomicQuery;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueries;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueryImpl;
import ai.grakn.graql.internal.reasoner.state.AnswerState;
import ai.grakn.graql.internal.reasoner.state.CumulativeState;
import ai.grakn.graql.internal.reasoner.state.QueryState;
import ai.grakn.graql.internal.reasoner.state.ResolutionState;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConjunctiveState
extends QueryState {
    private final ReasonerQueryImpl query;
    private final LinkedList<ReasonerQueryImpl> subQueries;
    private final Iterator<Answer> dbIterator;
    private boolean visited = false;
    private static final Logger LOG = LoggerFactory.getLogger(ConjunctiveState.class);

    public ConjunctiveState(ReasonerQueryImpl q, Answer sub, Unifier u, QueryState parent, Set<ReasonerAtomicQuery> subGoals, QueryCache<ReasonerAtomicQuery> cache) {
        super(sub, u, parent, subGoals, cache);
        this.query = ReasonerQueries.create(q, sub);
        if (!this.query.isRuleResolvable()) {
            this.dbIterator = this.query.getQuery().stream().map(at -> at.explain((AnswerExplanation)new JoinExplanation(this.query, (Answer)at))).iterator();
            this.subQueries = new LinkedList();
        } else {
            this.dbIterator = Collections.emptyIterator();
            this.subQueries = new ResolutionPlan(this.query).queryPlan();
            LOG.trace("CQ plan:\n" + this.subQueries.stream().map(aq -> aq.toString() + (aq.isRuleResolvable() ? "*" : "")).collect(Collectors.joining("\n")));
        }
    }

    @Override
    ReasonerQueryImpl getQuery() {
        return this.query;
    }

    @Override
    MultiUnifier getCacheUnifier() {
        return new MultiUnifierImpl();
    }

    @Override
    ResolutionState propagateAnswer(AnswerState state) {
        Answer answer = state.getAnswer();
        return !answer.isEmpty() ? new AnswerState(answer, this.getUnifier(), this.getParentState()) : null;
    }

    @Override
    public ResolutionState generateSubGoal() {
        if (this.dbIterator.hasNext()) {
            return new AnswerState(this.dbIterator.next(), this.getUnifier(), this.getParentState());
        }
        if (!this.subQueries.isEmpty() && !this.visited) {
            this.visited = true;
            return new CumulativeState(this.subQueries, new QueryAnswer(), this.getUnifier(), this, this.getSubGoals(), this.getCache());
        }
        return null;
    }
}

