/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.utils;

import ai.grakn.GraknTx;
import ai.grakn.concept.Label;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Rule;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Type;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.admin.Conjunction;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.pattern.Patterns;
import ai.grakn.graql.internal.pattern.property.IdProperty;
import ai.grakn.graql.internal.pattern.property.LabelProperty;
import ai.grakn.graql.internal.pattern.property.ValueProperty;
import ai.grakn.graql.internal.reasoner.UnifierImpl;
import ai.grakn.graql.internal.reasoner.atom.binary.TypeAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.atom.predicate.Predicate;
import ai.grakn.graql.internal.reasoner.atom.predicate.ValuePredicate;
import ai.grakn.graql.internal.reasoner.utils.Pair;
import ai.grakn.graql.internal.reasoner.utils.conversion.RoleConverter;
import ai.grakn.graql.internal.reasoner.utils.conversion.SchemaConceptConverter;
import ai.grakn.graql.internal.reasoner.utils.conversion.TypeConverter;
import ai.grakn.util.CommonUtil;
import ai.grakn.util.Schema;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class ReasonerUtils {
    public static IdPredicate getUserDefinedIdPredicate(Var typeVariable, Set<VarPatternAdmin> vars, ReasonerQuery parent) {
        return vars.stream().filter(v -> v.var().equals((Object)typeVariable)).flatMap(v -> v.hasProperty(LabelProperty.class) ? v.getProperties(LabelProperty.class).map(np -> new IdPredicate(typeVariable, np.label(), parent)) : v.getProperties(IdProperty.class).map(np -> new IdPredicate(typeVariable, np.id(), parent))).findFirst().orElse(null);
    }

    @Nullable
    public static IdPredicate getIdPredicate(Var typeVariable, VarPatternAdmin typeVar, Set<VarPatternAdmin> vars, ReasonerQuery parent) {
        IdPredicate predicate = null;
        if (typeVar.var().isUserDefinedName()) {
            predicate = ReasonerUtils.getUserDefinedIdPredicate(typeVariable, vars, parent);
        } else {
            LabelProperty nameProp = typeVar.getProperty(LabelProperty.class).orElse(null);
            if (nameProp != null) {
                predicate = new IdPredicate(typeVariable, nameProp.label(), parent);
            }
        }
        return predicate;
    }

    public static Set<ValuePredicate> getValuePredicates(Var valueVariable, VarPatternAdmin valueVar, Set<VarPatternAdmin> vars, ReasonerQuery parent) {
        HashSet<ValuePredicate> predicates = new HashSet<ValuePredicate>();
        if (valueVar.var().isUserDefinedName()) {
            vars.stream().filter(v -> v.var().equals((Object)valueVariable)).flatMap(v -> v.getProperties(ValueProperty.class).map(vp -> new ValuePredicate(v.var(), vp.predicate(), parent))).forEach(predicates::add);
        } else {
            valueVar.getProperties(ValueProperty.class).forEach(vp -> predicates.add(new ValuePredicate(ValuePredicate.createValueVar(valueVariable, vp.predicate()), parent)));
        }
        return predicates;
    }

    public static Set<Unifier> getUnifiersFromPermutations(List<Pair<Var, Var>> originalVars, List<List<Pair<Var, Var>>> permutations) {
        HashSet<Unifier> unifierSet = new HashSet<Unifier>();
        permutations.forEach(perm -> {
            UnifierImpl unifier = new UnifierImpl();
            Iterator pIt = originalVars.iterator();
            Iterator cIt = perm.iterator();
            while (pIt.hasNext() && cIt.hasNext()) {
                Pair pPair = (Pair)pIt.next();
                Pair chPair = (Pair)cIt.next();
                Var parentPlayer = (Var)pPair.getKey();
                Var childPlayer = (Var)chPair.getKey();
                Var parentRole = (Var)pPair.getValue();
                Var childRole = (Var)chPair.getValue();
                if (!parentPlayer.equals((Object)childPlayer)) {
                    unifier.addMapping(parentPlayer, childPlayer);
                }
                if (parentRole == null || childRole == null || parentRole.equals((Object)childRole)) continue;
                unifier.addMapping(parentRole, childRole);
            }
            unifierSet.add(unifier);
        });
        return unifierSet;
    }

    public static <T> List<List<T>> getListPermutations(List<T> entryList) {
        if (entryList.isEmpty()) {
            ArrayList<List<T>> result = new ArrayList<List<T>>();
            result.add(new ArrayList());
            return result;
        }
        ArrayList<T> list = new ArrayList<T>(entryList);
        Object firstElement = list.remove(0);
        ArrayList<List<T>> returnValue = new ArrayList<List<T>>();
        List<List<T>> permutations = ReasonerUtils.getListPermutations(list);
        for (List<T> smallerPermuted : permutations) {
            for (int index = 0; index <= smallerPermuted.size(); ++index) {
                ArrayList<T> temp = new ArrayList<T>(smallerPermuted);
                temp.add(index, firstElement);
                returnValue.add(temp);
            }
        }
        return returnValue;
    }

    public static Set<SchemaConcept> supers(SchemaConcept schemaConcept) {
        HashSet<SchemaConcept> superTypes = new HashSet<SchemaConcept>();
        for (SchemaConcept superType = schemaConcept.sup(); superType != null && !Schema.MetaSchema.isMetaLabel((Label)superType.getLabel()); superType = superType.sup()) {
            superTypes.add(superType);
        }
        return superTypes;
    }

    public static Set<SchemaConcept> upstreamHierarchy(SchemaConcept concept) {
        HashSet<SchemaConcept> concepts = new HashSet<SchemaConcept>();
        for (SchemaConcept superType = concept; superType != null; superType = superType.sup()) {
            concepts.add(superType);
        }
        return concepts;
    }

    public static <K, V> Multimap<K, V> multimapIntersection(Multimap<K, V> m1, Multimap<K, V> m2) {
        HashMultimap intersection = HashMultimap.create();
        Sets.SetView keyIntersection = Sets.intersection((Set)m1.keySet(), (Set)m2.keySet());
        Stream.concat(m1.entries().stream(), m2.entries().stream()).filter(e -> keyIntersection.contains(e.getKey())).forEach(arg_0 -> ReasonerUtils.lambda$multimapIntersection$10((Multimap)intersection, arg_0));
        return intersection;
    }

    public static <T extends SchemaConcept> Multimap<RelationshipType, Role> compatibleRelationTypesWithRoles(Set<T> types, SchemaConceptConverter<T> schemaConceptConverter) {
        Multimap<RelationshipType, Role> compatibleTypes = HashMultimap.create();
        if (types.isEmpty()) {
            return compatibleTypes;
        }
        Iterator<T> typeIterator = types.iterator();
        compatibleTypes.putAll(schemaConceptConverter.toRelationshipMultimap((SchemaConcept)typeIterator.next()));
        while (typeIterator.hasNext() && compatibleTypes.size() > 1) {
            compatibleTypes = ReasonerUtils.multimapIntersection(compatibleTypes, schemaConceptConverter.toRelationshipMultimap((SchemaConcept)typeIterator.next()));
        }
        return compatibleTypes;
    }

    public static Set<Role> compatibleRoles(Role parentRole, Type parentType, Set<Role> entryRoles) {
        Object compatibleRoles;
        Sets.SetView setView = compatibleRoles = parentRole != null && !Schema.MetaSchema.isMetaLabel((Label)parentRole.getLabel()) ? Sets.intersection(new RoleConverter().toCompatibleRoles(parentRole).collect(Collectors.toSet()), entryRoles) : entryRoles;
        if (parentType != null && !Schema.MetaSchema.isMetaLabel((Label)parentType.getLabel())) {
            Set compatibleRolesFromTypes = new TypeConverter().toCompatibleRoles(parentType).collect(Collectors.toSet());
            compatibleRoles = compatibleRoles.stream().filter(role -> Schema.MetaSchema.isMetaLabel((Label)role.getLabel()) || compatibleRolesFromTypes.contains(role)).collect(Collectors.toSet());
        }
        return compatibleRoles;
    }

    public static Set<Role> compatibleRoles(Type type, Set<Role> relRoles) {
        return ReasonerUtils.compatibleRoles(null, type, relRoles);
    }

    public static <T extends SchemaConcept> Set<T> top(Set<T> schemaConcepts) {
        return schemaConcepts.stream().filter(rt -> Sets.intersection(ReasonerUtils.supers(rt), (Set)schemaConcepts).isEmpty()).collect(Collectors.toSet());
    }

    public static Type top(Type type) {
        Type superType;
        for (superType = type; superType != null && !Schema.MetaSchema.isMetaLabel((Label)superType.getLabel()); superType = superType.sup()) {
        }
        return superType;
    }

    public static void computeRoleCombinations(Set<Var> vars, Set<Role> roles, Map<Var, VarPattern> roleMap, Set<Map<Var, VarPattern>> roleMaps) {
        HashSet tempVars = Sets.newHashSet(vars);
        HashSet tempRoles = Sets.newHashSet(roles);
        Var var = vars.iterator().next();
        roles.forEach(role -> {
            tempVars.remove(var);
            tempRoles.remove(role);
            roleMap.put(var, (VarPattern)Graql.var().label(role.getLabel()).admin());
            if (!tempVars.isEmpty() && !tempRoles.isEmpty()) {
                ReasonerUtils.computeRoleCombinations(tempVars, tempRoles, roleMap, roleMaps);
            } else {
                if (!roleMap.isEmpty()) {
                    roleMaps.add(Maps.newHashMap((Map)roleMap));
                }
                roleMap.remove(var);
            }
            tempVars.add(var);
            tempRoles.add(role);
        });
    }

    public static Rule createTransitiveRule(String label, RelationshipType relType, Label fromRoleLabel, Label toRoleLabel, GraknTx tx) {
        if (!CommonUtil.containsOnly((Stream)relType.relates(), (long)2L)) {
            throw GraqlQueryException.ruleCreationArityMismatch();
        }
        VarPatternAdmin startVar = Graql.var().isa(Graql.label(relType.getLabel())).rel(Graql.label(fromRoleLabel), "x").rel(Graql.label(toRoleLabel), "z").admin();
        VarPatternAdmin endVar = Graql.var().isa(Graql.label(relType.getLabel())).rel(Graql.label(fromRoleLabel), "z").rel(Graql.label(toRoleLabel), "y").admin();
        VarPatternAdmin headVar = Graql.var().isa(Graql.label(relType.getLabel())).rel(Graql.label(fromRoleLabel), "x").rel(Graql.label(toRoleLabel), "y").admin();
        Conjunction body = Patterns.conjunction(Sets.newHashSet((Object[])new VarPatternAdmin[]{startVar, endVar}));
        return tx.putRule(label, body, (Pattern)headVar);
    }

    public static Rule createReflexiveRule(String label, RelationshipType relType, Label fromRoleLabel, Label toRoleLabel, GraknTx tx) {
        if (!CommonUtil.containsOnly((Stream)relType.relates(), (long)2L)) {
            throw GraqlQueryException.ruleCreationArityMismatch();
        }
        VarPattern body = Graql.var().isa(Graql.label(relType.getLabel())).rel(Graql.label(fromRoleLabel), "x").rel(Graql.label(toRoleLabel), "y");
        VarPattern head = Graql.var().isa(Graql.label(relType.getLabel())).rel(Graql.label(fromRoleLabel), "x").rel(Graql.label(toRoleLabel), "x");
        return tx.putRule(label, (Pattern)body, (Pattern)head);
    }

    public static Rule createSubPropertyRule(String label, RelationshipType parent, RelationshipType child, Map<Label, Label> roleMappings, GraknTx tx) {
        long childArity;
        long parentArity = parent.relates().count();
        if (parentArity != (childArity = child.relates().count()) || parentArity != (long)roleMappings.size()) {
            throw GraqlQueryException.ruleCreationArityMismatch();
        }
        VarPattern parentVar = Graql.var().isa(Graql.label(parent.getLabel()));
        VarPattern childVar = Graql.var().isa(Graql.label(child.getLabel()));
        for (Map.Entry<Label, Label> entry : roleMappings.entrySet()) {
            Var varName = Graql.var().asUserDefined();
            parentVar = parentVar.rel(Graql.label(entry.getKey()), (VarPattern)varName);
            childVar = childVar.rel(Graql.label(entry.getValue()), (VarPattern)varName);
        }
        return tx.putRule(label, (Pattern)childVar, (Pattern)parentVar);
    }

    public static Rule createPropertyChainRule(String label, RelationshipType relation, Label fromRoleLabel, Label toRoleLabel, LinkedHashMap<RelationshipType, Pair<Label, Label>> chain, GraknTx tx) {
        Stack<Var> varNames = new Stack<Var>();
        varNames.push(Graql.var("x"));
        HashSet bodyVars = new HashSet();
        chain.forEach((relType, rolePair) -> {
            Var varName = Graql.var().asUserDefined();
            VarPatternAdmin var = Graql.var().isa(Graql.label(relType.getLabel())).rel(Graql.label((Label)rolePair.getKey()), (VarPattern)varNames.peek()).rel(Graql.label((Label)rolePair.getValue()), (VarPattern)varName).admin();
            varNames.push(varName);
            bodyVars.add(var);
        });
        VarPattern headVar = Graql.var().isa(Graql.label(relation.getLabel())).rel(Graql.label(fromRoleLabel), "x").rel(Graql.label(toRoleLabel), (VarPattern)varNames.peek());
        return tx.putRule(label, Patterns.conjunction(bodyVars), (Pattern)headVar);
    }

    public static Unifier typeUnifier(Set<TypeAtom> childTypes, Set<TypeAtom> parentTypes, Unifier childParentUnifier) {
        Unifier unifier = childParentUnifier;
        for (TypeAtom childType : childTypes) {
            Var parentVarName;
            Var childVarName = childType.getVarName();
            Var var = parentVarName = unifier.containsKey(childVarName) ? (Var)Iterables.getOnlyElement((Iterable)childParentUnifier.get(childVarName)) : childVarName;
            TypeAtom parentType = parentTypes.stream().filter(pt -> pt.getVarName().equals((Object)parentVarName)).findFirst().orElse(null);
            if (parentType == null) continue;
            unifier = unifier.merge(childType.getUnifier(parentType));
        }
        return unifier;
    }

    public static boolean typesCompatible(SchemaConcept parent, SchemaConcept child) {
        if (parent == null) {
            return true;
        }
        if (child == null) {
            return false;
        }
        if (Schema.MetaSchema.isMetaLabel((Label)parent.getLabel())) {
            return true;
        }
        for (SchemaConcept superType = child; superType != null && !Schema.MetaSchema.isMetaLabel((Label)superType.getLabel()); superType = superType.sup()) {
            if (!superType.equals(parent)) continue;
            return true;
        }
        return false;
    }

    public static <T extends Predicate> boolean predicatesCompatible(T parent, T child, boolean exact) {
        if (exact) {
            return parent == null || parent.isCompatibleWith(child);
        }
        return child == null || parent == null || parent.isCompatibleWith(child);
    }

    public static boolean areDisjointTypes(SchemaConcept parent, SchemaConcept child) {
        return parent != null && child == null || !ReasonerUtils.typesCompatible(parent, child) && !ReasonerUtils.typesCompatible(child, parent);
    }

    public static <T> Collection<T> subtract(Collection<T> a, Collection<T> b) {
        ArrayList<T> list = new ArrayList<T>(a);
        for (T aC2 : b) {
            list.remove(aC2);
        }
        return list;
    }

    private static /* synthetic */ void lambda$multimapIntersection$10(Multimap intersection, Map.Entry e) {
        intersection.put(e.getKey(), e.getValue());
    }
}

