/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.template;

import ai.grakn.graql.Var;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Scope {
    private final Scope parent;
    private final Map<String, Object> values;
    private final Set<Var> variablesEncountered;

    public Scope(Map<String, Object> data) {
        this.parent = null;
        this.values = data;
        this.variablesEncountered = new HashSet<Var>();
    }

    public Scope(Scope parent, Map<String, Object> data) {
        this.parent = parent;
        this.values = data;
        this.variablesEncountered = Sets.newHashSet(parent.variablesEncountered);
    }

    public Scope up() {
        return this.parent;
    }

    public Object resolve(String var) {
        return this.values.get(var);
    }

    public Map data() {
        return this.values;
    }

    boolean hasSeen(Var variable) {
        return this.variablesEncountered.contains(variable);
    }

    void markAsSeen(Var variable) {
        this.variablesEncountered.add(variable);
    }
}

