/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.template;

import ai.grakn.exception.GraqlSyntaxException;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Var;
import ai.grakn.graql.internal.antlr.GraqlTemplateBaseVisitor;
import ai.grakn.graql.internal.antlr.GraqlTemplateParser;
import ai.grakn.graql.internal.template.Scope;
import ai.grakn.graql.macro.Macro;
import ai.grakn.util.StringUtil;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;

public class TemplateVisitor
extends GraqlTemplateBaseVisitor {
    private final CommonTokenStream tokens;
    private final Map<String, Object> originalContext;
    private final Map<String, Macro<?>> macros;
    private final Map<Var, Integer> iteration = new HashMap<Var, Integer>();
    private Scope scope;

    public TemplateVisitor(CommonTokenStream tokens, Map<String, Object> context, Map<String, Macro<?>> macros) {
        this.tokens = tokens;
        this.macros = macros;
        this.scope = new Scope(context);
        this.originalContext = context;
    }

    @Override
    public String visitTemplate(GraqlTemplateParser.TemplateContext ctx) {
        return this.visitBlockContents(ctx.blockContents());
    }

    @Override
    public String visitBlock(GraqlTemplateParser.BlockContext ctx) {
        return this.visitBlockContents(ctx.blockContents());
    }

    @Override
    public String visitBlockContents(GraqlTemplateParser.BlockContentsContext ctx) {
        return (String)this.visitChildren((RuleNode)ctx);
    }

    @Override
    @Nullable
    public Object visitForInStatement(GraqlTemplateParser.ForInStatementContext ctx) {
        String var = ctx.ID().getText();
        return this.runForLoop(object -> ImmutableMap.of((Object)var, (Object)object), ctx.list(), ctx.block());
    }

    @Override
    @Nullable
    public Object visitForEachStatement(GraqlTemplateParser.ForEachStatementContext ctx) {
        return this.runForLoop(object -> {
            if (!(object instanceof Map)) {
                throw GraqlSyntaxException.parsingIncorrectValueType((Object)object, Map.class, (Map)this.scope.data());
            }
            return (Map)object;
        }, ctx.list(), ctx.block());
    }

    @Nullable
    private Object runForLoop(Function<Object, Map> contextSupplier, GraqlTemplateParser.ListContext listCtx, GraqlTemplateParser.BlockContext block) {
        List list = this.visitList(listCtx);
        Object returnValue = null;
        for (Object object : list) {
            this.scope = new Scope(this.scope, contextSupplier.apply(object));
            returnValue = this.aggregateResult(returnValue, this.visit((ParseTree)block));
            this.scope = this.scope.up();
        }
        return returnValue;
    }

    @Override
    public String visitIfStatement(GraqlTemplateParser.IfStatementContext ctx) {
        if (this.visitBool(ctx.ifPartial().bool()).booleanValue()) {
            return this.visitBlock(ctx.ifPartial().block());
        }
        for (GraqlTemplateParser.ElseIfPartialContext elseIf : ctx.elseIfPartial()) {
            if (!this.visitBool(elseIf.bool()).booleanValue()) continue;
            return this.visitBlock(elseIf.block());
        }
        if (ctx.elsePartial() != null) {
            return this.visitBlock(ctx.elsePartial().block());
        }
        return "";
    }

    @Override
    public Boolean visitGroupExpression(GraqlTemplateParser.GroupExpressionContext ctx) {
        return this.visitBool(ctx.bool());
    }

    @Override
    public Boolean visitOrExpression(GraqlTemplateParser.OrExpressionContext ctx) {
        boolean lValue = this.visitBool(ctx.bool(0));
        boolean rValue = this.visitBool(ctx.bool(1));
        return lValue || rValue;
    }

    @Override
    public Boolean visitAndExpression(GraqlTemplateParser.AndExpressionContext ctx) {
        boolean lValue = this.visitBool(ctx.bool(0));
        boolean rValue = this.visitBool(ctx.bool(1));
        return lValue && rValue;
    }

    @Override
    public Boolean visitNotExpression(GraqlTemplateParser.NotExpressionContext ctx) {
        return this.visitBool(ctx.bool()) == false;
    }

    @Override
    @Nullable
    public Boolean visitBooleanExpression(GraqlTemplateParser.BooleanExpressionContext ctx) {
        return this.visitUntypedExpression(ctx.untypedExpression(), Boolean.class);
    }

    @Override
    public Boolean visitBooleanConstant(GraqlTemplateParser.BooleanConstantContext ctx) {
        return Boolean.parseBoolean(ctx.getText());
    }

    @Override
    @Nullable
    public String visitString(GraqlTemplateParser.StringContext ctx) {
        if (ctx.STRING() != null) {
            return ctx.getText().substring(1, ctx.getText().length() - 1);
        }
        return this.visitUntypedExpression(ctx.untypedExpression(), String.class);
    }

    @Override
    @Nullable
    public Number visitNumber(GraqlTemplateParser.NumberContext ctx) {
        if (ctx.int_() != null) {
            return this.visitInt_(ctx.int_());
        }
        if (ctx.double_() != null) {
            return this.visitDouble_(ctx.double_());
        }
        return this.visitUntypedExpression(ctx.untypedExpression(), Number.class);
    }

    @Override
    @Nullable
    public Integer visitInt_(GraqlTemplateParser.Int_Context ctx) {
        if (ctx.INT() != null) {
            return Integer.parseInt(ctx.getText());
        }
        return this.visitUntypedExpression(ctx.untypedExpression(), Integer.class);
    }

    @Override
    @Nullable
    public Double visitDouble_(GraqlTemplateParser.Double_Context ctx) {
        if (ctx.DOUBLE() != null) {
            return Double.parseDouble(ctx.getText());
        }
        return this.visitUntypedExpression(ctx.untypedExpression(), Double.class);
    }

    @Override
    @Nullable
    public Object visitNil(GraqlTemplateParser.NilContext ctx) {
        return null;
    }

    @Override
    @Nullable
    public List visitList(GraqlTemplateParser.ListContext ctx) {
        return this.visitUntypedExpression(ctx.untypedExpression(), List.class);
    }

    @Override
    @Nullable
    public Object visitExpression(GraqlTemplateParser.ExpressionContext ctx) {
        if (ctx.untypedExpression() != null) {
            return this.visitUntypedExpression(ctx.untypedExpression(), Object.class);
        }
        if (ctx.BOOLEAN() != null) {
            return Boolean.parseBoolean(ctx.getText());
        }
        return this.visit((ParseTree)ctx.children.get(0));
    }

    private Boolean visitBool(GraqlTemplateParser.BoolContext ctx) {
        return (Boolean)this.visit((ParseTree)ctx);
    }

    @Override
    public Boolean visitEqExpression(GraqlTemplateParser.EqExpressionContext ctx) {
        Object lValue = this.visit((ParseTree)ctx.expression(0));
        Object rValue = this.visit((ParseTree)ctx.expression(1));
        return Objects.equals(lValue, rValue);
    }

    @Override
    public Boolean visitNotEqExpression(GraqlTemplateParser.NotEqExpressionContext ctx) {
        Object rValue;
        Object lValue = this.visit((ParseTree)ctx.expression(0));
        return !Objects.equals(lValue, rValue = this.visit((ParseTree)ctx.expression(1)));
    }

    @Override
    public Boolean visitGreaterExpression(GraqlTemplateParser.GreaterExpressionContext ctx) {
        Number lNumber = this.visitNumber(ctx.number(0));
        Number rNumber = this.visitNumber(ctx.number(1));
        return lNumber.doubleValue() > rNumber.doubleValue();
    }

    @Override
    public Boolean visitGreaterEqExpression(GraqlTemplateParser.GreaterEqExpressionContext ctx) {
        Number lNumber = this.visitNumber(ctx.number(0));
        Number rNumber = this.visitNumber(ctx.number(1));
        return lNumber.doubleValue() >= rNumber.doubleValue();
    }

    @Override
    public Boolean visitLessExpression(GraqlTemplateParser.LessExpressionContext ctx) {
        Number lNumber = this.visitNumber(ctx.number(0));
        Number rNumber = this.visitNumber(ctx.number(1));
        return lNumber.doubleValue() < rNumber.doubleValue();
    }

    @Override
    public Boolean visitLessEqExpression(GraqlTemplateParser.LessEqExpressionContext ctx) {
        Number lNumber = this.visitNumber(ctx.number(0));
        Number rNumber = this.visitNumber(ctx.number(1));
        return lNumber.doubleValue() <= rNumber.doubleValue();
    }

    @Override
    public Var visitVarResolved(GraqlTemplateParser.VarResolvedContext ctx) {
        Object value = null;
        for (GraqlTemplateParser.UntypedExpressionContext c : ctx.untypedExpression()) {
            value = this.aggregateResult(value, this.visitUntypedExpression(c, Object.class));
        }
        if (value == null) {
            throw GraqlSyntaxException.parsingTemplateMissingKey((String)ctx.getText(), this.originalContext);
        }
        String valueAsVar = value.toString().replaceAll("[^a-zA-Z0-9_]", "-");
        return Graql.var(valueAsVar);
    }

    @Override
    public String visitVarLiteral(GraqlTemplateParser.VarLiteralContext ctx) {
        Var var = Graql.var(ctx.getText().substring(1));
        if (!this.scope.hasSeen(var)) {
            this.scope.markAsSeen(var);
            this.iteration.compute(var, (k, v) -> v == null ? 0 : v + 1);
        }
        return ctx.getText() + this.iteration.get(var);
    }

    public String visitTerminal(TerminalNode node) {
        int index = node.getSymbol().getTokenIndex();
        String lws = this.tokens.getHiddenTokensToLeft(index) != null ? this.tokens.getHiddenTokensToLeft(index).stream().map(Token::getText).collect(Collectors.joining()) : "";
        String rws = this.tokens.getHiddenTokensToRight(index) != null ? this.tokens.getHiddenTokensToRight(index).stream().map(Token::getText).collect(Collectors.joining()) : "";
        return lws + node.getText() + rws;
    }

    @Override
    public String visitEscapedExpression(GraqlTemplateParser.EscapedExpressionContext ctx) {
        Object resolved = this.visitUntypedExpression(ctx.untypedExpression(), Object.class);
        if (resolved == null) {
            throw GraqlSyntaxException.parsingTemplateMissingKey((String)ctx.getText(), this.originalContext);
        }
        return StringUtil.valueToString((Object)resolved);
    }

    @Override
    public Object visitMacroExpression(GraqlTemplateParser.MacroExpressionContext ctx) {
        String macro = ctx.ID_MACRO().getText().substring(1).toLowerCase(Locale.getDefault());
        List values = ctx.expression().stream().map(arg_0 -> ((TemplateVisitor)this).visit(arg_0)).collect(Collectors.toList());
        return this.macros.get(macro).apply(values);
    }

    @Override
    public String visitId(GraqlTemplateParser.IdContext ctx) {
        if (ctx.ID() != null) {
            return ctx.ID().getText();
        }
        String string = ctx.STRING().getText();
        return string.substring(1, string.length() - 1);
    }

    @Override
    @Nullable
    public Object visitIdExpression(GraqlTemplateParser.IdExpressionContext ctx) {
        Object object = this.scope.resolve(this.visitId(ctx.id()));
        for (GraqlTemplateParser.AccessorContext accessor : ctx.accessor()) {
            if (object instanceof Map || object instanceof List) {
                object = ((Function)this.visit((ParseTree)accessor)).apply(object);
                continue;
            }
            object = null;
        }
        return object;
    }

    @Override
    public Function<Map, Object> visitMapAccessor(GraqlTemplateParser.MapAccessorContext ctx) {
        return map -> map.get(this.visitId(ctx.id()));
    }

    @Override
    public Function<List, Object> visitListAccessor(GraqlTemplateParser.ListAccessorContext ctx) {
        return list -> {
            int index = this.visitInt_(ctx.int_());
            if (index >= list.size() || index < 0) {
                throw GraqlSyntaxException.parsingError((String)("Index [" + index + "] out of bounds for list " + list));
            }
            return list.get(index);
        };
    }

    @Nullable
    private <T> T visitUntypedExpression(GraqlTemplateParser.UntypedExpressionContext ctx, Class<T> clazz) {
        Object object = this.visit((ParseTree)ctx);
        if (object == null) {
            return null;
        }
        if (!clazz.isInstance(object)) {
            throw GraqlSyntaxException.parsingIncorrectValueType((Object)object, clazz, (Map)this.scope.data());
        }
        return clazz.cast(object);
    }

    @Nullable
    protected Object aggregateResult(@Nullable Object aggregate, @Nullable Object nextResult) {
        if (nextResult == null) {
            return aggregate;
        }
        if (aggregate == null) {
            return nextResult;
        }
        return aggregate.toString() + nextResult.toString();
    }
}

