/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.template.macro;

import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.macro.Macro;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public class BooleanMacro
implements Macro<Boolean> {
    private static final Collection<String> allowedBooleanValues = ImmutableSet.of((Object)"true", (Object)"false");
    private static final int numberArguments = 1;

    public Boolean apply(List<Object> values) {
        if (values.size() != 1) {
            throw GraqlQueryException.wrongNumberOfMacroArguments((Macro)this, values);
        }
        String booleanValue = values.get(0).toString().toLowerCase(Locale.getDefault());
        if (!allowedBooleanValues.contains(booleanValue)) {
            throw GraqlQueryException.wrongMacroArgumentType((Macro)this, (String)booleanValue);
        }
        return Boolean.parseBoolean(booleanValue);
    }

    public String name() {
        return "boolean";
    }
}

