/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.template.macro;

import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.internal.template.macro.Unescaped;
import ai.grakn.graql.macro.Macro;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.List;

public class DateMacro
implements Macro<Unescaped<String>> {
    public Unescaped<String> apply(List<Object> values) {
        if (values.size() != 2) {
            throw GraqlQueryException.wrongNumberOfMacroArguments((Macro)this, values);
        }
        String originalDate = values.get(0).toString();
        String originalFormat = values.get(1).toString();
        return Unescaped.of(this.convertDateFormat(originalDate, originalFormat));
    }

    public String name() {
        return "date";
    }

    private String convertDateFormat(String originalDate, String originalFormat) {
        originalFormat = this.removeQuotes(originalFormat);
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(originalFormat);
            TemporalAccessor parsedDate = formatter.parseBest(originalDate, LocalDateTime::from, LocalDate::from, LocalTime::from);
            return this.extractLocalDateTime(parsedDate).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        }
        catch (IllegalArgumentException e) {
            throw GraqlQueryException.cannotParseDateFormat((String)originalFormat);
        }
        catch (DateTimeParseException e) {
            throw GraqlQueryException.cannotParseDateString((String)originalDate, (String)originalFormat, (DateTimeParseException)e);
        }
    }

    private LocalDateTime extractLocalDateTime(TemporalAccessor parsedDate) {
        if (parsedDate instanceof LocalDate) {
            return ((LocalDate)parsedDate).atStartOfDay();
        }
        if (parsedDate instanceof LocalTime) {
            return ((LocalTime)parsedDate).atDate(LocalDate.now());
        }
        return LocalDateTime.from(parsedDate);
    }

    private String removeQuotes(String str) {
        return str.replace("\"", "");
    }
}

