/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.util;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Partition<V> {
    private final Map<V, V> parents;
    private final Map<V, Integer> ranks;

    private Partition(Map<V, V> parents, Map<V, Integer> ranks) {
        this.parents = parents;
        this.ranks = ranks;
    }

    public static <T> Partition<T> singletons(Collection<T> nodes) {
        HashMap parents = Maps.newHashMap();
        HashMap ranks = Maps.newHashMap();
        for (T node : nodes) {
            parents.put(node, node);
            ranks.put(node, 0);
        }
        return new Partition(parents, ranks);
    }

    public V componentOf(V i) {
        V parent = this.parents.getOrDefault(i, i);
        if (parent.equals(i)) {
            return i;
        }
        this.parents.put(i, this.componentOf(parent));
        return this.parents.get(i);
    }

    public V merge(V a, V b) {
        int bRank;
        V bHead;
        V aHead = this.componentOf(a);
        if (aHead.equals(bHead = this.componentOf(b))) {
            return aHead;
        }
        int aRank = this.ranks.getOrDefault(aHead, 0);
        if (aRank > (bRank = this.ranks.getOrDefault(bHead, 0).intValue())) {
            this.parents.put(bHead, aHead);
            return aHead;
        }
        if (bRank > aRank) {
            this.parents.put(aHead, bHead);
            return bHead;
        }
        this.parents.put(bHead, aHead);
        this.ranks.put((Integer)aHead, aRank + 1);
        return aHead;
    }

    public boolean sameComponent(V a, V b) {
        return this.componentOf(a).equals(this.componentOf(b));
    }

    public Set<V> getNodes() {
        return this.parents.keySet();
    }
}

