/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.util;

import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Label;
import ai.grakn.graql.internal.antlr.GraqlLexer;
import ai.grakn.util.CommonUtil;
import ai.grakn.util.StringUtil;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.stream.Stream;

public class StringConverter {
    private static final ImmutableSet<String> ALLOWED_ID_KEYWORDS = ImmutableSet.of((Object)"min", (Object)"max", (Object)"median", (Object)"mean", (Object)"std", (Object)"sum", (Object[])new String[]{"count", "path", "cluster", "degrees", "members", "persist"});
    public static final ImmutableSet<String> GRAQL_KEYWORDS = (ImmutableSet)StringConverter.getKeywords().collect(CommonUtil.toImmutableSet());

    private StringConverter() {
    }

    public static String idToString(ConceptId id) {
        return StringConverter.escapeLabelOrId(id.getValue());
    }

    public static String typeLabelToString(Label label) {
        return StringConverter.escapeLabelOrId(label.getValue());
    }

    private static String escapeLabelOrId(String value) {
        if (value.matches("^[a-zA-Z_][a-zA-Z0-9_-]*$") && !GRAQL_KEYWORDS.contains((Object)value)) {
            return value;
        }
        return StringUtil.quoteString((String)value);
    }

    private static Stream<String> getKeywords() {
        HashSet<String> keywords = new HashSet<String>();
        int i = 1;
        while (GraqlLexer.VOCABULARY.getLiteralName(i) != null) {
            String name = GraqlLexer.VOCABULARY.getLiteralName(i);
            keywords.add(name.replaceAll("'", ""));
            ++i;
        }
        return keywords.stream().filter(keyword -> !ALLOWED_ID_KEYWORDS.contains(keyword));
    }
}

