/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql;

import ai.grakn.graql.internal.antlr.GraqlLexer;
import ai.grakn.graql.internal.util.CommonUtil;
import ai.grakn.graql.internal.util.StringConverter;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.Token;

public class Autocomplete {
    private final ImmutableSet<String> candidates;
    private final int cursorPosition;

    public static Autocomplete create(Set<String> types, String query, int cursorPosition) {
        return new Autocomplete(types, query, cursorPosition);
    }

    public Set<String> getCandidates() {
        return this.candidates;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    private Autocomplete(Set<String> types, String query, int cursorPosition) {
        Optional<? extends Token> optToken = Autocomplete.getCursorToken(query, cursorPosition);
        this.candidates = Autocomplete.findCandidates(types, query, optToken);
        this.cursorPosition = this.findCursorPosition(cursorPosition, optToken);
    }

    private static ImmutableSet<String> findCandidates(Set<String> types, String query, Optional<? extends Token> optToken) {
        ImmutableSet allCandidates = Stream.of(StringConverter.GRAQL_KEYWORDS.stream(), types.stream(), Autocomplete.getVariables(query)).flatMap(Function.identity()).collect(CommonUtil.toImmutableSet());
        return optToken.map(token -> {
            ImmutableSet candidates = allCandidates.stream().filter(candidate -> candidate.startsWith(token.getText())).collect(CommonUtil.toImmutableSet());
            if (candidates.size() == 1 && ((String)candidates.iterator().next()).equals(token.getText())) {
                return ImmutableSet.of((Object)" ");
            }
            return candidates;
        }).orElse(allCandidates);
    }

    private int findCursorPosition(int cursorPosition, Optional<? extends Token> optToken) {
        return optToken.filter(token -> !this.candidates.contains((Object)" ")).map(Token::getStartIndex).orElse(cursorPosition);
    }

    private static Stream<String> getVariables(String query) {
        List<? extends Token> allTokens = Autocomplete.getTokens(query);
        if (allTokens.size() > 0) {
            allTokens.remove(allTokens.size() - 1);
        }
        return allTokens.stream().filter(t -> t.getType() == 65).map(Token::getText);
    }

    private static Optional<? extends Token> getCursorToken(String query, int cursorPosition) {
        if (query == null) {
            return Optional.empty();
        }
        return Autocomplete.getTokens(query).stream().filter(t -> t.getStartIndex() <= cursorPosition && t.getStopIndex() >= cursorPosition - 1).findFirst();
    }

    private static List<? extends Token> getTokens(String query) {
        ANTLRInputStream input = new ANTLRInputStream(query);
        GraqlLexer lexer = new GraqlLexer((CharStream)input);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)new BaseErrorListener());
        return lexer.getAllTokens();
    }
}

