/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql;

import ai.grakn.concept.Concept;
import ai.grakn.graql.Aggregate;
import ai.grakn.graql.ComputeQueryBuilder;
import ai.grakn.graql.InsertQuery;
import ai.grakn.graql.MatchQuery;
import ai.grakn.graql.NamedAggregate;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.Query;
import ai.grakn.graql.QueryBuilder;
import ai.grakn.graql.ValuePredicate;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.PatternAdmin;
import ai.grakn.graql.internal.pattern.Patterns;
import ai.grakn.graql.internal.query.QueryBuilderImpl;
import ai.grakn.graql.internal.query.aggregate.Aggregates;
import ai.grakn.graql.internal.query.predicate.Predicates;
import ai.grakn.graql.internal.util.AdminConverter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class Graql {
    private Graql() {
    }

    public static QueryBuilder withoutGraph() {
        return new QueryBuilderImpl();
    }

    public static MatchQuery match(Pattern ... patterns) {
        return Graql.withoutGraph().match(patterns);
    }

    public static MatchQuery match(Collection<? extends Pattern> patterns) {
        return Graql.withoutGraph().match(patterns);
    }

    public static InsertQuery insert(Var ... vars) {
        return Graql.withoutGraph().insert(vars);
    }

    public static InsertQuery insert(Collection<? extends Var> vars) {
        return Graql.withoutGraph().insert(vars);
    }

    public static ComputeQueryBuilder compute() {
        return Graql.withoutGraph().compute();
    }

    public static Stream<Pattern> parsePatterns(InputStream inputStream) {
        return Graql.withoutGraph().parsePatterns(inputStream);
    }

    public static List<Pattern> parsePatterns(String patternsString) {
        return Graql.withoutGraph().parsePatterns(patternsString);
    }

    public static <T extends Query<?>> T parse(String queryString) {
        return (T)Graql.withoutGraph().parse(queryString);
    }

    public static <T extends Query<?>> T parseTemplate(String template, Map<String, Object> data) {
        return (T)Graql.withoutGraph().parseTemplate(template, data);
    }

    public static Var var(String name) {
        return Patterns.var(Objects.requireNonNull(name));
    }

    public static Var var() {
        return Patterns.var();
    }

    public static Var name(String name) {
        return Graql.var().name(name);
    }

    public static Pattern and(Pattern ... patterns) {
        return Graql.and(Arrays.asList(patterns));
    }

    public static Pattern and(Collection<? extends Pattern> patterns) {
        Collection<PatternAdmin> patternAdmins = AdminConverter.getPatternAdmins(patterns);
        return Patterns.conjunction(Sets.newHashSet(patternAdmins));
    }

    public static Pattern or(Pattern ... patterns) {
        return Graql.or(Arrays.asList(patterns));
    }

    public static Pattern or(Collection<? extends Pattern> patterns) {
        Collection<PatternAdmin> patternAdmins = AdminConverter.getPatternAdmins(patterns);
        return Patterns.disjunction(Sets.newHashSet(patternAdmins));
    }

    public static Aggregate<Object, Long> count() {
        return Aggregates.count();
    }

    public static Aggregate<Map<String, Concept>, Number> sum(String varName) {
        return Aggregates.sum(varName);
    }

    public static <T extends Comparable<T>> Aggregate<Map<String, Concept>, Optional<T>> max(String varName) {
        return Aggregates.max(varName);
    }

    public static <T extends Comparable<T>> Aggregate<Map<String, Concept>, Optional<T>> min(String varName) {
        return Aggregates.min(varName);
    }

    public static Aggregate<Map<String, Concept>, Optional<Double>> average(String varName) {
        return Aggregates.average(varName);
    }

    public static Aggregate<Map<String, Concept>, Optional<Number>> median(String varName) {
        return Aggregates.median(varName);
    }

    public static Aggregate<Map<String, Concept>, Map<Concept, List<Map<String, Concept>>>> group(String varName) {
        return Graql.group(varName, Aggregates.list());
    }

    public static <T> Aggregate<Map<String, Concept>, Map<Concept, T>> group(String varName, Aggregate<? super Map<String, Concept>, T> aggregate) {
        return Aggregates.group(varName, aggregate);
    }

    @SafeVarargs
    public static <S, T> Aggregate<S, Map<String, T>> select(NamedAggregate<? super S, ? extends T> ... aggregates) {
        return Graql.select(ImmutableSet.copyOf((Object[])aggregates));
    }

    public static <S, T> Aggregate<S, Map<String, T>> select(Set<NamedAggregate<? super S, ? extends T>> aggregates) {
        return Aggregates.select(ImmutableSet.copyOf(aggregates));
    }

    public static ValuePredicate eq(Object value) {
        Objects.requireNonNull(value);
        return Predicates.eq(value);
    }

    public static ValuePredicate eq(Var var) {
        Objects.requireNonNull(var);
        return Predicates.eq(var.admin());
    }

    public static ValuePredicate neq(Object value) {
        Objects.requireNonNull(value);
        return Predicates.neq(value);
    }

    public static ValuePredicate neq(Var var) {
        Objects.requireNonNull(var);
        return Predicates.neq(var.admin());
    }

    public static ValuePredicate gt(Comparable value) {
        Objects.requireNonNull(value);
        return Predicates.gt(value);
    }

    public static ValuePredicate gt(Var var) {
        Objects.requireNonNull(var);
        return Predicates.gt(var.admin());
    }

    public static ValuePredicate gte(Comparable value) {
        Objects.requireNonNull(value);
        return Predicates.gte(value);
    }

    public static ValuePredicate gte(Var var) {
        Objects.requireNonNull(var);
        return Predicates.gte(var.admin());
    }

    public static ValuePredicate lt(Comparable value) {
        Objects.requireNonNull(value);
        return Predicates.lt(value);
    }

    public static ValuePredicate lt(Var var) {
        Objects.requireNonNull(var);
        return Predicates.lt(var.admin());
    }

    public static ValuePredicate lte(Comparable value) {
        Objects.requireNonNull(value);
        return Predicates.lte(value);
    }

    public static ValuePredicate lte(Var var) {
        Objects.requireNonNull(var);
        return Predicates.lte(var.admin());
    }

    public static ValuePredicate regex(String pattern) {
        Objects.requireNonNull(pattern);
        return Predicates.regex(pattern);
    }

    public static ValuePredicate contains(String substring) {
        Objects.requireNonNull(substring);
        return Predicates.contains(substring);
    }

    public static ValuePredicate contains(Var var) {
        Objects.requireNonNull(var);
        return Predicates.contains(var.admin());
    }
}

