/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.Rule;
import ai.grakn.concept.Type;
import ai.grakn.exception.GraknValidationException;
import ai.grakn.graql.Graql;
import ai.grakn.graql.MatchQuery;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.QueryBuilder;
import ai.grakn.graql.internal.reasoner.query.AtomicMatchQuery;
import ai.grakn.graql.internal.reasoner.query.AtomicQuery;
import ai.grakn.graql.internal.reasoner.query.Query;
import ai.grakn.graql.internal.reasoner.query.QueryAnswers;
import ai.grakn.graql.internal.reasoner.query.QueryCache;
import ai.grakn.graql.internal.reasoner.query.ReasonerMatchQuery;
import ai.grakn.graql.internal.reasoner.rule.InferenceRule;
import ai.grakn.util.Schema;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reasoner {
    private final GraknGraph graph;
    private static final Logger LOG = LoggerFactory.getLogger(Reasoner.class);

    public Reasoner(GraknGraph graph) {
        this.graph = graph;
        Reasoner.linkConceptTypes(graph);
    }

    private static void commitGraph(GraknGraph graph) {
        try {
            graph.commit();
        }
        catch (GraknValidationException e) {
            LOG.error(e.getMessage());
        }
    }

    private static void linkConceptTypes(GraknGraph graph, Rule rule) {
        QueryBuilder qb = graph.graql();
        MatchQuery qLHS = qb.match(new Pattern[]{rule.getLHS()});
        MatchQuery qRHS = qb.match(new Pattern[]{rule.getRHS()});
        Set<Type> hypothesisConceptTypes = qLHS.admin().getTypes().stream().filter(type -> !type.isRoleType()).collect(Collectors.toSet());
        Set<Type> conclusionConceptTypes = qRHS.admin().getTypes().stream().filter(type -> !type.isRoleType()).collect(Collectors.toSet());
        hypothesisConceptTypes.forEach(arg_0 -> ((Rule)rule).addHypothesis(arg_0));
        conclusionConceptTypes.forEach(arg_0 -> ((Rule)rule).addConclusion(arg_0));
    }

    public static Set<Rule> getRules(GraknGraph graph) {
        return new HashSet<Rule>(graph.admin().getMetaRuleInference().instances());
    }

    public static boolean hasRules(GraknGraph graph) {
        String inferenceRule = Schema.MetaSchema.INFERENCE_RULE.getName();
        return (Boolean)graph.graql().infer(false).match(new Pattern[]{Graql.var("x").isa(inferenceRule)}).ask().execute();
    }

    public static void linkConceptTypes(GraknGraph graph) {
        Set<Rule> rules = Reasoner.getRules(graph);
        LOG.debug(rules.size() + " rules initialized...");
        HashSet linkedRules = new HashSet();
        rules.stream().filter(rule -> rule.getHypothesisTypes().isEmpty() && rule.getConclusionTypes().isEmpty()).forEach(rule -> {
            Reasoner.linkConceptTypes(graph, rule);
            linkedRules.add(rule);
        });
        if (!linkedRules.isEmpty()) {
            Reasoner.commitGraph(graph);
        }
        LOG.debug(linkedRules.size() + " rules linked...");
    }

    public void precomputeInferences() {
        QueryCache cache = new QueryCache();
        HashSet subGoals = new HashSet();
        Reasoner.getRules(this.graph).forEach(rl -> {
            HashSet<AtomicQuery> SG;
            int dAns;
            InferenceRule rule = new InferenceRule((Rule)rl, this.graph);
            AtomicMatchQuery atomicQuery = new AtomicMatchQuery(rule.getHead(), new QueryAnswers());
            do {
                SG = new HashSet<AtomicQuery>(subGoals);
                dAns = ((Query)atomicQuery).getAnswers().size();
                ((AtomicQuery)atomicQuery).answer(SG, cache, true);
                LOG.debug("Atom: " + atomicQuery.getAtom() + " answers: " + ((Query)atomicQuery).getAnswers().size());
            } while ((dAns = ((Query)atomicQuery).getAnswers().size() - dAns) != 0);
            subGoals.addAll(SG);
        });
        Reasoner.commitGraph(this.graph);
    }

    public Stream<Map<String, Concept>> resolve(MatchQuery inputQuery, boolean materialise) {
        if (!Reasoner.hasRules(this.graph)) {
            return inputQuery.stream();
        }
        Set selectVars = inputQuery.admin().getSelectedNames();
        Iterator conjIt = inputQuery.admin().getPattern().getDisjunctiveNormalForm().getPatterns().iterator();
        Stream<Map<String, Concept>> answerStream = new ReasonerMatchQuery(this.graph.graql().match(new Pattern[]{(Pattern)conjIt.next()}).select(selectVars), this.graph).resolve(materialise);
        while (conjIt.hasNext()) {
            ReasonerMatchQuery conjunctiveQuery = new ReasonerMatchQuery(this.graph.graql().match(new Pattern[]{(Pattern)conjIt.next()}).select(selectVars), this.graph);
            answerStream = Stream.concat(answerStream, ((Query)conjunctiveQuery).resolve(materialise));
        }
        return answerStream;
    }
}

