/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.Grakn;
import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.Instance;
import ai.grakn.concept.Relation;
import ai.grakn.concept.RelationType;
import ai.grakn.concept.Resource;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.RoleType;
import ai.grakn.exception.GraknValidationException;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkResourceMutate<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BulkResourceMutate.class);
    private static final int numberOfRetries = 10;
    private static final int initialSleepTime = 100;
    private static final double exponentialSleepPower = 1.55;
    private int batchSize = 100;
    private GraknGraph graph;
    private int currentNumberOfVertices = 0;
    private final String resourceTypeName;
    private final String keyspace;
    private final Map<String, T> resourcesToPersist = new HashMap<String, T>();
    private ResourceType<T> resourceType;
    private RoleType resourceOwner;
    private RoleType resourceValue;
    private RelationType relationType;

    BulkResourceMutate(String keyspace, String resourceTypeName) {
        LOGGER.debug("Starting BulkResourceMutate");
        this.keyspace = keyspace;
        this.resourceTypeName = resourceTypeName;
    }

    BulkResourceMutate(String keyspace, String resourceTypeName, int batchSize) {
        this(keyspace, resourceTypeName);
        this.batchSize = batchSize;
    }

    void putValue(Vertex vertex, T value) {
        ++this.currentNumberOfVertices;
        LOGGER.debug("Considering vertex: " + vertex);
        vertex.properties(new String[0]).forEachRemaining(p -> LOGGER.debug("Vertex property: " + p.toString()));
        this.resourcesToPersist.put(vertex.id().toString(), value);
        if (this.currentNumberOfVertices >= this.batchSize) {
            this.flush();
        }
    }

    void flush() {
        boolean hasFailed;
        LOGGER.debug("Flush called, about to persist");
        int numberOfFailures = 0;
        do {
            hasFailed = false;
            try {
                this.persistResources();
            }
            catch (Exception e) {
                LOGGER.debug("Exception: " + e.getMessage());
                hasFailed = true;
                LOGGER.debug("Number of failures: " + ++numberOfFailures);
                if (numberOfFailures >= 10) {
                    LOGGER.debug("REACHED MAX NUMBER OF RETRIES !!!!!!!!");
                    throw new RuntimeException(ErrorMessage.BULK_PERSIST.getMessage(new Object[]{this.resourceTypeName, e.getMessage()}), e);
                }
                try {
                    long sleepTime = (long)(100.0 * Math.pow(1.55, numberOfFailures));
                    LOGGER.debug("Start sleeping for " + sleepTime + " ms");
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        } while (hasFailed);
        this.resourcesToPersist.clear();
        this.currentNumberOfVertices = 0;
    }

    private void persistResources() throws GraknValidationException {
        if (this.resourcesToPersist.isEmpty()) {
            LOGGER.debug("Nothing to persist");
            return;
        }
        this.initialiseGraph();
        this.resourcesToPersist.forEach((id, value) -> {
            Instance instance = (Instance)this.graph.getConcept(id);
            List<Relation> relations = instance.relations(new RoleType[]{this.resourceOwner}).stream().filter(relation -> relation.rolePlayers().size() == 2 && relation.rolePlayers().containsKey(this.resourceValue)).filter(relation -> {
                Instance rolePlayer = (Instance)relation.rolePlayers().get(this.resourceValue);
                return rolePlayer == null || rolePlayer.type().getName().equals(this.resourceTypeName);
            }).collect(Collectors.toList());
            relations.forEach(relation -> LOGGER.debug("Assertions currently attached: " + relation.toString()));
            if (relations.isEmpty()) {
                LOGGER.debug("Persisting a new assertion");
                Resource resource = this.resourceType.putResource(value);
                this.relationType.addRelation().putRolePlayer(this.resourceOwner, instance).putRolePlayer(this.resourceValue, (Instance)resource);
                return;
            }
            if (!(relations = relations.stream().filter(relation -> {
                Instance roleplayer = (Instance)relation.rolePlayers().get(this.resourceValue);
                return roleplayer == null || !roleplayer.asResource().getValue().equals(value);
            }).collect(Collectors.toList())).isEmpty()) {
                LOGGER.debug("Deleting " + relations.size() + " existing assertion(s), adding a new one");
                relations.forEach(Concept::delete);
                Resource resource = this.resourceType.putResource(value);
                this.relationType.addRelation().putRolePlayer(this.resourceOwner, instance).putRolePlayer(this.resourceValue, (Instance)resource);
            } else {
                LOGGER.debug("Correct assertion already exists");
            }
        });
        this.graph.commit();
        this.graph.close();
    }

    private void refreshOntologyElements() {
        this.resourceType = this.graph.getResourceType(this.resourceTypeName);
        this.resourceOwner = this.graph.getRoleType(Schema.Resource.HAS_RESOURCE_OWNER.getName(this.resourceTypeName));
        this.resourceValue = this.graph.getRoleType(Schema.Resource.HAS_RESOURCE_VALUE.getName(this.resourceTypeName));
        this.relationType = this.graph.getRelationType(Schema.Resource.HAS_RESOURCE.getName(this.resourceTypeName));
    }

    private void initialiseGraph() {
        if (this.graph == null || this.graph.isClosed()) {
            this.graph = Grakn.factory((String)"localhost:4567", (String)this.keyspace).getGraphBatchLoading();
            this.graph.rollback();
            this.refreshOntologyElements();
        }
    }
}

