/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.graql.internal.analytics.GraknMapReduce;
import ai.grakn.graql.internal.analytics.Utility;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.KeyValue;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class ClusterMemberMapReduce
extends GraknMapReduce<Set<String>> {
    private static final String CLUSTER_LABEL = "clusterMemberMapReduce.clusterLabel";
    private static final String CLUSTER_SIZE = "clusterSizeMapReduce.clusterSize";

    public ClusterMemberMapReduce() {
    }

    public ClusterMemberMapReduce(Set<String> selectedTypes, String clusterLabel) {
        this.selectedTypes = selectedTypes;
        this.persistentProperties.put(CLUSTER_LABEL, clusterLabel);
    }

    public ClusterMemberMapReduce(Set<String> selectedTypes, String clusterLabel, Long clusterSize) {
        this(selectedTypes, clusterLabel);
        this.persistentProperties.put(CLUSTER_SIZE, clusterSize);
    }

    @Override
    public void safeMap(Vertex vertex, MapReduce.MapEmitter<Serializable, Set<String>> emitter) {
        if (this.selectedTypes.contains(Utility.getVertexType(vertex)) && vertex.property((String)this.persistentProperties.get(CLUSTER_LABEL)).isPresent()) {
            emitter.emit(vertex.value((String)this.persistentProperties.get(CLUSTER_LABEL)), Collections.singleton(vertex.id().toString()));
            return;
        }
        emitter.emit((Object)MapReduce.NullObject.instance(), Collections.emptySet());
    }

    public void reduce(Serializable key, Iterator<Set<String>> values, MapReduce.ReduceEmitter<Serializable, Set<String>> emitter) {
        HashSet set = new HashSet();
        while (values.hasNext()) {
            set.addAll(values.next());
        }
        emitter.emit((Object)key, set);
    }

    public void combine(Serializable key, Iterator<Set<String>> values, MapReduce.ReduceEmitter<Serializable, Set<String>> emitter) {
        this.reduce(key, values, emitter);
    }

    public boolean doStage(MapReduce.Stage stage) {
        return true;
    }

    public Map<Serializable, Set<String>> generateFinalResult(Iterator<KeyValue<Serializable, Set<String>>> keyValues) {
        HashMap<Serializable, Set<String>> clusterPopulation = new HashMap<Serializable, Set<String>>();
        if (this.persistentProperties.containsKey(CLUSTER_SIZE)) {
            keyValues.forEachRemaining(pair -> {
                if (Long.valueOf(((Set)pair.getValue()).size()).equals(this.persistentProperties.get(CLUSTER_SIZE))) {
                    clusterPopulation.put((Serializable)pair.getKey(), (Set<String>)pair.getValue());
                }
            });
        } else {
            keyValues.forEachRemaining(pair -> {
                Set cfr_ignored_0 = (Set)clusterPopulation.put((Serializable)pair.getKey(), (Set<String>)pair.getValue());
            });
        }
        clusterPopulation.remove(MapReduce.NullObject.instance());
        return clusterPopulation;
    }
}

