/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.graql.internal.analytics.GraknMapReduce;
import ai.grakn.graql.internal.analytics.Utility;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.KeyValue;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class ClusterSizeMapReduce
extends GraknMapReduce<Long> {
    private static final String CLUSTER_LABEL = "clusterSizeMapReduce.clusterLabel";
    private static final String CLUSTER_SIZE = "clusterSizeMapReduce.clusterSize";

    public ClusterSizeMapReduce() {
    }

    public ClusterSizeMapReduce(Set<String> selectedTypes, String clusterLabel) {
        this.selectedTypes = selectedTypes;
        this.persistentProperties.put(CLUSTER_LABEL, clusterLabel);
    }

    public ClusterSizeMapReduce(Set<String> selectedTypes, String clusterLabel, Long clusterSize) {
        this(selectedTypes, clusterLabel);
        this.persistentProperties.put(CLUSTER_SIZE, clusterSize);
    }

    @Override
    public void safeMap(Vertex vertex, MapReduce.MapEmitter<Serializable, Long> emitter) {
        if (this.selectedTypes.contains(Utility.getVertexType(vertex))) {
            emitter.emit(vertex.value((String)this.persistentProperties.get(CLUSTER_LABEL)), (Object)1L);
            return;
        }
        emitter.emit((Object)MapReduce.NullObject.instance(), (Object)0L);
    }

    public void reduce(Serializable key, Iterator<Long> values, MapReduce.ReduceEmitter<Serializable, Long> emitter) {
        emitter.emit((Object)key, IteratorUtils.reduce(values, (Object)0L, (a, b) -> a + b));
    }

    public void combine(Serializable key, Iterator<Long> values, MapReduce.ReduceEmitter<Serializable, Long> emitter) {
        this.reduce(key, values, emitter);
    }

    public boolean doStage(MapReduce.Stage stage) {
        return true;
    }

    public Map<Serializable, Long> generateFinalResult(Iterator<KeyValue<Serializable, Long>> keyValues) {
        HashMap<Serializable, Long> clusterPopulation = new HashMap<Serializable, Long>();
        if (this.persistentProperties.containsKey(CLUSTER_SIZE)) {
            keyValues.forEachRemaining(pair -> {
                if (((Long)pair.getValue()).equals(this.persistentProperties.get(CLUSTER_SIZE))) {
                    clusterPopulation.put((Serializable)pair.getKey(), (Long)pair.getValue());
                }
            });
        } else {
            keyValues.forEachRemaining(pair -> {
                Long cfr_ignored_0 = (Long)clusterPopulation.put((Serializable)pair.getKey(), (Long)pair.getValue());
            });
        }
        clusterPopulation.remove(MapReduce.NullObject.instance());
        return clusterPopulation;
    }
}

