/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.util.Schema;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.structure.Graph;

public abstract class CommonOLAP {
    private static final String PREFIX_SELECTED_TYPE_KEY = "SELECTED_TYPE";
    private static final String PREFIX_PERSISTENT_PROPERTIES = "PERSISTENT";
    public static final Set<String> analyticsElements = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{Schema.Analytics.DEGREE.getName(), Schema.Resource.HAS_RESOURCE.getName(Schema.Analytics.DEGREE.getName()), Schema.Analytics.CLUSTER.getName(), Schema.Resource.HAS_RESOURCE.getName(Schema.Analytics.CLUSTER.getName())}));
    final Set<String> baseTypes = Sets.newHashSet((Object[])new String[]{Schema.BaseType.ENTITY.name(), Schema.BaseType.RELATION.name(), Schema.BaseType.RESOURCE.name()});
    Set<String> selectedTypes = new HashSet<String>();
    final Map<String, Object> persistentProperties = new HashMap<String, Object>();

    public void storeState(Configuration configuration) {
        HashSet oldKeys = new HashSet();
        configuration.subset(PREFIX_SELECTED_TYPE_KEY).getKeys().forEachRemaining(key -> oldKeys.add("SELECTED_TYPE." + key));
        oldKeys.forEach(arg_0 -> ((Configuration)configuration).clearProperty(arg_0));
        this.selectedTypes.forEach(typeId -> configuration.addProperty("SELECTED_TYPE." + typeId, typeId));
        this.persistentProperties.forEach((key, value) -> configuration.addProperty("PERSISTENT." + key, value));
    }

    public void loadState(Graph graph, Configuration configuration) {
        configuration.subset(PREFIX_SELECTED_TYPE_KEY).getKeys().forEachRemaining(key -> this.selectedTypes.add(configuration.getString("SELECTED_TYPE." + key)));
        configuration.subset(PREFIX_PERSISTENT_PROPERTIES).getKeys().forEachRemaining(key -> this.persistentProperties.put((String)key, configuration.getProperty("PERSISTENT." + key)));
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

