/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.graql.internal.analytics.GraknVertexProgram;
import ai.grakn.graql.internal.analytics.Utility;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.javatuples.Pair;
import org.javatuples.Tuple;

public class ShortestPathVertexProgram
extends GraknVertexProgram<Tuple> {
    private static final int MAX_ITERATION = 50;
    private static final String DIVIDER = "\t";
    private static final String IS_ACTIVE_CASTING = "shortestPathVertexProgram.isActiveCasting";
    private static final String PREDECESSOR = "shortestPathVertexProgram.fromVertex";
    public static final String FOUND_IN_ITERATION = "shortestPathVertexProgram.foundInIteration";
    private static final String VOTE_TO_HALT_SOURCE = "shortestPathVertexProgram.voteToHalt.source";
    private static final String VOTE_TO_HALT_DESTINATION = "shortestPathVertexProgram.voteToHalt.destination";
    private static final String FOUND_PATH = "shortestPathVertexProgram.foundDestination";
    private static final String PREDECESSOR_FROM_SOURCE = "shortestPathVertexProgram.fromSource";
    private static final String PREDECESSOR_FROM_DESTINATION = "shortestPathVertexProgram.fromDestination";
    private static final String PREDECESSORS = "shortestPathVertexProgram.predecessors";
    public static final String MIDDLE = "shortestPathVertexProgram.middle";
    private static final Set<String> ELEMENT_COMPUTE_KEYS = Sets.newHashSet((Object[])new String[]{"shortestPathVertexProgram.isActiveCasting", "shortestPathVertexProgram.fromVertex", "shortestPathVertexProgram.foundInIteration"});
    private static final Set<String> MEMORY_COMPUTE_KEYS = Sets.newHashSet((Object[])new String[]{"shortestPathVertexProgram.voteToHalt.source", "shortestPathVertexProgram.voteToHalt.destination", "shortestPathVertexProgram.foundDestination", "shortestPathVertexProgram.fromSource", "shortestPathVertexProgram.fromDestination", "shortestPathVertexProgram.predecessors", "shortestPathVertexProgram.middle"});
    private static final String MESSAGE_FROM_ROLE_PLAYER = "R";
    private static final String MESSAGE_FROM_ASSERTION = "A";
    private static final String SOURCE = "shortestPathVertexProgram.startId";
    private static final String DESTINATION = "shortestPathVertexProgram.endId";

    public ShortestPathVertexProgram() {
    }

    public ShortestPathVertexProgram(Set<String> selectedTypes, String sourceId, String destinationId) {
        this.selectedTypes = selectedTypes;
        this.persistentProperties.put(SOURCE, sourceId);
        this.persistentProperties.put(DESTINATION, destinationId);
    }

    public Set<String> getElementComputeKeys() {
        return ELEMENT_COMPUTE_KEYS;
    }

    public Set<String> getMemoryComputeKeys() {
        return MEMORY_COMPUTE_KEYS;
    }

    @Override
    public Set<MessageScope> getMessageScopes(Memory memory) {
        if (((Boolean)memory.get(FOUND_PATH)).booleanValue()) {
            return Collections.emptySet();
        }
        return messageScopeSet;
    }

    @Override
    public void setup(Memory memory) {
        LOGGER.debug("ShortestPathVertexProgram Started !!!!!!!!");
        memory.set(VOTE_TO_HALT_SOURCE, (Object)true);
        memory.set(VOTE_TO_HALT_DESTINATION, (Object)true);
        memory.set(FOUND_PATH, (Object)false);
        memory.set(PREDECESSOR_FROM_SOURCE, (Object)"");
        memory.set(PREDECESSOR_FROM_DESTINATION, (Object)"");
        memory.set(PREDECESSORS, (Object)"");
        memory.set(MIDDLE, (Object)"");
    }

    @Override
    public void safeExecute(Vertex vertex, Messenger<Tuple> messenger, Memory memory) {
        switch (memory.getIteration()) {
            case 0: {
                if (!this.selectedTypes.contains(Utility.getVertexType(vertex))) break;
                String type = vertex.label();
                if (type.equals(Schema.BaseType.ENTITY.name()) || type.equals(Schema.BaseType.RESOURCE.name())) {
                    messenger.sendMessage((MessageScope)messageScopeIn, (Object)Pair.with((Object)MESSAGE_FROM_ROLE_PLAYER, (Object)0));
                } else if (type.equals(Schema.BaseType.RELATION.name())) {
                    messenger.sendMessage((MessageScope)messageScopeIn, (Object)Pair.with((Object)MESSAGE_FROM_ROLE_PLAYER, (Object)0));
                    messenger.sendMessage((MessageScope)messageScopeOut, (Object)Pair.with((Object)MESSAGE_FROM_ASSERTION, (Object)0));
                }
                String id = vertex.id().toString();
                if (this.persistentProperties.get(SOURCE).equals(id)) {
                    LOGGER.debug("Found source vertex");
                    vertex.property(PREDECESSOR, (Object)"");
                    messenger.sendMessage((MessageScope)messageScopeIn, (Object)Pair.with((Object)id, (Object)1));
                    messenger.sendMessage((MessageScope)messageScopeOut, (Object)Pair.with((Object)id, (Object)2));
                    break;
                }
                if (!this.persistentProperties.get(DESTINATION).equals(id)) break;
                LOGGER.debug("Found destination vertex");
                vertex.property(PREDECESSOR, (Object)"");
                messenger.sendMessage((MessageScope)messageScopeIn, (Object)Pair.with((Object)id, (Object)-1));
                messenger.sendMessage((MessageScope)messageScopeOut, (Object)Pair.with((Object)id, (Object)-2));
                break;
            }
            case 1: {
                if (!vertex.label().equals(Schema.BaseType.CASTING.name())) break;
                HashSet<String> messageSet = new HashSet<String>();
                HashMap<Integer, Tuple> messageMap = new HashMap<Integer, Tuple>();
                Iterator iterator = messenger.receiveMessages();
                int i = 0;
                while (iterator.hasNext()) {
                    Tuple message = (Tuple)iterator.next();
                    String messageContent = (String)message.getValue(0);
                    int messageDirection = (Integer)message.getValue(1);
                    LOGGER.debug("Message " + i++ + ": " + messageContent);
                    if (messageDirection == 0) {
                        messageSet.add(messageContent);
                        continue;
                    }
                    messageMap.put(messageDirection, message);
                }
                if (messageSet.size() != 2) break;
                LOGGER.debug("Considering casting " + vertex.id().toString());
                vertex.property(IS_ACTIVE_CASTING, (Object)true);
                this.sendMessagesFromCasting(messenger, memory, messageMap);
                break;
            }
            default: {
                if (((Boolean)memory.get(FOUND_PATH)).booleanValue()) {
                    String id = vertex.id().toString();
                    if (memory.get(PREDECESSOR_FROM_SOURCE).equals(id)) {
                        LOGGER.debug("Traversing back to vertex " + id);
                        memory.set(PREDECESSOR_FROM_SOURCE, vertex.value(PREDECESSOR));
                        vertex.property(FOUND_IN_ITERATION, (Object)(-1 * memory.getIteration()));
                        break;
                    }
                    if (!memory.get(PREDECESSOR_FROM_DESTINATION).equals(id)) break;
                    LOGGER.debug("Traversing back to vertex " + id);
                    memory.set(PREDECESSOR_FROM_DESTINATION, vertex.value(PREDECESSOR));
                    vertex.property(FOUND_IN_ITERATION, (Object)memory.getIteration());
                    break;
                }
                if (!messenger.receiveMessages().hasNext()) break;
                if (memory.getIteration() % 2 == 0) {
                    if (!this.selectedTypes.contains(Utility.getVertexType(vertex))) break;
                    this.updateInstance(vertex, messenger, memory);
                    break;
                }
                if (!vertex.label().equals(Schema.BaseType.CASTING.name()) || !vertex.property(IS_ACTIVE_CASTING).isPresent()) break;
                this.updateCasting(vertex, messenger, memory);
            }
        }
    }

    private void updateInstance(Vertex vertex, Messenger<Tuple> messenger, Memory memory) {
        if (!vertex.property(PREDECESSOR).isPresent()) {
            String id = vertex.id().toString();
            LOGGER.debug("Considering instance " + id);
            Iterator iterator = messenger.receiveMessages();
            boolean hasMessageSource = false;
            boolean hasMessageDestination = false;
            String predecessorFromSource = null;
            String predecessorFromDestination = null;
            while (iterator.hasNext()) {
                Tuple message = (Tuple)iterator.next();
                int messageDirection = (Integer)message.getValue(1);
                if (messageDirection > 0) {
                    if (!hasMessageSource) {
                        LOGGER.debug("Received a message from source vertex");
                        hasMessageSource = true;
                        predecessorFromSource = (String)message.getValue(0);
                        messenger.sendMessage((MessageScope)messageScopeIn, (Object)Pair.with((Object)id, (Object)1));
                        messenger.sendMessage((MessageScope)messageScopeOut, (Object)Pair.with((Object)id, (Object)2));
                        vertex.property(PREDECESSOR, (Object)predecessorFromSource);
                        memory.and(VOTE_TO_HALT_SOURCE, false);
                    }
                } else if (!hasMessageDestination) {
                    LOGGER.debug("Received a message from destination vertex");
                    hasMessageDestination = true;
                    predecessorFromDestination = (String)message.getValue(0);
                    messenger.sendMessage((MessageScope)messageScopeIn, (Object)Pair.with((Object)id, (Object)-1));
                    messenger.sendMessage((MessageScope)messageScopeOut, (Object)Pair.with((Object)id, (Object)-2));
                    vertex.property(PREDECESSOR, (Object)predecessorFromDestination);
                    memory.and(VOTE_TO_HALT_DESTINATION, false);
                }
                if (!hasMessageSource || !hasMessageDestination) continue;
                LOGGER.debug("Found path");
                memory.or(FOUND_PATH, true);
                memory.set(PREDECESSORS, (Object)(predecessorFromSource + DIVIDER + predecessorFromDestination + DIVIDER + id));
                return;
            }
        }
    }

    private void updateCasting(Vertex vertex, Messenger<Tuple> messenger, Memory memory) {
        LOGGER.debug("Considering casting " + vertex.id().toString());
        HashMap<Integer, Tuple> messageMap = new HashMap<Integer, Tuple>();
        Iterator iterator = messenger.receiveMessages();
        int i = 0;
        while (iterator.hasNext()) {
            Tuple message = (Tuple)iterator.next();
            LOGGER.debug("Message " + i++ + ": " + message.getValue(0));
            messageMap.put((int)((Integer)message.getValue(1)), message);
        }
        this.sendMessagesFromCasting(messenger, memory, messageMap);
    }

    private void sendMessagesFromCasting(Messenger<Tuple> messenger, Memory memory, Map<Integer, Tuple> messageMap) {
        int sum = messageMap.keySet().stream().mapToInt(Integer::intValue).sum();
        if (messageMap.size() == 3) {
            LOGGER.debug("3 messages received, message sum = " + sum);
            LOGGER.debug("Found path");
            memory.or(FOUND_PATH, true);
            if (sum == 1) {
                memory.set(PREDECESSORS, (Object)(messageMap.get(1).getValue(0) + DIVIDER + messageMap.get(-2).getValue(0)));
            } else {
                memory.set(PREDECESSORS, (Object)(messageMap.get(2).getValue(0) + DIVIDER + messageMap.get(-1).getValue(0)));
            }
            return;
        }
        if (messageMap.size() == 2) {
            LOGGER.debug("2 messages received, message sum = " + sum);
            switch (sum) {
                case 0: {
                    messenger.sendMessage((MessageScope)messageScopeOut, (Object)messageMap.get(2));
                    messenger.sendMessage((MessageScope)messageScopeOut, (Object)messageMap.get(-2));
                    break;
                }
                case 3: {
                    messenger.sendMessage((MessageScope)messageScopeIn, (Object)messageMap.get(1));
                    messenger.sendMessage((MessageScope)messageScopeOut, (Object)messageMap.get(2));
                    break;
                }
                case -3: {
                    messenger.sendMessage((MessageScope)messageScopeIn, (Object)messageMap.get(-1));
                    messenger.sendMessage((MessageScope)messageScopeOut, (Object)messageMap.get(-2));
                    break;
                }
                case 1: {
                    LOGGER.debug("Found path");
                    memory.or(FOUND_PATH, true);
                    memory.set(PREDECESSORS, (Object)(messageMap.get(2).getValue(0) + DIVIDER + messageMap.get(-1).getValue(0)));
                    break;
                }
                case -1: {
                    LOGGER.debug("Found path");
                    memory.or(FOUND_PATH, true);
                    memory.set(PREDECESSORS, (Object)(messageMap.get(1).getValue(0) + DIVIDER + messageMap.get(-2).getValue(0)));
                }
            }
        } else if (messageMap.size() == 1) {
            LOGGER.debug("1 message received, message sum = " + sum);
            switch (sum) {
                case 1: {
                    messenger.sendMessage((MessageScope)messageScopeIn, (Object)messageMap.get(1));
                    break;
                }
                case -1: {
                    messenger.sendMessage((MessageScope)messageScopeIn, (Object)messageMap.get(-1));
                    break;
                }
                case 2: {
                    messenger.sendMessage((MessageScope)messageScopeOut, (Object)messageMap.get(2));
                    break;
                }
                case -2: {
                    messenger.sendMessage((MessageScope)messageScopeOut, (Object)messageMap.get(-2));
                }
            }
        }
    }

    public boolean terminate(Memory memory) {
        LOGGER.debug("Finished Iteration " + memory.getIteration());
        if (memory.getIteration() == 0) {
            return false;
        }
        if (((Boolean)memory.get(FOUND_PATH)).booleanValue()) {
            if (!memory.get(PREDECESSORS).equals("")) {
                String[] predecessors = ((String)memory.get(PREDECESSORS)).split(DIVIDER);
                memory.set(PREDECESSORS, (Object)"");
                memory.set(PREDECESSOR_FROM_SOURCE, (Object)predecessors[0]);
                memory.set(PREDECESSOR_FROM_DESTINATION, (Object)predecessors[1]);
                if (predecessors.length > 2) {
                    memory.set(MIDDLE, (Object)predecessors[2]);
                }
            }
            return memory.get(PREDECESSOR_FROM_SOURCE).equals(this.persistentProperties.get(SOURCE));
        }
        if (memory.getIteration() % 2 == 0 && (((Boolean)memory.get(VOTE_TO_HALT_SOURCE)).booleanValue() || ((Boolean)memory.get(VOTE_TO_HALT_DESTINATION)).booleanValue())) {
            LOGGER.debug("There is no path between the given instances");
            throw new IllegalStateException(ErrorMessage.NO_PATH_EXIST.getMessage(new Object[0]));
        }
        if (memory.getIteration() == 50) {
            LOGGER.debug("Reached Max Iteration: 50 !!!!!!!!");
            throw new IllegalStateException(ErrorMessage.MAX_ITERATION_REACHED.getMessage(new Object[]{this.getClass().toString()}));
        }
        memory.or(VOTE_TO_HALT_SOURCE, true);
        memory.or(VOTE_TO_HALT_DESTINATION, true);
        return false;
    }
}

