/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin;

import ai.grakn.graql.admin.Conjunction;
import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.ShortcutTraversal;
import ai.grakn.graql.internal.gremlin.fragment.Fragment;
import ai.grakn.graql.internal.gremlin.fragment.Fragments;
import ai.grakn.graql.internal.pattern.property.VarPropertyInternal;
import ai.grakn.graql.internal.util.CommonUtil;
import ai.grakn.util.ErrorMessage;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ConjunctionQuery {
    private final Set<VarAdmin> vars;
    private final ImmutableSet<EquivalentFragmentSet> equivalentFragmentSets;

    ConjunctionQuery(Conjunction<VarAdmin> patternConjunction) {
        this.vars = patternConjunction.getPatterns();
        if (this.vars.size() == 0) {
            throw new IllegalArgumentException(ErrorMessage.MATCH_NO_PATTERNS.getMessage(new Object[0]));
        }
        ImmutableSet fragmentSets = this.vars.stream().flatMap(ConjunctionQuery::equivalentFragmentSetsRecursive).collect(CommonUtil.toImmutableSet());
        Set names = (Set)fragmentSets.stream().flatMap(EquivalentFragmentSet::getFragments).filter(fragment -> !fragment.isStartingFragment()).flatMap(Fragment::getVariableNames).collect(CommonUtil.toImmutableSet());
        Set dependencies = (Set)fragmentSets.stream().flatMap(EquivalentFragmentSet::getFragments).flatMap(fragment -> fragment.getDependencies().stream()).collect(CommonUtil.toImmutableSet());
        Sets.SetView validNames = Sets.difference((Set)names, (Set)dependencies);
        this.equivalentFragmentSets = fragmentSets.stream().filter(arg_0 -> ConjunctionQuery.lambda$new$225((Set)validNames, arg_0)).collect(CommonUtil.toImmutableSet());
    }

    ImmutableSet<EquivalentFragmentSet> getEquivalentFragmentSets() {
        return this.equivalentFragmentSets;
    }

    Set<List<Fragment>> allFragmentOrders() {
        Collection fragmentSetPermutations = Collections2.permutations(this.equivalentFragmentSets);
        return fragmentSetPermutations.stream().flatMap(ConjunctionQuery::cartesianProduct).collect(Collectors.toSet());
    }

    private static Stream<List<Fragment>> cartesianProduct(List<EquivalentFragmentSet> fragmentSets) {
        List fragments = fragmentSets.stream().map(set -> set.getFragments().collect(Collectors.toSet())).collect(Collectors.toList());
        return Sets.cartesianProduct(fragments).stream();
    }

    Stream<String> getConcepts() {
        return this.vars.stream().flatMap(v -> v.getInnerVars().stream()).flatMap(v -> v.getTypeNames().stream());
    }

    private static Stream<EquivalentFragmentSet> equivalentFragmentSetsRecursive(VarAdmin var) {
        return var.getImplicitInnerVars().stream().flatMap(ConjunctionQuery::equivalentFragmentSetsOfVar);
    }

    private static Stream<EquivalentFragmentSet> equivalentFragmentSetsOfVar(VarAdmin var) {
        ShortcutTraversal shortcutTraversal = new ShortcutTraversal();
        HashSet traversals = new HashSet();
        if (var.isUserDefinedName()) {
            shortcutTraversal.setInvalid();
        }
        String start = var.getVarName();
        var.getProperties().forEach(property -> {
            VarPropertyInternal propertyInternal = (VarPropertyInternal)property;
            propertyInternal.modifyShortcutTraversal(shortcutTraversal);
            Collection<EquivalentFragmentSet> newTraversals = propertyInternal.match(start);
            traversals.addAll(newTraversals);
        });
        if (shortcutTraversal.isValid()) {
            return Stream.of(shortcutTraversal.getEquivalentFragmentSet());
        }
        if (!traversals.isEmpty()) {
            return traversals.stream();
        }
        return Stream.of(EquivalentFragmentSet.create(Fragments.notCasting(start)));
    }

    private static /* synthetic */ boolean lambda$new$225(Set set, EquivalentFragmentSet set2) {
        return set2.getFragments().anyMatch(fragment -> !fragment.isStartingFragment() || !set.contains(fragment.getStart()));
    }
}

