/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin;

import ai.grakn.GraknGraph;
import ai.grakn.graql.internal.gremlin.ConjunctionQuery;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.fragment.Fragment;
import ai.grakn.graql.internal.util.CommonUtil;
import ai.grakn.util.ErrorMessage;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.javatuples.Pair;

public class GraqlTraversal {
    private final ImmutableSet<ImmutableList<Fragment>> fragments;
    private final GraknGraph graph;
    private static final long NUM_VERTICES_ESTIMATE = 10000L;
    private static final long MAX_TRAVERSAL_ATTEMPTS = 1000L;

    private GraqlTraversal(GraknGraph graph, Set<? extends List<Fragment>> fragments) {
        this.graph = graph;
        this.fragments = fragments.stream().map(ImmutableList::copyOf).collect(CommonUtil.toImmutableSet());
    }

    public static GraqlTraversal create(GraknGraph graph, Set<? extends List<Fragment>> fragments) {
        return new GraqlTraversal(graph, fragments);
    }

    static GraqlTraversal semiOptimal(GraknGraph graph, Collection<ConjunctionQuery> innerQueries) {
        Set fragments = (Set)innerQueries.stream().map(GraqlTraversal::semiOptimalConjunction).collect(CommonUtil.toImmutableSet());
        return GraqlTraversal.create(graph, fragments);
    }

    private static List<Fragment> semiOptimalConjunction(ConjunctionQuery query) {
        HashSet fragmentSets = Sets.newHashSet(query.getEquivalentFragmentSets());
        HashSet<String> names = new HashSet<String>();
        ArrayList<Fragment> fragments = new ArrayList<Fragment>();
        long numFragments = GraqlTraversal.fragments(fragmentSets).count();
        long depth = 1L;
        for (long numTraversalAttempts = numFragments; numFragments > 0L && numTraversalAttempts < 1000L; numTraversalAttempts *= numFragments, --numFragments) {
            ++depth;
        }
        double cost = 1.0;
        while (!fragmentSets.isEmpty()) {
            Pair<Double, List<Fragment>> pair = GraqlTraversal.findPlan(fragmentSets, names, cost, depth);
            cost = (Double)pair.getValue0();
            List newFragments = Lists.reverse((List)((List)pair.getValue1()));
            if (newFragments.isEmpty()) {
                throw new RuntimeException(ErrorMessage.FAILED_TO_BUILD_TRAVERSAL.getMessage(new Object[0]));
            }
            newFragments.forEach(fragment -> {
                fragmentSets.remove(fragment.getEquivalentFragmentSet());
                fragment.getVariableNames().forEach(names::add);
            });
            fragments.addAll(newFragments);
        }
        return fragments;
    }

    private static Pair<Double, List<Fragment>> findPlan(Set<EquivalentFragmentSet> fragmentSets, Set<String> names, double cost, long depth) {
        Pair baseCase = Pair.with((Object)cost, (Object)Lists.newArrayList());
        if (depth == 0L) {
            return baseCase;
        }
        Comparator<Pair> byCost = Comparator.comparing(Pair::getValue0);
        return GraqlTraversal.fragments(fragmentSets).filter(fragment -> names.containsAll(fragment.getDependencies())).map(fragment -> GraqlTraversal.findPlanWithFragment(fragment, fragmentSets, names, cost, depth)).min(byCost).orElse(baseCase);
    }

    private static Pair<Double, List<Fragment>> findPlanWithFragment(Fragment fragment, Set<EquivalentFragmentSet> fragmentSets, Set<String> names, double cost, long depth) {
        double newCost = GraqlTraversal.fragmentCost(fragment, cost, names);
        EquivalentFragmentSet fragmentSet = fragment.getEquivalentFragmentSet();
        Sets.SetView newFragmentSets = Sets.difference(fragmentSets, (Set)ImmutableSet.of((Object)fragmentSet));
        Sets.SetView newNames = Sets.union(names, fragment.getVariableNames().collect(Collectors.toSet()));
        Pair<Double, List<Fragment>> pair = GraqlTraversal.findPlan((Set<EquivalentFragmentSet>)newFragmentSets, (Set<String>)newNames, newCost, depth - 1L);
        ((List)pair.getValue1()).add(fragment);
        return pair.setAt0((Object)((Double)pair.getValue0() + newCost));
    }

    GraphTraversal<Vertex, Map<String, Vertex>> getGraphTraversal() {
        Traversal[] traversals = (Traversal[])this.fragments.stream().map(this::getConjunctionTraversal).toArray(Traversal[]::new);
        return this.graph.admin().getTinkerTraversal().limit(1L).union(traversals);
    }

    private GraphTraversal<Vertex, Map<String, Vertex>> getConjunctionTraversal(ImmutableList<Fragment> fragmentList) {
        GraphTraversal traversal = this.graph.admin().getTinkerTraversal();
        HashSet<String> foundNames = new HashSet<String>();
        String currentName = null;
        for (Fragment fragment : fragmentList) {
            this.applyFragment(fragment, (GraphTraversal<Vertex, Vertex>)traversal, currentName, foundNames);
            currentName = fragment.getEnd().orElse(fragment.getStart());
        }
        String[] traversalNames = foundNames.toArray(new String[foundNames.size()]);
        return traversal.select(traversalNames[0], traversalNames[0], traversalNames);
    }

    private void applyFragment(Fragment fragment, GraphTraversal<Vertex, Vertex> traversal, String currentName, Set<String> names) {
        String start = fragment.getStart();
        if (currentName != null) {
            if (!currentName.equals(start)) {
                if (names.contains(start)) {
                    traversal.select(start);
                } else {
                    traversal.V(new Object[0]).as(start, new String[0]);
                }
            }
        } else {
            traversal.as(start, new String[0]);
        }
        names.add(start);
        fragment.applyTraversal(traversal);
        fragment.getEnd().ifPresent(end -> {
            if (!names.contains(end)) {
                names.add((String)end);
                traversal.as(end, new String[0]);
            } else {
                traversal.where(P.eq((Object)end));
            }
        });
    }

    public double getComplexity() {
        double totalCost = 0.0;
        for (List list : this.fragments) {
            HashSet<String> names = new HashSet<String>();
            double cost = 1.0;
            double listCost = 0.0;
            for (Fragment fragment : list) {
                cost = GraqlTraversal.fragmentCost(fragment, cost, names);
                fragment.getVariableNames().forEach(names::add);
                listCost += cost;
            }
            totalCost += listCost;
        }
        return totalCost;
    }

    private static double fragmentCost(Fragment fragment, double previousCost, Set<String> names) {
        if (names.contains(fragment.getStart())) {
            return fragment.fragmentCost(previousCost);
        }
        return fragment.fragmentCost(10000.0) * previousCost + 1.0;
    }

    private static Stream<Fragment> fragments(Set<EquivalentFragmentSet> fragmentSets) {
        return fragmentSets.stream().flatMap(EquivalentFragmentSet::getFragments);
    }

    public String toString() {
        return "{" + this.fragments.stream().map(list -> {
            StringBuilder sb = new StringBuilder();
            String currentName = null;
            for (Fragment fragment : list) {
                if (!fragment.getStart().equals(currentName)) {
                    if (currentName != null) {
                        sb.append(" ");
                    }
                    sb.append("$").append(StringUtils.left((String)fragment.getStart(), (int)3));
                    currentName = fragment.getStart();
                }
                sb.append(fragment.getName());
                Optional<String> end = fragment.getEnd();
                if (!end.isPresent()) continue;
                sb.append("$").append(StringUtils.left((String)end.get(), (int)3));
                currentName = end.get();
            }
            return sb.toString();
        }).collect(Collectors.joining(", ")) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraqlTraversal that = (GraqlTraversal)o;
        if (this.fragments != null ? !this.fragments.equals(that.fragments) : that.fragments != null) {
            return false;
        }
        return this.graph != null ? this.graph.equals(that.graph) : that.graph == null;
    }

    public int hashCode() {
        int result = this.fragments != null ? this.fragments.hashCode() : 0;
        result = 31 * result + (this.graph != null ? this.graph.hashCode() : 0);
        return result;
    }
}

