/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin;

import ai.grakn.GraknGraph;
import ai.grakn.graql.admin.PatternAdmin;
import ai.grakn.graql.internal.gremlin.ConjunctionQuery;
import ai.grakn.graql.internal.gremlin.GraqlTraversal;
import ai.grakn.util.ErrorMessage;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GremlinQuery {
    protected final Logger LOG = LoggerFactory.getLogger(GremlinQuery.class);
    private final GraknGraph graph;
    private final Collection<ConjunctionQuery> innerQueries;
    private final ImmutableSet<String> names;

    public GremlinQuery(GraknGraph graph, PatternAdmin pattern, ImmutableSet<String> names) {
        Set patterns = pattern.getDisjunctiveNormalForm().getPatterns();
        if (graph == null) {
            throw new IllegalStateException(ErrorMessage.NO_GRAPH.getMessage(new Object[0]));
        }
        this.graph = graph;
        this.names = names;
        this.innerQueries = patterns.stream().map(ConjunctionQuery::new).collect(Collectors.toList());
    }

    public GraqlTraversal optimalTraversal() {
        return GraqlTraversal.semiOptimal(this.graph, this.innerQueries);
    }

    public GraphTraversal<Vertex, Map<String, Vertex>> getTraversal() {
        GraqlTraversal graqlTraversal = this.optimalTraversal();
        this.LOG.debug("Created query plan");
        this.LOG.debug(graqlTraversal.toString());
        GraphTraversal<Vertex, Map<String, Vertex>> traversal = graqlTraversal.getGraphTraversal();
        String[] namesArray = (String[])this.names.toArray((Object[])new String[this.names.size()]);
        if (namesArray.length != 0) {
            traversal.select(namesArray[0], namesArray[0], namesArray);
        }
        return traversal;
    }

    public Stream<String> getConcepts() {
        return this.innerQueries.stream().flatMap(ConjunctionQuery::getConcepts);
    }

    public Stream<GraqlTraversal> allGraqlTraversals() {
        List collect = this.innerQueries.stream().map(ConjunctionQuery::allFragmentOrders).collect(Collectors.toList());
        Set lists = Sets.cartesianProduct(collect);
        return lists.stream().map(list -> GraqlTraversal.create(this.graph, Sets.newHashSet((Iterable)list)));
    }
}

