/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.fragment;

import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.fragment.Fragment;
import ai.grakn.graql.internal.util.CommonUtil;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

abstract class AbstractFragment
implements Fragment {
    static final long NUM_INSTANCES_PER_TYPE = 100L;
    static final long NUM_INSTANCES_PER_SCOPE = 100L;
    static final long NUM_RELATION_PER_CASTING = 10L;
    static final long NUM_SHORTCUT_EDGES_PER_INSTANCE = 10L;
    static final long NUM_SUBTYPES_PER_TYPE = 3L;
    static final long NUM_CASTINGS_PER_INSTANCE = 3L;
    static final long NUM_SCOPES_PER_INSTANCE = 3L;
    static final long NUM_TYPES_PER_ROLE = 3L;
    static final long NUM_ROLES_PER_TYPE = 3L;
    static final long NUM_ROLES_PER_RELATION = 2L;
    static final long NUM_RESOURCES_PER_VALUE = 2L;
    private final String start;
    private final Optional<String> end;
    private EquivalentFragmentSet equivalentFragmentSet;

    AbstractFragment(String start) {
        this.start = start;
        this.end = Optional.empty();
    }

    AbstractFragment(String start, String end) {
        this.start = start;
        this.end = Optional.of(end);
    }

    @Override
    public final EquivalentFragmentSet getEquivalentFragmentSet() {
        return this.equivalentFragmentSet;
    }

    @Override
    public final void setEquivalentFragmentSet(EquivalentFragmentSet equivalentFragmentSet) {
        this.equivalentFragmentSet = equivalentFragmentSet;
    }

    @Override
    public final String getStart() {
        return this.start;
    }

    @Override
    public final Optional<String> getEnd() {
        return this.end;
    }

    @Override
    public Set<String> getDependencies() {
        return ImmutableSet.of();
    }

    @Override
    public Stream<String> getVariableNames() {
        return Stream.concat(Stream.of(this.start), CommonUtil.optionalToStream(this.end));
    }

    public String toString() {
        return "$" + this.start + this.getName() + this.end.map(e -> "$" + e).orElse("");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractFragment that = (AbstractFragment)o;
        if (this.start != null ? !this.start.equals(that.start) : that.start != null) {
            return false;
        }
        return !(this.end != null ? !this.end.equals(that.end) : that.end != null);
    }

    public int hashCode() {
        int result = this.start != null ? this.start.hashCode() : 0;
        result = 31 * result + (this.end != null ? this.end.hashCode() : 0);
        return result;
    }
}

