/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.hal;

import ai.grakn.concept.Concept;
import ai.grakn.concept.Entity;
import ai.grakn.concept.Instance;
import ai.grakn.concept.Relation;
import ai.grakn.concept.Resource;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.RoleType;
import ai.grakn.concept.Rule;
import ai.grakn.concept.Type;
import ai.grakn.graql.internal.hal.HALConceptRepresentationBuilder;
import ai.grakn.util.Schema;
import com.theoryinpractise.halbuilder.api.ReadableRepresentation;
import com.theoryinpractise.halbuilder.api.Representation;
import com.theoryinpractise.halbuilder.api.RepresentationFactory;
import com.theoryinpractise.halbuilder.standard.StandardRepresentationFactory;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

class HALConceptData {
    private final RepresentationFactory factory;
    private final Representation halResource;
    private final String resourceLinkPrefix;
    private final String resourceLinkOntologyPrefix;
    private final String keyspace;
    private static final String ISA_EDGE = "isa";
    private static final String SUB_EDGE = "sub";
    private static final String ONTOLOGY_LINK = "ontology";
    private static final String OUTBOUND_EDGE = "OUT";
    private static final String INBOUND_EDGE = "IN";
    private static final String ID_PROPERTY = "_id";
    private static final String TYPE_PROPERTY = "_type";
    private static final String BASETYPE_PROPERTY = "_baseType";
    private static final String DIRECTION_PROPERTY = "_direction";
    private static final String VALUE_PROPERTY = "value";
    private final boolean embedType;
    private final Set<String> typesInQuery;

    HALConceptData(Concept concept, int separationDegree, boolean embedTypeParam, Set<String> typesInQuery, String keyspace) {
        this.embedType = embedTypeParam;
        this.typesInQuery = typesInQuery;
        this.keyspace = "?keyspace=" + keyspace;
        this.resourceLinkPrefix = "/graph/concept/";
        this.resourceLinkOntologyPrefix = "/graph/concept/ontology/";
        this.factory = new StandardRepresentationFactory();
        this.halResource = this.factory.newRepresentation(this.resourceLinkPrefix + concept.getId() + this.keyspace);
        this.handleConcept(this.halResource, concept, separationDegree);
    }

    private void handleConcept(Representation halResource, Concept concept, int separationDegree) {
        Instance instance;
        this.generateStateAndLinks(halResource, concept);
        if (this.embedType && concept.isInstance() && (this.typesInQuery.contains((instance = concept.asInstance()).type().getName()) || instance.type().superType() != null && this.typesInQuery.contains(instance.type().superType().getName()))) {
            this.embedType(halResource, instance);
        }
        if (concept.isType() && concept.asType().superType() != null) {
            this.embedSuperType(halResource, concept.asType());
        }
        if (concept.isRelation() && separationDegree == 0) {
            this.generateRelationEmbedded(halResource, concept.asRelation(), 1);
        }
        if (concept.isRule()) {
            this.generateRuleLHS(halResource, concept.asRule());
            this.generateRuleRHS(halResource, concept.asRule());
        }
        if (separationDegree == 0) {
            return;
        }
        if (concept.isEntity()) {
            this.generateEntityEmbedded(halResource, concept.asEntity(), separationDegree);
        }
        if (concept.isRelation()) {
            this.generateRelationEmbedded(halResource, concept.asRelation(), separationDegree);
            this.embedRelationsPlaysRole(halResource, concept.asRelation());
        }
        if (concept.isResource()) {
            this.generateOwnerInstances(halResource, concept.asResource(), separationDegree);
        }
        if (concept.isType()) {
            this.generateTypeEmbedded(halResource, concept.asType(), separationDegree);
        }
    }

    private void generateRuleRHS(Representation halResource, Rule rule) {
        Representation RHS = this.factory.newRepresentation(this.resourceLinkPrefix + "RHS-" + rule.getId() + this.keyspace).withProperty(DIRECTION_PROPERTY, (Object)OUTBOUND_EDGE).withLink(ONTOLOGY_LINK, this.resourceLinkOntologyPrefix).withProperty(ID_PROPERTY, (Object)("RHS-" + rule.getId())).withProperty(TYPE_PROPERTY, (Object)"RHS").withProperty(BASETYPE_PROPERTY, (Object)Schema.BaseType.RESOURCE_TYPE.name()).withProperty(VALUE_PROPERTY, (Object)rule.getRHS().admin().toString());
        halResource.withRepresentation("RHS", (ReadableRepresentation)RHS);
    }

    private void generateRuleLHS(Representation halResource, Rule rule) {
        Representation LHS = this.factory.newRepresentation(this.resourceLinkPrefix + "LHS-" + rule.getId() + this.keyspace).withProperty(DIRECTION_PROPERTY, (Object)OUTBOUND_EDGE).withLink(ONTOLOGY_LINK, this.resourceLinkOntologyPrefix).withProperty(ID_PROPERTY, (Object)("LHS-" + rule.getId())).withProperty(TYPE_PROPERTY, (Object)"LHS").withProperty(BASETYPE_PROPERTY, (Object)Schema.BaseType.RESOURCE_TYPE.name()).withProperty(VALUE_PROPERTY, (Object)rule.getLHS().admin().toString());
        halResource.withRepresentation("LHS", (ReadableRepresentation)LHS);
    }

    private void generateOwnerInstances(Representation halResource, Resource<?> conceptResource, int separationDegree) {
        String roleType = conceptResource.type().getName();
        conceptResource.ownerInstances().forEach(instance -> {
            Representation instanceResource = this.factory.newRepresentation(this.resourceLinkPrefix + instance.getId() + this.keyspace).withProperty(DIRECTION_PROPERTY, (Object)INBOUND_EDGE);
            this.handleConcept(instanceResource, (Concept)instance, separationDegree - 1);
            halResource.withRepresentation(roleType, (ReadableRepresentation)instanceResource);
        });
    }

    private void embedSuperType(Representation halResource, Type type) {
        Representation HALType = this.factory.newRepresentation(this.resourceLinkPrefix + type.superType().getId() + this.keyspace).withProperty(DIRECTION_PROPERTY, (Object)OUTBOUND_EDGE);
        this.generateStateAndLinks(HALType, (Concept)type.superType());
        halResource.withRepresentation(SUB_EDGE, (ReadableRepresentation)HALType);
    }

    private void embedType(Representation halResource, Instance instance) {
        Representation HALType = this.factory.newRepresentation(this.resourceLinkPrefix + instance.type().getId() + this.keyspace).withProperty(DIRECTION_PROPERTY, (Object)OUTBOUND_EDGE);
        this.generateStateAndLinks(HALType, (Concept)instance.type());
        halResource.withRepresentation(ISA_EDGE, (ReadableRepresentation)HALType);
    }

    private void generateStateAndLinks(Representation resource, Concept concept) {
        resource.withLink(ONTOLOGY_LINK, this.resourceLinkOntologyPrefix + concept.getId() + this.keyspace);
        if (concept.isInstance()) {
            Instance instance = concept.asInstance();
            resource.withProperty(ID_PROPERTY, (Object)instance.getId()).withProperty(TYPE_PROPERTY, (Object)instance.type().getName()).withProperty(BASETYPE_PROPERTY, (Object)HALConceptRepresentationBuilder.getBaseType(instance).name());
        } else {
            Type type = concept.asType();
            resource.withProperty(ID_PROPERTY, (Object)type.getName()).withProperty(BASETYPE_PROPERTY, (Object)HALConceptRepresentationBuilder.getBaseType(type).name());
        }
        if (concept.isResource()) {
            resource.withProperty(VALUE_PROPERTY, concept.asResource().getValue());
        }
        if (concept.isEntity()) {
            this.generateResources(resource, concept.asEntity().resources(new ResourceType[0]));
        }
        if (concept.isRelation()) {
            this.generateResources(resource, concept.asRelation().resources(new ResourceType[0]));
        }
    }

    private void generateResources(Representation resource, Collection<Resource<?>> resourcesCollection) {
        resourcesCollection.forEach(currentResource -> {
            Representation embeddedResource = this.factory.newRepresentation(this.resourceLinkPrefix + currentResource.getId() + this.keyspace).withProperty(DIRECTION_PROPERTY, (Object)OUTBOUND_EDGE);
            this.generateStateAndLinks(embeddedResource, (Concept)currentResource);
            resource.withRepresentation(currentResource.type().getName(), (ReadableRepresentation)embeddedResource);
        });
    }

    private void generateEntityEmbedded(Representation halResource, Entity entity, int separationDegree) {
        entity.relations(new RoleType[0]).parallelStream().forEach(rel -> {
            String rolePlayedByCurrentConcept = null;
            boolean isResource = false;
            for (Map.Entry entry : rel.rolePlayers().entrySet()) {
                if (entry.getValue() == null) continue;
                if (((Instance)entry.getValue()).isResource()) {
                    isResource = true;
                    continue;
                }
                if (!((Instance)entry.getValue()).getId().equals(entity.getId())) continue;
                rolePlayedByCurrentConcept = ((RoleType)entry.getKey()).getName();
            }
            if (!isResource) {
                this.attachRelation(halResource, (Concept)rel, rolePlayedByCurrentConcept, separationDegree);
            }
        });
    }

    private void attachRelation(Representation halResource, Concept rel, String role, int separationDegree) {
        Representation relationResource = this.factory.newRepresentation(this.resourceLinkPrefix + rel.getId() + this.keyspace).withProperty(DIRECTION_PROPERTY, (Object)INBOUND_EDGE);
        this.handleConcept(relationResource, rel, separationDegree - 1);
        halResource.withRepresentation(role, (ReadableRepresentation)relationResource);
    }

    private void generateRelationEmbedded(Representation halResource, Relation rel, int separationDegree) {
        rel.rolePlayers().forEach((roleType, instance) -> {
            if (instance != null) {
                Representation roleResource = this.factory.newRepresentation(this.resourceLinkPrefix + instance.getId() + this.keyspace).withProperty(DIRECTION_PROPERTY, (Object)OUTBOUND_EDGE);
                this.handleConcept(roleResource, (Concept)instance, separationDegree - 1);
                halResource.withRepresentation(roleType.getName(), (ReadableRepresentation)roleResource);
            }
        });
    }

    private void embedRelationsPlaysRole(Representation halResource, Relation rel) {
        rel.playsRoles().forEach(roleTypeRel -> rel.relations(new RoleType[]{roleTypeRel}).forEach(relation -> {
            Representation relationRepresentation = this.factory.newRepresentation(this.resourceLinkPrefix + relation.getId() + this.keyspace).withProperty(DIRECTION_PROPERTY, (Object)INBOUND_EDGE);
            this.handleConcept(relationRepresentation, (Concept)relation, 0);
            halResource.withRepresentation(roleTypeRel.getName(), (ReadableRepresentation)relationRepresentation);
        }));
    }

    private void generateTypeEmbedded(Representation halResource, Type type, int separationDegree) {
        if (!type.getName().equals(Schema.MetaSchema.CONCEPT.getName())) {
            type.instances().parallelStream().forEach(instance -> {
                if (instance.isType() && instance.asType().isImplicit().booleanValue()) {
                    return;
                }
                Representation instanceResource = this.factory.newRepresentation(this.resourceLinkPrefix + instance.getId() + this.keyspace).withProperty(DIRECTION_PROPERTY, (Object)INBOUND_EDGE);
                this.handleConcept(instanceResource, (Concept)instance, separationDegree - 1);
                halResource.withRepresentation(ISA_EDGE, (ReadableRepresentation)instanceResource);
            });
        }
        type.subTypes().forEach(instance -> {
            if (!instance.getName().equals(type.getName())) {
                Representation instanceResource = this.factory.newRepresentation(this.resourceLinkPrefix + instance.getId() + this.keyspace).withProperty(DIRECTION_PROPERTY, (Object)INBOUND_EDGE);
                this.handleConcept(instanceResource, (Concept)instance, separationDegree - 1);
                halResource.withRepresentation(SUB_EDGE, (ReadableRepresentation)instanceResource);
            }
        });
    }

    public String render() {
        return this.halResource.toString("application/hal+json");
    }

    Representation getRepresentation() {
        return this.halResource;
    }
}

