/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.hal;

import ai.grakn.concept.Concept;
import ai.grakn.concept.Instance;
import ai.grakn.concept.RelationType;
import ai.grakn.concept.RoleType;
import ai.grakn.concept.Type;
import ai.grakn.graql.internal.hal.HALConceptRepresentationBuilder;
import com.theoryinpractise.halbuilder.api.ReadableRepresentation;
import com.theoryinpractise.halbuilder.api.Representation;
import com.theoryinpractise.halbuilder.api.RepresentationFactory;
import com.theoryinpractise.halbuilder.standard.StandardRepresentationFactory;
import java.util.Collection;

class HALConceptOntology {
    private final RepresentationFactory factory;
    private final Representation halResource;
    private final String keyspace;
    private final String resourceLinkPrefix;
    private final String resourceLinkOntologyPrefix;
    private static final String ROOT_CONCEPT = "type";
    private static final String ISA_EDGE = "isa";
    private static final String SUB_EDGE = "sub";
    private static final String ONTOLOGY_LINK = "ontology";
    private static final String OUTBOUND_EDGE = "OUT";
    private static final String INBOUND_EDGE = "IN";
    private static final String HAS_ROLE_EDGE = "has-role";
    private static final String PLAYS_ROLE_EDGE = "plays-role";
    private static final String ID_PROPERTY = "_id";
    private static final String TYPE_PROPERTY = "_type";
    private static final String BASETYPE_PROPERTY = "_baseType";
    private static final String DIRECTION_PROPERTY = "_direction";
    private static final String VALUE_PROPERTY = "value";

    HALConceptOntology(Concept concept, String keyspace) {
        this.resourceLinkPrefix = "/graph/concept/";
        this.resourceLinkOntologyPrefix = "/graph/concept/ontology/";
        this.keyspace = "?keyspace=" + keyspace;
        this.factory = new StandardRepresentationFactory();
        this.halResource = this.factory.newRepresentation(this.resourceLinkPrefix + concept.getId() + this.keyspace);
        this.handleConceptOntology(this.halResource, concept);
    }

    private void generateStateAndLinks(Representation resource, Concept concept) {
        resource.withLink(ONTOLOGY_LINK, this.resourceLinkOntologyPrefix + concept.getId() + this.keyspace);
        if (concept.isInstance()) {
            Instance instance = concept.asInstance();
            resource.withProperty(ID_PROPERTY, (Object)instance.getId()).withProperty(TYPE_PROPERTY, (Object)instance.type().getName()).withProperty(BASETYPE_PROPERTY, (Object)HALConceptRepresentationBuilder.getBaseType(instance).name());
        } else {
            Type type = concept.asType();
            resource.withProperty(ID_PROPERTY, (Object)concept.asType().getName()).withProperty(BASETYPE_PROPERTY, (Object)HALConceptRepresentationBuilder.getBaseType(type).name());
        }
        if (concept.isResource()) {
            resource.withProperty(VALUE_PROPERTY, concept.asResource().getValue());
        }
    }

    private void embedType(Representation halResource, Concept concept) {
        if (concept.isInstance()) {
            Instance instance = concept.asInstance();
            Representation HALType = this.factory.newRepresentation(this.resourceLinkPrefix + instance.type().getId() + this.keyspace).withProperty(DIRECTION_PROPERTY, (Object)OUTBOUND_EDGE);
            this.generateStateAndLinks(HALType, (Concept)instance.type());
            halResource.withRepresentation(ISA_EDGE, (ReadableRepresentation)HALType);
        }
    }

    private void handleConceptOntology(Representation halResource, Concept concept) {
        this.generateStateAndLinks(halResource, concept);
        this.embedType(halResource, concept);
        if (concept.isRelationType()) {
            this.relationTypeOntology(halResource, concept.asRelationType());
        } else if (concept.isRoleType()) {
            this.roleTypeOntology(halResource, concept.asRoleType());
        } else if (concept.isType()) {
            this.attachRolesPlayed(halResource, concept.asType().playsRoles());
        }
        if (concept.isType() && concept.asType().superType() != null) {
            this.embedSuperType(halResource, concept.asType());
        }
        if (concept.isType()) {
            concept.asType().subTypes().forEach(instance -> {
                if (!instance.getId().equals(concept.getId())) {
                    Representation instanceResource = this.factory.newRepresentation(this.resourceLinkPrefix + instance.getId() + this.keyspace).withProperty(DIRECTION_PROPERTY, (Object)INBOUND_EDGE);
                    this.generateStateAndLinks(instanceResource, (Concept)instance);
                    halResource.withRepresentation(SUB_EDGE, (ReadableRepresentation)instanceResource);
                }
            });
        }
    }

    private void embedSuperType(Representation halResource, Type type) {
        Representation HALType = this.factory.newRepresentation(this.resourceLinkPrefix + type.superType().getId() + this.keyspace).withProperty(DIRECTION_PROPERTY, (Object)OUTBOUND_EDGE);
        this.generateStateAndLinks(HALType, (Concept)type.superType());
        halResource.withRepresentation(SUB_EDGE, (ReadableRepresentation)HALType);
    }

    private void roleTypeOntology(Representation halResource, RoleType roleType) {
        roleType.playedByTypes().forEach(type -> {
            Representation roleRepresentation = this.factory.newRepresentation(this.resourceLinkPrefix + type.getId() + this.keyspace).withProperty(DIRECTION_PROPERTY, (Object)INBOUND_EDGE);
            this.generateStateAndLinks(roleRepresentation, (Concept)type);
            halResource.withRepresentation(PLAYS_ROLE_EDGE, (ReadableRepresentation)roleRepresentation);
        });
        RelationType relType = roleType.relationType();
        Representation roleRepresentation = this.factory.newRepresentation(this.resourceLinkPrefix + relType.getId() + this.keyspace).withProperty(DIRECTION_PROPERTY, (Object)INBOUND_EDGE);
        this.generateStateAndLinks(roleRepresentation, (Concept)relType);
        halResource.withRepresentation(HAS_ROLE_EDGE, (ReadableRepresentation)roleRepresentation);
        this.attachRolesPlayed(halResource, roleType.playsRoles());
    }

    private void relationTypeOntology(Representation halResource, RelationType relationType) {
        relationType.hasRoles().forEach(role -> {
            Representation roleRepresentation = this.factory.newRepresentation(this.resourceLinkPrefix + role.getId() + this.keyspace).withProperty(DIRECTION_PROPERTY, (Object)OUTBOUND_EDGE);
            this.generateStateAndLinks(roleRepresentation, (Concept)role);
            halResource.withRepresentation(HAS_ROLE_EDGE, (ReadableRepresentation)roleRepresentation);
        });
        this.attachRolesPlayed(halResource, relationType.playsRoles());
    }

    private void attachRolesPlayed(Representation halResource, Collection<RoleType> roles) {
        roles.forEach(role -> {
            Representation roleRepresentation = this.factory.newRepresentation(this.resourceLinkPrefix + role.getId() + this.keyspace).withProperty(DIRECTION_PROPERTY, (Object)OUTBOUND_EDGE);
            this.generateStateAndLinks(roleRepresentation, (Concept)role);
            halResource.withRepresentation(PLAYS_ROLE_EDGE, (ReadableRepresentation)roleRepresentation);
        });
    }

    public String render() {
        return this.halResource.toString("application/hal+json");
    }
}

