/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.hal;

import ai.grakn.concept.Concept;
import ai.grakn.concept.Instance;
import ai.grakn.concept.Type;
import ai.grakn.graql.MatchQuery;
import ai.grakn.graql.admin.RelationPlayer;
import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.internal.hal.HALConceptData;
import ai.grakn.graql.internal.hal.HALConceptOntology;
import ai.grakn.graql.internal.hal.HALGeneratedRelation;
import ai.grakn.graql.internal.pattern.property.IsaProperty;
import ai.grakn.graql.internal.pattern.property.RelationProperty;
import ai.grakn.util.Schema;
import com.theoryinpractise.halbuilder.api.ReadableRepresentation;
import com.theoryinpractise.halbuilder.api.Representation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mjson.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HALConceptRepresentationBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(HALConceptRepresentationBuilder.class);
    private static final int MATCH_QUERY_FIXED_DEGREE = 0;
    private static final String ASSERTION_URL = "/graph/match?keyspace=%s&query=match $x id '%s'; $y id '%s'; $r (%s$x, %s$y) %s; select $r;";
    private static final String HAS_ROLE_EDGE = "EMPTY-GRAKN-ROLE";

    public static Json renderHALArrayData(MatchQuery matchQuery, Collection<Map<String, Concept>> graqlResultsList, String keyspace) {
        Map<String, Collection<VarAdmin>> linkedNodes = HALConceptRepresentationBuilder.computeLinkedNodesFromQuery(matchQuery);
        Map<String, Map<String, String>> roleTypes = HALConceptRepresentationBuilder.computeRoleTypesFromQuery(matchQuery);
        Set<String> typesAskedInQuery = matchQuery.admin().getTypes().stream().map(x -> x.asType().getName()).collect(Collectors.toSet());
        return HALConceptRepresentationBuilder.buildHALRepresentations(graqlResultsList, linkedNodes, typesAskedInQuery, roleTypes, keyspace);
    }

    public static String renderHALConceptData(Concept concept, int separationDegree, String keyspace) {
        return new HALConceptData(concept, separationDegree, false, new HashSet<String>(), keyspace).render();
    }

    public static String renderHALConceptOntology(Concept concept, String keyspace) {
        return new HALConceptOntology(concept, keyspace).render();
    }

    private static Json buildHALRepresentations(Collection<Map<String, Concept>> graqlResultsList, Map<String, Collection<VarAdmin>> linkedNodes, Set<String> typesAskedInQuery, Map<String, Map<String, String>> roleTypes, String keyspace) {
        Json lines = Json.array();
        graqlResultsList.forEach(resultLine -> resultLine.entrySet().forEach(current -> {
            if (((Concept)current.getValue()).isType() && ((Concept)current.getValue()).asType().isImplicit().booleanValue()) {
                return;
            }
            LOG.trace("Building HAL resource for concept with id {}", (Object)((Concept)current.getValue()).getId());
            Representation currentHal = new HALConceptData((Concept)current.getValue(), 0, true, typesAskedInQuery, keyspace).getRepresentation();
            HALConceptRepresentationBuilder.attachGeneratedRelations(currentHal, current, linkedNodes, resultLine, roleTypes, keyspace);
            lines.add(Json.read((String)currentHal.toString("application/hal+json")));
        }));
        return lines;
    }

    private static void attachGeneratedRelations(Representation currentHal, Map.Entry<String, Concept> current, Map<String, Collection<VarAdmin>> linkedNodes, Map<String, Concept> resultLine, Map<String, Map<String, String>> roleTypes, String keyspace) {
        if (linkedNodes.containsKey(current.getKey())) {
            linkedNodes.get(current.getKey()).forEach(currentRelation -> {
                if (current.getValue() != null) {
                    String currentVarName = (String)current.getKey();
                    Concept currentRolePlayer = (Concept)current.getValue();
                    String relationType = currentRelation.getProperty(IsaProperty.class).flatMap(x -> x.getType().getTypeName()).orElse("");
                    ((RelationProperty)currentRelation.getProperty(RelationProperty.class).get()).getRelationPlayers().filter(x -> !x.getRolePlayer().getVarName().equals(currentVarName)).map(RelationPlayer::getRolePlayer).forEach(otherVar -> {
                        if (resultLine.get(otherVar.getVarName()) != null) {
                            HALConceptRepresentationBuilder.attachSingleGeneratedRelation(currentHal, currentRolePlayer, (Concept)resultLine.get(otherVar.getVarName()), (Map)roleTypes.get(String.valueOf(currentRelation.hashCode())), currentVarName, otherVar.getVarName(), relationType, keyspace);
                        }
                    });
                }
            });
        }
    }

    private static void attachSingleGeneratedRelation(Representation currentHal, Concept currentVar, Concept otherVar, Map<String, String> roleTypes, String currentVarName, String otherVarName, String relationType, String keyspace) {
        String secondRole;
        String firstRole;
        String secondID;
        String firstID;
        String currentID = currentVar.getId();
        if (currentID.compareTo(otherVar.getId()) > 0) {
            firstID = currentID;
            secondID = otherVar.getId();
            firstRole = roleTypes.get(currentVarName).equals(HAS_ROLE_EDGE) ? "" : roleTypes.get(currentVarName) + ":";
            secondRole = roleTypes.get(otherVarName).equals(HAS_ROLE_EDGE) ? "" : roleTypes.get(otherVarName) + ":";
        } else {
            firstID = otherVar.getId();
            secondID = currentID;
            secondRole = roleTypes.get(currentVarName).equals(HAS_ROLE_EDGE) ? "" : roleTypes.get(currentVarName) + ":";
            firstRole = roleTypes.get(otherVarName).equals(HAS_ROLE_EDGE) ? "" : roleTypes.get(otherVarName) + ":";
        }
        String isaString = relationType.length() == 0 ? "" : "isa " + relationType;
        String assertionID = String.format(ASSERTION_URL, keyspace, firstID, secondID, firstRole, secondRole, isaString);
        currentHal.withRepresentation(roleTypes.get(currentVarName), (ReadableRepresentation)new HALGeneratedRelation().getNewGeneratedRelation(assertionID, relationType));
    }

    private static Map<String, Collection<VarAdmin>> computeLinkedNodesFromQuery(MatchQuery matchQuery) {
        HashMap<String, Collection<VarAdmin>> linkedNodes = new HashMap<String, Collection<VarAdmin>>();
        matchQuery.admin().getPattern().getVars().forEach(var -> {
            if (var.getProperty(RelationProperty.class).isPresent()) {
                ArrayList rolePlayersInVar = new ArrayList();
                ((RelationProperty)var.getProperty(RelationProperty.class).get()).getRelationPlayers().map(x -> x.getRolePlayer().getVarName()).forEach(rolePlayersInVar::add);
                if (rolePlayersInVar.size() > 1) {
                    rolePlayersInVar.forEach(rolePlayer -> {
                        linkedNodes.putIfAbsent((String)rolePlayer, new HashSet());
                        rolePlayersInVar.forEach(y -> {
                            if (!y.equals(rolePlayer)) {
                                ((Collection)linkedNodes.get(rolePlayer)).add(var);
                            }
                        });
                    });
                }
            }
        });
        return linkedNodes;
    }

    private static Map<String, Map<String, String>> computeRoleTypesFromQuery(MatchQuery matchQuery) {
        HashMap<String, Map<String, String>> roleTypes = new HashMap<String, Map<String, String>>();
        matchQuery.admin().getPattern().getVars().forEach(var -> {
            if (var.getProperty(RelationProperty.class).isPresent()) {
                String varHashCode = String.valueOf(var.hashCode());
                roleTypes.put(varHashCode, new HashMap());
                ((RelationProperty)var.getProperty(RelationProperty.class).get()).getRelationPlayers().forEach(x -> ((Map)roleTypes.get(varHashCode)).put(x.getRolePlayer().getVarName(), x.getRoleType().isPresent() ? ((VarAdmin)x.getRoleType().get()).getPrintableName() : HAS_ROLE_EDGE));
            }
        });
        return roleTypes;
    }

    static Schema.BaseType getBaseType(Instance instance) {
        if (instance.isEntity()) {
            return Schema.BaseType.ENTITY;
        }
        if (instance.isRelation()) {
            return Schema.BaseType.RELATION;
        }
        if (instance.isResource()) {
            return Schema.BaseType.RESOURCE;
        }
        if (instance.isRule()) {
            return Schema.BaseType.RULE;
        }
        throw new RuntimeException("Unrecognized base type of " + instance);
    }

    static Schema.BaseType getBaseType(Type type) {
        if (type.isEntityType()) {
            return Schema.BaseType.ENTITY_TYPE;
        }
        if (type.isRelationType()) {
            return Schema.BaseType.RELATION_TYPE;
        }
        if (type.isResourceType()) {
            return Schema.BaseType.RESOURCE_TYPE;
        }
        if (type.isRuleType()) {
            return Schema.BaseType.RULE_TYPE;
        }
        if (type.isRoleType()) {
            return Schema.BaseType.ROLE_TYPE;
        }
        if (type.getName().equals(Schema.MetaSchema.CONCEPT.getName())) {
            return Schema.BaseType.TYPE;
        }
        throw new RuntimeException("Unrecognized base type of " + type);
    }
}

