/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern;

import ai.grakn.graql.admin.Conjunction;
import ai.grakn.graql.admin.Disjunction;
import ai.grakn.graql.admin.PatternAdmin;
import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.internal.pattern.Patterns;
import java.util.Set;
import java.util.stream.Collectors;

class DisjunctionImpl<T extends PatternAdmin>
implements Disjunction<T> {
    private final Set<T> patterns;

    DisjunctionImpl(Set<T> patterns) {
        this.patterns = patterns;
    }

    public Set<T> getPatterns() {
        return this.patterns;
    }

    public Disjunction<Conjunction<VarAdmin>> getDisjunctiveNormalForm() {
        Set dnf = this.patterns.stream().flatMap(p -> p.getDisjunctiveNormalForm().getPatterns().stream()).collect(Collectors.toSet());
        return Patterns.disjunction(dnf);
    }

    public boolean isDisjunction() {
        return true;
    }

    public Disjunction<?> asDisjunction() {
        return this;
    }

    public boolean equals(Object obj) {
        return obj instanceof DisjunctionImpl && this.patterns.equals(((DisjunctionImpl)obj).patterns);
    }

    public int hashCode() {
        return this.patterns.hashCode();
    }

    public String toString() {
        return this.patterns.stream().map(Object::toString).collect(Collectors.joining(" or "));
    }

    public PatternAdmin admin() {
        return this;
    }
}

