/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern.property;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.admin.VarProperty;
import ai.grakn.graql.internal.pattern.property.VarPropertyInternal;
import ai.grakn.graql.internal.query.InsertQueryExecutor;
import ai.grakn.graql.internal.util.CommonUtil;
import ai.grakn.util.ErrorMessage;
import java.util.stream.Stream;

abstract class AbstractVarProperty
implements VarPropertyInternal {
    AbstractVarProperty() {
    }

    @Override
    public final void checkValid(GraknGraph graph, VarAdmin var) throws IllegalStateException {
        this.checkValidProperty(graph, var);
        this.getInnerVars().map(VarAdmin::getTypeName).flatMap(CommonUtil::optionalToStream).forEach(name -> {
            if (graph.getType(name) == null) {
                throw new IllegalStateException(ErrorMessage.NAME_NOT_FOUND.getMessage(new Object[]{name}));
            }
        });
    }

    void checkValidProperty(GraknGraph graph, VarAdmin var) {
    }

    @Override
    public void insert(InsertQueryExecutor insertQueryExecutor, Concept concept) throws IllegalStateException {
    }

    @Override
    public void delete(GraknGraph graph, Concept concept) {
        throw AbstractVarProperty.failDelete(this);
    }

    public Stream<VarAdmin> getTypes() {
        return Stream.empty();
    }

    public Stream<VarAdmin> getImplicitInnerVars() {
        return this.getInnerVars();
    }

    static IllegalStateException failDelete(VarProperty property) {
        StringBuilder builder = new StringBuilder();
        property.buildString(builder);
        return new IllegalStateException(ErrorMessage.DELETE_UNSUPPORTED_PROPERTY.getMessage(new Object[]{builder.toString()}));
    }
}

