/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern.property;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.Instance;
import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.fragment.Fragments;
import ai.grakn.graql.internal.pattern.property.AbstractVarProperty;
import ai.grakn.graql.internal.pattern.property.NamedProperty;
import ai.grakn.graql.internal.query.InsertQueryExecutor;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.stream.Stream;

public class HasScopeProperty
extends AbstractVarProperty
implements NamedProperty {
    private final VarAdmin scope;

    public HasScopeProperty(VarAdmin scope) {
        this.scope = scope;
    }

    public VarAdmin getScope() {
        return this.scope;
    }

    @Override
    public String getName() {
        return "has-scope";
    }

    @Override
    public String getProperty() {
        return this.scope.getPrintableName();
    }

    @Override
    public Collection<EquivalentFragmentSet> match(String start) {
        return Sets.newHashSet((Object[])new EquivalentFragmentSet[]{EquivalentFragmentSet.create(Fragments.outHasScope(start, this.scope.getVarName()), Fragments.inHasScope(this.scope.getVarName(), start))});
    }

    @Override
    public Stream<VarAdmin> getInnerVars() {
        return Stream.of(this.scope);
    }

    @Override
    public void insert(InsertQueryExecutor insertQueryExecutor, Concept concept) throws IllegalStateException {
        Instance scopeInstance = insertQueryExecutor.getConcept(this.scope).asInstance();
        concept.asRelation().scope(scopeInstance);
    }

    @Override
    public void delete(GraknGraph graph, Concept concept) {
        String scopeId = (String)this.scope.getId().orElseThrow(() -> HasScopeProperty.failDelete(this));
        concept.asRelation().deleteScope((Instance)graph.getConcept(scopeId));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HasScopeProperty that = (HasScopeProperty)o;
        return this.scope.equals(that.scope);
    }

    public int hashCode() {
        return this.scope.hashCode();
    }
}

