/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern.property;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.graql.admin.UniqueVarProperty;
import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.ShortcutTraversal;
import ai.grakn.graql.internal.gremlin.fragment.Fragments;
import ai.grakn.graql.internal.pattern.property.AbstractVarProperty;
import ai.grakn.graql.internal.pattern.property.NamedProperty;
import ai.grakn.util.ErrorMessage;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;

public class IsaProperty
extends AbstractVarProperty
implements UniqueVarProperty,
NamedProperty {
    private final VarAdmin type;

    public IsaProperty(VarAdmin type) {
        this.type = type;
    }

    public VarAdmin getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return "isa";
    }

    @Override
    public String getProperty() {
        return this.type.getPrintableName();
    }

    @Override
    public void modifyShortcutTraversal(ShortcutTraversal shortcutTraversal) {
        Optional id = this.type.getId();
        if (id.isPresent()) {
            shortcutTraversal.setType((String)id.get());
        } else {
            shortcutTraversal.setInvalid();
        }
    }

    @Override
    public Collection<EquivalentFragmentSet> match(String start) {
        return Sets.newHashSet((Object[])new EquivalentFragmentSet[]{EquivalentFragmentSet.create(Fragments.outIsa(start, this.type.getVarName()), Fragments.inIsa(this.type.getVarName(), start))});
    }

    @Override
    public Stream<VarAdmin> getTypes() {
        return Stream.of(this.type);
    }

    @Override
    public Stream<VarAdmin> getInnerVars() {
        return Stream.of(this.type);
    }

    @Override
    public void checkValidProperty(GraknGraph graph, VarAdmin var) throws IllegalStateException {
        this.type.getTypeName().map(arg_0 -> ((GraknGraph)graph).getType(arg_0)).filter(Concept::isRoleType).ifPresent(type -> {
            throw new IllegalStateException(ErrorMessage.INSTANCE_OF_ROLE_TYPE.getMessage(new Object[]{type.getName()}));
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IsaProperty that = (IsaProperty)o;
        return this.type.equals(that.type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }
}

