/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern.property;

import ai.grakn.graql.admin.ValuePredicateAdmin;
import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.internal.gremlin.fragment.Fragment;
import ai.grakn.graql.internal.gremlin.fragment.Fragments;
import ai.grakn.graql.internal.pattern.property.AbstractVarProperty;
import ai.grakn.graql.internal.pattern.property.NamedProperty;
import ai.grakn.graql.internal.pattern.property.SingleFragmentProperty;
import ai.grakn.graql.internal.util.CommonUtil;
import ai.grakn.util.ErrorMessage;
import java.util.stream.Stream;

public class ValueProperty
extends AbstractVarProperty
implements NamedProperty,
SingleFragmentProperty {
    private final ValuePredicateAdmin predicate;

    public ValueProperty(ValuePredicateAdmin predicate) {
        this.predicate = predicate;
    }

    public ValuePredicateAdmin getPredicate() {
        return this.predicate;
    }

    @Override
    public String getName() {
        return "value";
    }

    @Override
    public String getProperty() {
        return this.predicate.toString();
    }

    @Override
    public Fragment getFragment(String start) {
        return Fragments.value(start, this.predicate);
    }

    @Override
    public void checkInsertable(VarAdmin var) {
        if (!this.predicate.equalsValue().isPresent()) {
            throw new IllegalStateException(ErrorMessage.INSERT_PREDICATE.getMessage(new Object[0]));
        }
    }

    @Override
    public Stream<VarAdmin> getInnerVars() {
        return CommonUtil.optionalToStream(this.predicate.getInnerVar());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueProperty that = (ValueProperty)o;
        return this.predicate.equals(that.predicate);
    }

    public int hashCode() {
        return this.predicate.hashCode();
    }
}

