/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.printer;

import ai.grakn.concept.Concept;
import ai.grakn.concept.Instance;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.RoleType;
import ai.grakn.concept.Type;
import ai.grakn.graql.Printer;
import ai.grakn.graql.internal.query.match.MatchQueryInternal;
import ai.grakn.graql.internal.util.ANSI;
import ai.grakn.graql.internal.util.CommonUtil;
import ai.grakn.graql.internal.util.StringConverter;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

class GraqlPrinter
implements Printer<Function<StringBuilder, StringBuilder>> {
    private final ResourceType[] resourceTypes;

    GraqlPrinter(ResourceType ... resourceTypes) {
        this.resourceTypes = resourceTypes;
    }

    public String build(Function<StringBuilder, StringBuilder> builder) {
        return builder.apply(new StringBuilder()).toString();
    }

    public Function<StringBuilder, StringBuilder> graqlString(boolean inner, Concept concept) {
        return sb -> {
            Type type;
            if (concept.isResource()) {
                sb.append(MatchQueryInternal.colorKeyword("value ")).append(StringConverter.valueToString(concept.asResource().getValue()));
            } else if (concept.isType()) {
                type = concept.asType();
                sb.append(MatchQueryInternal.colorKeyword("type-name ")).append(MatchQueryInternal.colorType(StringConverter.idToString(type.getName())));
                Type superType = type.superType();
                if (superType != null) {
                    sb.append(MatchQueryInternal.colorKeyword(" sub ")).append(MatchQueryInternal.colorType(StringConverter.idToString(superType.getName())));
                }
            } else {
                sb.append(MatchQueryInternal.colorKeyword("id ")).append(StringConverter.idToString(concept.getId()));
            }
            if (concept.isRelation()) {
                String relationString = concept.asRelation().rolePlayers().entrySet().stream().map(entry -> {
                    RoleType roleType = (RoleType)entry.getKey();
                    Instance rolePlayer = (Instance)entry.getValue();
                    if (rolePlayer != null) {
                        String s = MatchQueryInternal.colorType(StringConverter.idToString(roleType.getName())) + ": id " + StringConverter.idToString(rolePlayer.getId());
                        return Optional.of(s);
                    }
                    return Optional.empty();
                }).flatMap(CommonUtil::optionalToStream).collect(Collectors.joining(", "));
                sb.append(" (").append(relationString).append(")");
            }
            if (concept.isInstance()) {
                type = concept.asInstance().type();
                sb.append(MatchQueryInternal.colorKeyword(" isa ")).append(MatchQueryInternal.colorType(StringConverter.idToString(type.getName())));
            }
            if (concept.isRule()) {
                sb.append(MatchQueryInternal.colorKeyword(" lhs ")).append("{ ").append(concept.asRule().getLHS()).append(" }");
                sb.append(MatchQueryInternal.colorKeyword(" rhs ")).append("{ ").append(concept.asRule().getRHS()).append(" }");
            }
            if (concept.isInstance() && this.resourceTypes.length > 0) {
                concept.asInstance().resources(this.resourceTypes).forEach(resource -> {
                    String resourceType = MatchQueryInternal.colorType(StringConverter.idToString(resource.type().getName()));
                    String value = StringConverter.valueToString(resource.getValue());
                    sb.append(MatchQueryInternal.colorKeyword(" has ")).append(resourceType).append(" ").append(value);
                });
            }
            return sb;
        };
    }

    public Function<StringBuilder, StringBuilder> graqlString(boolean inner, boolean bool) {
        if (bool) {
            return sb -> sb.append(ANSI.color("True", "\u001b[32m"));
        }
        return sb -> sb.append(ANSI.color("False", "\u001b[31m"));
    }

    public Function<StringBuilder, StringBuilder> graqlString(boolean inner, Optional<?> optional) {
        if (optional.isPresent()) {
            return (Function)this.graqlString(inner, optional.get());
        }
        return sb -> sb.append("Nothing");
    }

    public Function<StringBuilder, StringBuilder> graqlString(boolean inner, Collection<?> collection) {
        return sb -> {
            if (inner) {
                sb.append("{");
                collection.stream().findFirst().ifPresent(item -> {
                    StringBuilder cfr_ignored_0 = (StringBuilder)((Function)this.graqlString(true, item)).apply(sb);
                });
                collection.stream().skip(1L).forEach(item -> {
                    StringBuilder cfr_ignored_0 = (StringBuilder)((Function)this.graqlString(true, item)).apply(sb.append(", "));
                });
                sb.append("}");
            } else {
                collection.forEach(item -> ((StringBuilder)((Function)this.graqlString(true, item)).apply(sb)).append("\n"));
            }
            return sb;
        };
    }

    public Function<StringBuilder, StringBuilder> graqlString(boolean inner, Map<?, ?> map) {
        if (!map.entrySet().isEmpty()) {
            Map.Entry<?, ?> entry = map.entrySet().iterator().next();
            if (entry.getKey() instanceof String && entry.getValue() instanceof Concept) {
                return sb -> {
                    map.forEach((name, concept) -> sb.append("$").append(name).append(" ").append(this.graqlString(concept)).append("; "));
                    return sb;
                };
            }
            return this.graqlString(inner, map.entrySet());
        }
        return sb -> sb.append("{}");
    }

    public Function<StringBuilder, StringBuilder> graqlStringDefault(boolean inner, Object object) {
        if (object instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)object;
            return ((Function)this.graqlString(true, entry.getKey())).andThen(sb -> sb.append(": ")).andThen((Function)this.graqlString(true, entry.getValue()));
        }
        return sb -> sb.append(object.toString());
    }
}

