/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.printer;

import ai.grakn.concept.Concept;
import ai.grakn.graql.Printer;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import mjson.Json;

class JsonPrinter
implements Printer<Json> {
    JsonPrinter() {
    }

    public String build(Json builder) {
        return builder.toString();
    }

    public Json graqlString(boolean inner, Concept concept) {
        Json json = Json.object((Object[])new Object[]{"id", concept.getId()});
        if (concept.isType()) {
            json.set("name", (Object)concept.asType().getName());
            json.set("sub", (Object)concept.asType().superType().getName());
        } else {
            json.set("isa", (Object)concept.asInstance().type().getName());
        }
        if (concept.isResource()) {
            json.set("value", concept.asResource().getValue());
        }
        if (concept.isRule()) {
            json.set("lhs", (Object)concept.asRule().getLHS().toString());
            json.set("rhs", (Object)concept.asRule().getRHS().toString());
        }
        return json;
    }

    public Json graqlString(boolean inner, boolean bool) {
        return Json.make((Object)bool);
    }

    public Json graqlString(boolean inner, Optional<?> optional) {
        return optional.map(item -> (Json)this.graqlString(inner, item)).orElse(null);
    }

    public Json graqlString(boolean inner, Collection<?> collection) {
        return Json.make(collection.stream().map(item -> (Json)this.graqlString(inner, item)).collect(Collectors.toList()));
    }

    public Json graqlString(boolean inner, Map<?, ?> map) {
        return Json.make((Object)Maps.transformValues(map, value -> (Json)this.graqlString(true, value)));
    }

    public Json graqlStringDefault(boolean inner, Object object) {
        return Json.make((Object)object);
    }
}

