/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.graql.DeleteQuery;
import ai.grakn.graql.MatchQuery;
import ai.grakn.graql.Printer;
import ai.grakn.graql.admin.DeleteQueryAdmin;
import ai.grakn.graql.admin.MatchQueryAdmin;
import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.internal.pattern.property.VarPropertyInternal;
import ai.grakn.graql.internal.query.Queries;
import ai.grakn.util.ErrorMessage;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.stream.Stream;

class DeleteQueryImpl
implements DeleteQueryAdmin {
    private final ImmutableMap<String, VarAdmin> deleters;
    private final MatchQueryAdmin matchQuery;

    DeleteQueryImpl(Collection<VarAdmin> deleters, MatchQuery matchQuery) {
        this.deleters = Maps.uniqueIndex(deleters, VarAdmin::getVarName);
        this.matchQuery = matchQuery.admin();
    }

    public Void execute() {
        this.matchQuery.execute().forEach(results -> results.forEach(this::deleteResult));
        return null;
    }

    public Stream<String> resultsString(Printer printer) {
        this.execute();
        return Stream.empty();
    }

    public boolean isReadOnly() {
        return false;
    }

    public DeleteQuery withGraph(GraknGraph graph) {
        return Queries.delete((Collection<VarAdmin>)this.deleters.values(), this.matchQuery.withGraph(graph));
    }

    public DeleteQueryAdmin admin() {
        return this;
    }

    private void deleteResult(String name, Concept result) {
        VarAdmin deleter = (VarAdmin)this.deleters.get((Object)name);
        if (deleter == null) {
            return;
        }
        if (!deleter.getProperties().findAny().isPresent()) {
            result.delete();
        } else {
            deleter.getProperties().forEach(property -> ((VarPropertyInternal)property).delete(this.getGraph(), result));
        }
    }

    private GraknGraph getGraph() {
        return (GraknGraph)this.matchQuery.getGraph().orElseThrow(() -> new IllegalStateException(ErrorMessage.NO_GRAPH.getMessage(new Object[0])));
    }

    public Collection<VarAdmin> getDeleters() {
        return this.deleters.values();
    }

    public MatchQuery getMatchQuery() {
        return this.matchQuery;
    }
}

